/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.maven.internal;

import com.google.common.base.Preconditions;
import java.io.File;
import java.util.Objects;

public class SourceFileTraversal {
    private final File root;

    public SourceFileTraversal(File root) {
        this.root = Objects.requireNonNull(root);
        Preconditions.checkArgument((boolean)root.exists(), (Object)"Root folder must exist");
        Preconditions.checkArgument((boolean)root.isDirectory(), (Object)"Root folder must be a folder");
    }

    public void traverse(Visitor visitor) {
        this.traverse("", this.root, visitor);
    }

    void traverse(String relativePath, File file, Visitor visitor) {
        File[] children;
        if (file.isFile()) {
            visitor.accept(relativePath, file);
        } else if (file.isDirectory() && (children = file.listFiles()) != null) {
            String childRelativePath;
            String string = childRelativePath = file.equals(this.root) ? "" : file.getName();
            if (relativePath.length() > 0) {
                childRelativePath = relativePath + File.separator + childRelativePath;
            }
            for (File child : children) {
                this.traverse(childRelativePath, child, visitor);
            }
        }
    }

    public static interface Visitor {
        public void accept(String var1, File var2);
    }
}

