/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.maven.internal;

import com.google.common.io.Files;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.eclipse.mylyn.wikitext.maven.internal.BuildFailureException;
import org.eclipse.mylyn.wikitext.maven.internal.FileToMarkupLanguage;
import org.eclipse.mylyn.wikitext.maven.internal.SourceFileTraversal;
import org.eclipse.mylyn.wikitext.parser.DocumentBuilder;
import org.eclipse.mylyn.wikitext.parser.MarkupParser;
import org.eclipse.mylyn.wikitext.parser.builder.HtmlDocumentBuilder;
import org.eclipse.mylyn.wikitext.parser.markup.MarkupLanguage;
import org.eclipse.mylyn.wikitext.parser.outline.OutlineItem;
import org.eclipse.mylyn.wikitext.parser.util.MarkupToEclipseToc;
import org.eclipse.mylyn.wikitext.splitter.DefaultSplittingStrategy;
import org.eclipse.mylyn.wikitext.splitter.NoSplittingStrategy;
import org.eclipse.mylyn.wikitext.splitter.SplitOutlineItem;
import org.eclipse.mylyn.wikitext.splitter.SplittingHtmlDocumentBuilder;
import org.eclipse.mylyn.wikitext.splitter.SplittingMarkupToEclipseToc;
import org.eclipse.mylyn.wikitext.splitter.SplittingOutlineParser;
import org.eclipse.mylyn.wikitext.splitter.SplittingStrategy;
import org.eclipse.mylyn.wikitext.util.ServiceLocator;

public class MarkupToEclipseHelpMojo
extends AbstractMojo {
    protected File outputFolder;
    protected File sourceFolder;
    protected String htmlFilenameFormat = "$1.html";
    protected String xmlFilenameFormat = "$1-toc.xml";
    protected String title;
    protected String linkRel;
    protected boolean multipleOutputFiles = false;
    private final String sourceEncoding = "utf-8";
    protected boolean formatOutput = false;
    protected boolean navigationImages = false;
    protected String prependImagePrefix = null;
    protected boolean useInlineCssStyles = true;
    protected boolean suppressBuiltInCssStyles = false;
    protected String defaultAbsoluteLinkTarget;
    protected boolean xhtmlStrict = false;
    protected boolean emitDoctype = true;
    protected String htmlDoctype = null;
    protected String copyrightNotice = null;
    protected List<String> stylesheetUrls = new ArrayList<String>();
    protected String helpPrefix;
    protected int tocAnchorLevel = 0;
    protected boolean embeddedTableOfContents = false;

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            this.ensureOutputFolderExists();
            this.ensureSourceFolderExists();
            ServiceLocator serviceLocator = ServiceLocator.getInstance((ClassLoader)MarkupToEclipseHelpMojo.class.getClassLoader());
            Set markupLanguages = serviceLocator.getAllMarkupLanguages();
            if (markupLanguages.isEmpty()) {
                throw new MojoFailureException("No markup languages are available");
            }
            this.getLog().info((CharSequence)MessageFormat.format("Generating Eclipse help content from sources: {0} -> {1}", this.sourceFolder, this.outputFolder));
            FileToMarkupLanguage fileToMarkupLanguage = new FileToMarkupLanguage(markupLanguages);
            SourceFileTraversal fileTraversal = new SourceFileTraversal(this.sourceFolder);
            AtomicInteger fileCount = new AtomicInteger();
            fileTraversal.traverse((relativePath, sourceFile) -> {
                fileCount.incrementAndGet();
                this.process(sourceFile, relativePath, fileToMarkupLanguage.get(sourceFile));
            });
            this.getLog().info((CharSequence)MessageFormat.format("Processed {0} files", fileCount.get()));
        }
        catch (BuildFailureException e) {
            this.getLog().error((CharSequence)e.getMessage(), (Throwable)e);
            throw new MojoFailureException(e.getMessage(), e.getCause());
        }
    }

    protected void process(File sourceFile, String relativePath, MarkupLanguage markupLanguage) {
        if (markupLanguage == null) {
            this.copy(sourceFile, relativePath);
        } else {
            this.processMarkup(sourceFile, relativePath, markupLanguage);
        }
    }

    private void copy(File sourceFile, String relativePath) {
        File targetFolder = new File(this.outputFolder, relativePath);
        this.ensureFolderExists("target folder", targetFolder, true);
        File targetFile = new File(targetFolder, sourceFile.getName());
        try {
            Files.copy((File)sourceFile, (File)targetFile);
        }
        catch (IOException e) {
            throw new BuildFailureException(MessageFormat.format("Cannot copy {0} to {1}: {2}", sourceFile, targetFile, e.getMessage()), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processMarkup(File sourceFile, String relativePath, MarkupLanguage markupLanguage) {
        File htmlOutputFile;
        this.getLog().info((CharSequence)MessageFormat.format("Processing markup file: {0}", sourceFile));
        String name = sourceFile.getName();
        if (name.lastIndexOf(46) != -1) {
            name = name.substring(0, name.lastIndexOf(46));
        }
        if (!(htmlOutputFile = this.computeHtmlFile(relativePath, name)).exists() || htmlOutputFile.lastModified() < sourceFile.lastModified()) {
            String markupContent = this.readFully(sourceFile);
            if (!htmlOutputFile.getParentFile().exists() && !htmlOutputFile.getParentFile().mkdirs()) {
                throw new BuildFailureException(MessageFormat.format("Cannot create folder {0}", htmlOutputFile.getParentFile()));
            }
            Writer writer = this.createWriter(htmlOutputFile);
            try {
                HtmlDocumentBuilder builder = this.createRootBuilder(writer, name, relativePath);
                SplittingStrategy splittingStrategy = this.createSplittingStrategy();
                SplittingOutlineParser outlineParser = this.createOutlineParser(markupLanguage, splittingStrategy);
                SplitOutlineItem rootTocItem = outlineParser.parse(markupContent);
                rootTocItem.setSplitTarget(htmlOutputFile.getName());
                SplittingHtmlDocumentBuilder splittingBuilder = this.createSplittingBuilder(builder, rootTocItem, htmlOutputFile, relativePath);
                MarkupParser parser = new MarkupParser();
                parser.setMarkupLanguage(markupLanguage);
                parser.setBuilder((DocumentBuilder)splittingBuilder);
                parser.parse(markupContent);
                this.createEclipseHelpToc(rootTocItem, sourceFile, relativePath, htmlOutputFile, name);
            }
            finally {
                this.close(writer, htmlOutputFile);
            }
        }
    }

    private void close(Writer writer, File file) {
        try {
            writer.close();
        }
        catch (IOException e) {
            throw new BuildFailureException(MessageFormat.format("Cannot write to file {0}: {1}", file, e.getMessage()));
        }
    }

    private void createEclipseHelpToc(SplitOutlineItem rootTocItem, File sourceFile, String relativePath, File htmlOutputFile, String name) {
        File tocOutputFile = this.computeTocFile(htmlOutputFile, name);
        if (!tocOutputFile.exists() || tocOutputFile.lastModified() < sourceFile.lastModified()) {
            Writer writer = this.createWriter(tocOutputFile);
            try {
                MarkupToEclipseToc toEclipseToc = this.createMarkupToEclipseToc(relativePath, htmlOutputFile, name);
                String tocXml = toEclipseToc.createToc((OutlineItem)rootTocItem);
                writer.write(tocXml);
            }
            catch (IOException e) {
                throw new BuildFailureException(MessageFormat.format("Cannot write to file {0}: {1}", tocOutputFile, e.getMessage()), e);
            }
            finally {
                this.close(writer, tocOutputFile);
            }
        }
    }

    protected MarkupToEclipseToc createMarkupToEclipseToc(String relativePath, File htmlOutputFile, String name) {
        SplittingMarkupToEclipseToc toEclipseToc = new SplittingMarkupToEclipseToc();
        toEclipseToc.setBookTitle(this.title == null ? name : this.title);
        toEclipseToc.setCopyrightNotice(this.copyrightNotice);
        toEclipseToc.setAnchorLevel(this.tocAnchorLevel);
        toEclipseToc.setHelpPrefix(this.calculateHelpPrefix(relativePath));
        toEclipseToc.setHtmlFile(htmlOutputFile.getName());
        return toEclipseToc;
    }

    protected String calculateHelpPrefix(String relativePath) {
        String prefix;
        String string = prefix = this.helpPrefix == null ? "" : this.helpPrefix;
        if (relativePath.length() > 0) {
            if (prefix.length() > 0) {
                prefix = prefix + "/";
            }
            prefix = prefix + relativePath;
        }
        return prefix.length() == 0 ? null : prefix.replaceAll("\\\\", "/");
    }

    private File computeTocFile(File htmlFile, String name) {
        return new File(htmlFile.getParentFile(), this.xmlFilenameFormat.replace("$1", name));
    }

    protected SplittingHtmlDocumentBuilder createSplittingBuilder(HtmlDocumentBuilder builder, SplitOutlineItem item, File htmlOutputFile, String relativePath) {
        SplittingHtmlDocumentBuilder splittingBuilder = new SplittingHtmlDocumentBuilder();
        splittingBuilder.setRootBuilder(builder);
        splittingBuilder.setOutline(item);
        splittingBuilder.setEmbeddedTableOfContents(this.embeddedTableOfContents);
        splittingBuilder.setRootFile(htmlOutputFile);
        splittingBuilder.setNavigationImages(this.navigationImages);
        splittingBuilder.setNavigationImagePath(this.computeResourcePath(splittingBuilder.getNavigationImagePath(), relativePath));
        splittingBuilder.setFormatting(this.formatOutput);
        return splittingBuilder;
    }

    private SplittingOutlineParser createOutlineParser(MarkupLanguage markupLanguage, SplittingStrategy splittingStrategy) {
        SplittingOutlineParser outlineParser = new SplittingOutlineParser();
        outlineParser.setMarkupLanguage(markupLanguage.clone());
        outlineParser.setSplittingStrategy(splittingStrategy);
        return outlineParser;
    }

    private SplittingStrategy createSplittingStrategy() {
        DefaultSplittingStrategy splittingStrategy = this.multipleOutputFiles ? new DefaultSplittingStrategy() : new NoSplittingStrategy();
        return splittingStrategy;
    }

    protected HtmlDocumentBuilder createRootBuilder(Writer writer, String name, String relativePath) {
        HtmlDocumentBuilder builder = new HtmlDocumentBuilder(writer, this.formatOutput);
        builder.setTitle(this.title == null ? name : this.title);
        builder.setEmitDtd(this.emitDoctype);
        if (this.emitDoctype && this.htmlDoctype != null) {
            builder.setHtmlDtd(this.htmlDoctype);
        }
        builder.setUseInlineStyles(this.useInlineCssStyles);
        builder.setSuppressBuiltInStyles(this.suppressBuiltInCssStyles);
        builder.setLinkRel(this.linkRel);
        builder.setDefaultAbsoluteLinkTarget(this.defaultAbsoluteLinkTarget);
        builder.setPrependImagePrefix(this.prependImagePrefix);
        builder.setXhtmlStrict(this.xhtmlStrict);
        builder.setCopyrightNotice(this.copyrightNotice);
        builder.setHtmlFilenameFormat(this.htmlFilenameFormat);
        this.configureStylesheets(builder, relativePath);
        return builder;
    }

    protected void configureStylesheets(HtmlDocumentBuilder builder, String relativePath) {
        for (String cssStylesheetUrl : this.stylesheetUrls) {
            builder.addCssStylesheet(new HtmlDocumentBuilder.Stylesheet(this.computeResourcePath(cssStylesheetUrl, relativePath)));
        }
    }

    protected String computeResourcePath(String resourcePath, String relativePath) {
        if (resourcePath.startsWith("/") || this.isAbsoluteUri(resourcePath)) {
            return resourcePath;
        }
        String path = resourcePath;
        String prefix = relativePath.replaceAll("[^\\\\/]+", "..").replace('\\', '/');
        if (prefix.length() > 0) {
            if (!resourcePath.startsWith("/")) {
                prefix = prefix + '/';
            }
            path = prefix + resourcePath;
        }
        return path;
    }

    private boolean isAbsoluteUri(String resourcePath) {
        try {
            return new URI(resourcePath).getScheme() != null;
        }
        catch (URISyntaxException e) {
            throw new BuildFailureException(MessageFormat.format("\"{0}\" is not a valid URI", resourcePath), e);
        }
    }

    private Writer createWriter(File outputFile) {
        OutputStreamWriter writer;
        try {
            writer = new OutputStreamWriter((OutputStream)new BufferedOutputStream(new FileOutputStream(outputFile)), StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new BuildFailureException(MessageFormat.format("Cannot write to file {0}: {1}", outputFile, e.getMessage()), e);
        }
        return writer;
    }

    protected File computeHtmlFile(String relativePath, String name) {
        File parent = this.outputFolder;
        if (relativePath.length() > 0) {
            parent = new File(parent, relativePath);
        }
        return new File(parent, this.htmlFilenameFormat.replace("$1", name));
    }

    protected void ensureSourceFolderExists() {
        this.ensureFolderExists("Source folder", this.sourceFolder, false);
    }

    protected void ensureOutputFolderExists() {
        this.ensureFolderExists("Output folder", this.outputFolder, true);
    }

    protected void ensureFolderExists(String name, File folder, boolean createIfMissing) {
        if (folder.exists()) {
            if (!folder.isDirectory()) {
                throw new BuildFailureException(MessageFormat.format("{0} exists but is not a folder: {1}", name, folder));
            }
            return;
        }
        if (!createIfMissing) {
            throw new BuildFailureException(MessageFormat.format("{0} does not exist: {1}", name, folder));
        }
        if (!folder.mkdirs()) {
            throw new BuildFailureException(MessageFormat.format("Cannot create {0}: {1}", name, folder));
        }
    }

    protected String readFully(File inputFile) {
        try {
            return Files.toString((File)inputFile, (Charset)Charset.forName("utf-8"));
        }
        catch (IOException e) {
            throw new BuildFailureException(MessageFormat.format("Cannot read source file {0}: {1}", inputFile, e.getMessage()), e);
        }
    }
}

