/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.commonmark.internal;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.eclipse.mylyn.wikitext.commonmark.internal.CommonMarkIdGenerationStrategy;
import org.eclipse.mylyn.wikitext.commonmark.internal.InlineContent;
import org.eclipse.mylyn.wikitext.commonmark.internal.ProcessingContext;
import org.eclipse.mylyn.wikitext.commonmark.internal.inlines.InlineParser;
import org.eclipse.mylyn.wikitext.parser.IdGenerator;
import org.eclipse.mylyn.wikitext.parser.markup.IdGenerationStrategy;

public class ProcessingContextBuilder {
    private final Map<String, ProcessingContext.NamedUriWithTitle> linkByName = new HashMap<String, ProcessingContext.NamedUriWithTitle>();
    private IdGenerationStrategy idGenerationStrategy = new CommonMarkIdGenerationStrategy();
    private InlineParser inlineParser;

    public ProcessingContextBuilder referenceDefinition(String name, String href, String title) {
        String key;
        if (!Strings.isNullOrEmpty((String)name) && !this.linkByName.containsKey(key = name.toLowerCase(Locale.ROOT))) {
            this.linkByName.put(key, new ProcessingContext.NamedUriWithTitle(name, href, title));
        }
        return this;
    }

    public ProcessingContextBuilder idGenerationStrategy(IdGenerationStrategy idGenerationStrategy) {
        this.idGenerationStrategy = idGenerationStrategy;
        return this;
    }

    public ProcessingContext build() {
        return new ProcessingContext(this.getInlineParser(), (ImmutableMap<String, ProcessingContext.NamedUriWithTitle>)ImmutableMap.copyOf(this.linkByName), this.idGenerator());
    }

    public ProcessingContextBuilder inlineParser(InlineParser inlineParser) {
        this.inlineParser = inlineParser;
        return this;
    }

    public InlineParser getInlineParser() {
        return this.inlineParser == null ? InlineContent.commonMarkStrict() : this.inlineParser;
    }

    private IdGenerator idGenerator() {
        if (this.idGenerationStrategy == null) {
            return new IdGenerator(){

                public String newId(String type, String text) {
                    return null;
                }
            };
        }
        IdGenerator generator = new IdGenerator();
        generator.setGenerationStrategy(this.idGenerationStrategy);
        return generator;
    }

    ProcessingContextBuilder() {
    }
}

