/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.commonmark.internal;

import com.google.common.base.Predicate;
import java.util.regex.Pattern;
import org.eclipse.mylyn.wikitext.commonmark.internal.Line;

public class LinePredicates {
    public static Predicate<Line> empty() {
        return new Predicate<Line>(){

            public String toString() {
                return "empty(line)";
            }

            public boolean apply(Line input) {
                return input != null && input.isEmpty();
            }
        };
    }

    public static Predicate<Line> matches(final Pattern pattern) {
        return new Predicate<Line>(){

            public String toString() {
                return "matches(" + pattern.pattern() + ")";
            }

            public boolean apply(Line input) {
                return input != null && pattern.matcher(input.getText()).matches();
            }
        };
    }

    private LinePredicates() {
    }
}

