/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.bugzilla.ui.tasklist;

import org.eclipse.mylyn.internal.bugzilla.core.BugzillaTask;
import org.eclipse.mylyn.internal.bugzilla.ui.editor.BugzillaTaskEditor;
import org.eclipse.mylyn.internal.bugzilla.ui.editor.NewBugzillaTaskEditor;
import org.eclipse.mylyn.internal.bugzilla.ui.tasklist.BugzillaTaskEditorInput;
import org.eclipse.mylyn.tasks.core.AbstractTask;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.tasks.ui.editors.AbstractTaskEditorFactory;
import org.eclipse.mylyn.tasks.ui.editors.RepositoryTaskEditorInput;
import org.eclipse.mylyn.tasks.ui.editors.TaskEditor;
import org.eclipse.mylyn.tasks.ui.editors.TaskEditorInput;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.part.EditorPart;

public class BugzillaTaskEditorFactory
extends AbstractTaskEditorFactory {
    private static final String TITLE = "Bugzilla";

    public EditorPart createEditor(TaskEditor parentEditor, IEditorInput editorInput) {
        Object editor = null;
        if (editorInput instanceof RepositoryTaskEditorInput) {
            RepositoryTaskEditorInput taskInput = (RepositoryTaskEditorInput)editorInput;
            editor = taskInput.getTaskData().isNew() ? new NewBugzillaTaskEditor((FormEditor)parentEditor) : new BugzillaTaskEditor((FormEditor)parentEditor);
        } else if (editorInput instanceof TaskEditorInput) {
            editor = new BugzillaTaskEditor((FormEditor)parentEditor);
        }
        return editor;
    }

    public IEditorInput createEditorInput(AbstractTask task) {
        if (task instanceof BugzillaTask) {
            BugzillaTask bugzillaTask = (BugzillaTask)task;
            TaskRepository repository = TasksUiPlugin.getRepositoryManager().getRepository("bugzilla", bugzillaTask.getRepositoryUrl());
            BugzillaTaskEditorInput input = new BugzillaTaskEditorInput(repository, bugzillaTask, true);
            return input;
        }
        return null;
    }

    public String getTitle() {
        return TITLE;
    }

    public boolean canCreateEditorFor(AbstractTask task) {
        return task instanceof BugzillaTask;
    }

    public boolean providesOutline() {
        return true;
    }

    public boolean canCreateEditorFor(IEditorInput input) {
        if (input instanceof RepositoryTaskEditorInput) {
            return "bugzilla".equals(((RepositoryTaskEditorInput)input).getRepository().getConnectorKind());
        }
        return false;
    }
}

