/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.bugzilla.ui.tasklist;

import org.eclipse.mylyn.internal.bugzilla.core.BugzillaRepositoryQuery;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiImages;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.search.AbstractRepositoryQueryPage;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class BugzillaCustomQueryWizardPage
extends AbstractRepositoryQueryPage {
    private static final String LABEL_CUSTOM_QUERY = "Enter query URL";
    private static final String TITLE = "Create query from URL";
    private Text queryText;
    private Composite composite;
    private BugzillaRepositoryQuery query;

    public BugzillaCustomQueryWizardPage(TaskRepository repository, BugzillaRepositoryQuery query) {
        super(TITLE, query.getSummary());
        this.query = query;
        this.repository = repository;
        this.setTitle(LABEL_CUSTOM_QUERY);
        this.setImageDescriptor(TasksUiImages.BANNER_REPOSITORY);
    }

    public BugzillaCustomQueryWizardPage(TaskRepository repository) {
        super(TITLE);
        this.repository = repository;
        this.setTitle(LABEL_CUSTOM_QUERY);
        this.setImageDescriptor(TasksUiImages.BANNER_REPOSITORY);
    }

    public void createControl(Composite parent) {
        this.composite = new Composite(parent, 0);
        this.composite.setLayout((Layout)new GridLayout());
        super.createControl(this.composite);
        this.createCustomQueryGroup(this.composite);
        this.composite.pack();
        this.setControl((Control)this.composite);
    }

    private void createCustomQueryGroup(Composite composite) {
        Group group = new Group(composite, 0);
        group.setText(LABEL_CUSTOM_QUERY);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        group.setLayout((Layout)layout);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        gd.widthHint = 300;
        group.setLayoutData((Object)gd);
        this.queryText = new Text((Composite)group, 2048);
        gd = new GridData(768);
        this.queryText.setLayoutData((Object)gd);
        if (this.query != null) {
            this.queryText.setText(this.query.getUrl());
        }
        this.queryText.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
            }

            public void keyReleased(KeyEvent e) {
                BugzillaCustomQueryWizardPage.this.setPageComplete(BugzillaCustomQueryWizardPage.this.canFlipToNextPage());
            }
        });
    }

    public boolean canFlipToNextPage() {
        return false;
    }

    public BugzillaRepositoryQuery getQuery() {
        if (this.query == null) {
            this.query = new BugzillaRepositoryQuery(this.repository.getUrl(), this.queryText.getText(), this.getQueryTitle());
            this.query.setCustomQuery(true);
        } else {
            this.query.setHandleIdentifier(this.getQueryTitle());
            this.query.setUrl(this.queryText.getText());
        }
        return this.query;
    }
}

