/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.bugzilla.ui.tasklist;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaReportElement;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaRepositoryQuery;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaTask;
import org.eclipse.mylyn.internal.bugzilla.ui.BugzillaImages;
import org.eclipse.mylyn.internal.bugzilla.ui.search.BugzillaSearchPage;
import org.eclipse.mylyn.internal.bugzilla.ui.tasklist.BugzillaRepositorySettingsPage;
import org.eclipse.mylyn.internal.bugzilla.ui.tasklist.EditBugzillaQueryWizard;
import org.eclipse.mylyn.internal.bugzilla.ui.tasklist.NewBugzillaQueryWizard;
import org.eclipse.mylyn.internal.bugzilla.ui.wizard.NewBugzillaTaskWizard;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryQuery;
import org.eclipse.mylyn.tasks.core.AbstractTask;
import org.eclipse.mylyn.tasks.core.AbstractTaskContainer;
import org.eclipse.mylyn.tasks.core.RepositoryTaskData;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.AbstractRepositoryConnectorUi;
import org.eclipse.mylyn.tasks.ui.TaskHyperlink;
import org.eclipse.mylyn.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.tasks.ui.search.AbstractRepositoryQueryPage;
import org.eclipse.mylyn.tasks.ui.wizards.AbstractRepositorySettingsPage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BugzillaConnectorUi
extends AbstractRepositoryConnectorUi {
    private static final int TASK_NUM_GROUP = 3;
    private static final String regexp = "(duplicate of|bug|task)(\\s#|#|#\\s|\\s|)(\\s\\d+|\\d+)";
    private static final Pattern PATTERN = Pattern.compile("(duplicate of|bug|task)(\\s#|#|#\\s|\\s|)(\\s\\d+|\\d+)", 2);

    public String getAccountCreationUrl(TaskRepository taskRepository) {
        return String.valueOf(taskRepository.getUrl()) + "/createaccount.cgi";
    }

    public String getAccountManagementUrl(TaskRepository taskRepository) {
        return String.valueOf(taskRepository.getUrl()) + "/userprefs.cgi";
    }

    public List<AbstractTaskContainer> getLegendItems() {
        ArrayList<AbstractTaskContainer> legendItems = new ArrayList<AbstractTaskContainer>();
        BugzillaTask blocker = new BugzillaTask("", "critical", "Critical, Blocker");
        blocker.setSeverity("critical");
        legendItems.add((AbstractTaskContainer)blocker);
        BugzillaTask major = new BugzillaTask("", "major", "Major");
        major.setSeverity("major");
        legendItems.add((AbstractTaskContainer)major);
        BugzillaTask enhancement = new BugzillaTask("", "enhancement", "Enhancement");
        enhancement.setSeverity("enhancement");
        legendItems.add((AbstractTaskContainer)enhancement);
        BugzillaTask trivial = new BugzillaTask("", "trivial", "Trivial, Minor");
        trivial.setSeverity("trivial");
        legendItems.add((AbstractTaskContainer)trivial);
        return legendItems;
    }

    public ImageDescriptor getTaskKindOverlay(AbstractTask task) {
        BugzillaTask bugzillaTask;
        String severity;
        if (task instanceof BugzillaTask && (severity = (bugzillaTask = (BugzillaTask)task).getSeverity()) != null) {
            if ("blocker".equals(severity) || "critical".equals(severity)) {
                return BugzillaImages.OVERLAY_CRITICAL;
            }
            if ("major".equals(severity)) {
                return BugzillaImages.OVERLAY_MAJOR;
            }
            if ("enhancement".equals(severity)) {
                return BugzillaImages.OVERLAY_ENHANCEMENT;
            }
            if ("trivial".equals(severity) || "minor".equals(severity)) {
                return BugzillaImages.OVERLAY_MINOR;
            }
            return null;
        }
        return super.getTaskKindOverlay(task);
    }

    public IHyperlink[] findHyperlinks(TaskRepository repository, String text, int lineOffset, int regionOffset) {
        ArrayList<IHyperlink> hyperlinksFound = new ArrayList<IHyperlink>();
        Matcher m = PATTERN.matcher(text);
        while (m.find()) {
            IHyperlink link;
            if (lineOffset < m.start() || lineOffset > m.end() || (link = BugzillaConnectorUi.extractHyperlink(repository, regionOffset, m)) == null) continue;
            hyperlinksFound.add(link);
        }
        if (hyperlinksFound.size() > 0) {
            return hyperlinksFound.toArray(new IHyperlink[1]);
        }
        return null;
    }

    private static IHyperlink extractHyperlink(TaskRepository repository, int regionOffset, Matcher m) {
        int start = -1;
        start = m.group().startsWith("duplicate") ? m.start() + m.group().indexOf(m.group(3)) : m.start();
        int end = m.end();
        if (end == -1) {
            end = m.group().length();
        }
        try {
            String bugId = m.group(3).trim();
            Region sregion = new Region(start += regionOffset, (end += regionOffset) - start);
            return new TaskHyperlink((IRegion)sregion, repository, bugId);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    public String getTaskKindLabel(AbstractTask repositoryTask) {
        return "Bug";
    }

    public String getTaskKindLabel(RepositoryTaskData taskData) {
        return "Bug";
    }

    public AbstractRepositorySettingsPage getSettingsPage() {
        return new BugzillaRepositorySettingsPage(this);
    }

    public AbstractRepositoryQueryPage getSearchPage(TaskRepository repository, IStructuredSelection selection) {
        return new BugzillaSearchPage(repository);
    }

    public IWizard getNewTaskWizard(TaskRepository taskRepository) {
        return new NewBugzillaTaskWizard(taskRepository);
    }

    public IWizard getQueryWizard(TaskRepository repository, AbstractRepositoryQuery query) {
        if (query instanceof BugzillaRepositoryQuery) {
            return new EditBugzillaQueryWizard(repository, (BugzillaRepositoryQuery)query);
        }
        return new NewBugzillaQueryWizard(repository);
    }

    public boolean hasSearchPage() {
        return true;
    }

    public String getConnectorKind() {
        return "bugzilla";
    }

    public boolean supportsDueDates(AbstractTask task) {
        RepositoryTaskData taskData;
        if (task instanceof BugzillaTask && (taskData = TasksUiPlugin.getTaskDataManager().getNewTaskData(task.getRepositoryUrl(), task.getTaskId())) != null && taskData.getAttribute(BugzillaReportElement.ESTIMATED_TIME.getKeyString()) != null) {
            return true;
        }
        return super.supportsDueDates(task);
    }
}

