/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.bugzilla.ui.editor;

import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.mylyn.tasks.core.RepositoryTaskAttribute;
import org.eclipse.mylyn.tasks.ui.AbstractDuplicateDetector;
import org.eclipse.mylyn.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.tasks.ui.editors.AbstractNewRepositoryTaskEditor;
import org.eclipse.mylyn.tasks.ui.editors.AbstractRepositoryTaskEditor;
import org.eclipse.mylyn.tasks.ui.search.SearchHitCollector;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.fieldassist.ContentAssistCommandAdapter;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NewBugzillaTaskEditor
extends AbstractNewRepositoryTaskEditor {
    private static final int WRAP_LENGTH = 90;

    public NewBugzillaTaskEditor(FormEditor editor) {
        super(editor);
    }

    public void init(IEditorSite site, IEditorInput input) {
        super.init(site, input);
        this.setExpandAttributeSection(true);
    }

    protected void saveTaskOffline(IProgressMonitor progressMonitor) {
        String text = this.descriptionTextViewer.getTextWidget().getText();
        if (this.repository.getVersion().startsWith("2.18")) {
            text = NewBugzillaTaskEditor.formatTextToLineWrap(text, true);
            this.descriptionTextViewer.getTextWidget().setText(text);
        }
        super.saveTaskOffline(progressMonitor);
    }

    protected void createPeopleLayout(Composite composite) {
        FormToolkit toolkit = this.getManagedForm().getToolkit();
        Section peopleSection = this.createSection(composite, this.getSectionLabel(AbstractRepositoryTaskEditor.SECTION_NAME.PEOPLE_SECTION));
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)peopleSection);
        Composite peopleComposite = toolkit.createComposite((Composite)peopleSection);
        GridLayout layout = new GridLayout(2, false);
        layout.marginRight = 5;
        peopleComposite.setLayout((Layout)layout);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)peopleComposite);
        Label label = toolkit.createLabel(peopleComposite, "Assign to:");
        GridDataFactory.fillDefaults().align(131072, 0x1000000).applyTo((Control)label);
        Composite textFieldComposite = toolkit.createComposite(peopleComposite);
        GridLayout textLayout = new GridLayout();
        textFieldComposite.setLayout((Layout)textLayout);
        RepositoryTaskAttribute attribute = this.taskData.getAttribute("task.common.user.assigned");
        Text textField = this.createTextField(textFieldComposite, attribute, 0x800000);
        toolkit.paintBordersFor(textFieldComposite);
        GridDataFactory.fillDefaults().hint(150, -1).applyTo((Control)textField);
        peopleSection.setClient((Control)peopleComposite);
        ContentAssistCommandAdapter adapter = this.applyContentAssist(textField, this.createContentProposalProvider(attribute));
        ILabelProvider propsalLabelProvider = this.createProposalLabelProvider(attribute);
        if (propsalLabelProvider != null) {
            adapter.setLabelProvider(propsalLabelProvider);
        }
        adapter.setProposalAcceptanceStyle(2);
        toolkit.paintBordersFor(peopleComposite);
    }

    public SearchHitCollector getDuplicateSearchCollector(String name) {
        String duplicateDetectorName = name.equals("default") ? "Stack Trace" : name;
        Set<AbstractDuplicateDetector> allDetectors = this.getDuplicateSearchCollectorsList();
        for (AbstractDuplicateDetector detector : allDetectors) {
            if (!detector.getName().equals(duplicateDetectorName)) continue;
            return detector.getSearchHitCollector(this.repository, this.taskData);
        }
        return null;
    }

    protected Set<AbstractDuplicateDetector> getDuplicateSearchCollectorsList() {
        return TasksUiPlugin.getDefault().getDuplicateSearchCollectorsList();
    }

    public void submitToRepository() {
        if (this.summaryText.getText().equals("")) {
            MessageDialog.openInformation((Shell)this.getSite().getShell(), (String)"Submit Error", (String)"Please provide a brief summary with new reports.");
            this.summaryText.setFocus();
            return;
        }
        if (this.descriptionTextViewer.getTextWidget().getText().equals("")) {
            MessageDialog.openInformation((Shell)this.getSite().getShell(), (String)"Submit Error", (String)"Please proved a detailed summary with new reports");
            this.descriptionTextViewer.getTextWidget().setFocus();
            return;
        }
        super.submitToRepository();
    }

    private static String formatTextToLineWrap(String origText, boolean hardWrap) {
        if (!hardWrap) {
            return origText;
        }
        String[] textArray = new String[(origText.length() / 90 + 1) * 2];
        int i = 0;
        while (i < textArray.length) {
            textArray[i] = null;
            ++i;
        }
        int j = 0;
        while (true) {
            int spaceIndex;
            if ((spaceIndex = origText.indexOf(" ", 85)) == origText.length() || spaceIndex == -1) break;
            textArray[j] = origText.substring(0, spaceIndex);
            origText = origText.substring(spaceIndex + 1, origText.length());
            ++j;
        }
        textArray[j] = origText;
        String newText = "";
        int i2 = 0;
        while (i2 < textArray.length) {
            if (textArray[i2] == null) break;
            newText = String.valueOf(newText) + textArray[i2] + "\n";
            ++i2;
        }
        return newText;
    }
}

