/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.rest.client.tck.cditests;

import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.inject.Inject;
import jakarta.ws.rs.ApplicationPath;
import jakarta.ws.rs.core.Application;
import java.lang.annotation.Annotation;
import org.eclipse.microprofile.rest.client.inject.RestClient;
import org.eclipse.microprofile.rest.client.tck.interfaces.cdi.scoped.AutoCloseableClient;
import org.eclipse.microprofile.rest.client.tck.interfaces.cdi.scoped.CloseableClient;
import org.eclipse.microprofile.rest.client.tck.interfaces.cdi.scoped.StringClient;
import org.eclipse.microprofile.rest.client.tck.interfaces.cdi.scoped.StringClientRequestFilter;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ClientClosedTest
extends Arquillian {
    @Inject
    BeanManager beanManager;

    @Deployment
    public static Archive<?> createDeployment() {
        return ((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)(ClientClosedTest.class.getSimpleName() + ".war"))).addClasses(new Class[]{StringClientRequestFilter.class, AutoCloseableClient.class, CloseableClient.class, StringClient.class, RestActivator.class})).addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
    }

    @Test
    public void stringClosed() {
        this.checkClient(StringClient.class);
    }

    @Test
    public void autoCloseableClosed() {
        this.checkClient(AutoCloseableClient.class);
    }

    @Test
    public void closeableClosed() {
        this.checkClient(CloseableClient.class);
    }

    private <T extends StringClient> void checkClient(Class<T> type) {
        Bean<T> resolved = this.lookup(type);
        CreationalContext ctx = this.beanManager.createCreationalContext(resolved);
        StringClient client = (StringClient)resolved.create(ctx);
        Assert.assertNotNull((Object)client);
        Assert.assertTrue((boolean)client.executeGet().startsWith("GET: "));
        resolved.destroy((Object)client, ctx);
        Assert.expectThrows((String)"Expected an IllegalStateException to be thrown", IllegalStateException.class, client::executeGet);
    }

    private <T> Bean<T> lookup(Class<T> type) {
        return this.beanManager.resolve(this.beanManager.getBeans(type, new Annotation[]{RestClient.LITERAL}));
    }

    @ApplicationPath(value="/")
    public static class RestActivator
    extends Application {
    }
}

