/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.rest.client.tck.cditests;

import com.github.tomakehurst.wiremock.client.MappingBuilder;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.matching.RequestPatternBuilder;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import javax.inject.Inject;
import javax.ws.rs.core.Response;
import org.eclipse.microprofile.rest.client.inject.RestClient;
import org.eclipse.microprofile.rest.client.tck.WiremockArquillianTest;
import org.eclipse.microprofile.rest.client.tck.interfaces.ClientWithURI;
import org.eclipse.microprofile.rest.client.tck.interfaces.ClientWithURI2;
import org.eclipse.microprofile.rest.client.tck.interfaces.SimpleGetApi;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.testng.Assert;
import org.testng.annotations.Test;

public class CDIURIvsURLConfigTest
extends WiremockArquillianTest {
    @Inject
    @RestClient
    private SimpleGetApi api;
    @Inject
    @RestClient
    private ClientWithURI clientWithURI;
    @Inject
    @RestClient
    private ClientWithURI2 clientWithURI2;

    @Deployment
    public static WebArchive createDeployment() {
        String uriPropertyName = SimpleGetApi.class.getName() + "/mp-rest/uri";
        String uriValue = CDIURIvsURLConfigTest.getStringURL() + "uri";
        String urlPropertyName = SimpleGetApi.class.getName() + "/mp-rest/url";
        String urlValue = CDIURIvsURLConfigTest.getStringURL() + "url";
        String overridePropName = ClientWithURI2.class.getName() + "/mp-rest/uri";
        String overridePropValue = "http://localhost:9876/someOtherBaseUri";
        String simpleName = CDIURIvsURLConfigTest.class.getSimpleName();
        JavaArchive jar = (JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)(simpleName + ".jar"))).addClasses(new Class[]{ClientWithURI.class, ClientWithURI2.class, SimpleGetApi.class, WiremockArquillianTest.class})).addAsManifestResource((Asset)new StringAsset(String.format(uriPropertyName + "=" + uriValue + "%n" + urlPropertyName + "=" + urlValue + "%n" + overridePropName + "=" + overridePropValue, new Object[0])), "microprofile-config.properties")).addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
        return (WebArchive)((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)(simpleName + ".war"))).addAsLibrary((Archive)jar)).addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
    }

    @Test
    public void testURItakesPrecedenceOverURL() throws Exception {
        String expectedBody = "Hello, MicroProfile URI!!";
        WireMock.stubFor((MappingBuilder)WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/uri")).willReturn(WireMock.aResponse().withBody(expectedBody)));
        WireMock.stubFor((MappingBuilder)WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/url")).willReturn(WireMock.aResponse().withBody("Using URL instead of URI")));
        Response response = this.api.executeGet();
        String body = (String)response.readEntity(String.class);
        response.close();
        Assert.assertEquals((String)body, (String)expectedBody);
        WireMock.verify((int)1, (RequestPatternBuilder)WireMock.getRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/uri")));
    }

    @Test
    public void testBaseUriInRegisterRestClientAnnotation() throws Exception {
        Assert.assertEquals((String)this.clientWithURI.get(), (String)"GET http://localhost:5017/myBaseUri/hello");
    }

    @Test
    public void testMPConfigURIOverridesBaseUriInRegisterRestClientAnnotation() throws Exception {
        Assert.assertEquals((String)this.clientWithURI2.get(), (String)"GET http://localhost:9876/someOtherBaseUri/hi");
    }
}

