/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.rest.client.tck;

import com.github.tomakehurst.wiremock.client.MappingBuilder;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import java.net.URI;
import java.security.AccessController;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.ProcessingException;
import org.eclipse.microprofile.rest.client.RestClientBuilder;
import org.eclipse.microprofile.rest.client.tck.WiremockArquillianTest;
import org.eclipse.microprofile.rest.client.tck.interfaces.SimpleGetApi;
import org.testng.Assert;
import org.testng.annotations.Test;

public abstract class TimeoutTestBase
extends WiremockArquillianTest {
    private static final String UNUSED_URL = AccessController.doPrivileged(() -> System.getProperty("org.eclipse.microprofile.rest.client.tck.unusedURL", "http://microprofile.io:1234/null"));

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expectedExceptions={ProcessingException.class})
    public void testConnectTimeout() throws Exception {
        SimpleGetApi simpleGetApi = (SimpleGetApi)RestClientBuilder.newBuilder().baseUri(URI.create(UNUSED_URL)).connectTimeout(5L, TimeUnit.SECONDS).build(SimpleGetApi.class);
        long startTime = System.nanoTime();
        try {
            simpleGetApi.executeGet();
            Assert.fail((String)"A ProcessingException should have been thrown to indicate a timeout");
        }
        finally {
            long elapsedTime = System.nanoTime() - startTime;
            long elapsedSecs = TimeUnit.SECONDS.convert(elapsedTime, TimeUnit.NANOSECONDS);
            this.checkTimeElapsed(5L, 15L, elapsedSecs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expectedExceptions={ProcessingException.class})
    public void testReadTimeout() throws Exception {
        WireMock.stubFor((MappingBuilder)WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/")).willReturn(WireMock.aResponse().withStatus(200).withFixedDelay(Integer.valueOf(30000))));
        SimpleGetApi simpleGetApi = (SimpleGetApi)RestClientBuilder.newBuilder().baseUri(TimeoutTestBase.getServerURI()).readTimeout(5L, TimeUnit.SECONDS).build(SimpleGetApi.class);
        long startTime = System.nanoTime();
        try {
            simpleGetApi.executeGet();
            Assert.fail((String)"A ProcessingException should have been thrown due to a read timeout");
        }
        finally {
            long elapsedTime = System.nanoTime() - startTime;
            long elapsedSecs = TimeUnit.SECONDS.convert(elapsedTime, TimeUnit.NANOSECONDS);
            this.checkTimeElapsed(5L, 15L, elapsedSecs);
        }
    }

    protected abstract void checkTimeElapsed(long var1, long var3, long var5);
}

