/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.rest.client.tck.providers;

import org.eclipse.microprofile.rest.client.ext.AsyncInvocationInterceptor;
import org.eclipse.microprofile.rest.client.tck.providers.TLAsyncInvocationInterceptorFactory;

public class TLAsyncInvocationInterceptor
implements AsyncInvocationInterceptor {
    private final TLAsyncInvocationInterceptorFactory factory;
    private final Integer tlValue;

    TLAsyncInvocationInterceptor(TLAsyncInvocationInterceptorFactory factory, Integer tlValue) {
        this.factory = factory;
        this.tlValue = tlValue;
    }

    public void prepareContext() {
        this.factory.getData().put("preThreadId", Thread.currentThread().getId());
    }

    public void applyContext() {
        this.factory.getData().put("postThreadId", Thread.currentThread().getId());
        if (TLAsyncInvocationInterceptorFactory.getTlInt() != 0) {
            System.out.println("Using recycled thread - with non-default ThreadLocal settings.");
            TLAsyncInvocationInterceptorFactory.setTlInt(-1);
            return;
        }
        TLAsyncInvocationInterceptorFactory.setTlInt(this.tlValue);
    }
}

