/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.rest.client.tck;

import com.github.tomakehurst.wiremock.client.MappingBuilder;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.matching.ContentPattern;
import com.github.tomakehurst.wiremock.matching.RequestPatternBuilder;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import java.util.List;
import javax.inject.Inject;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.ws.rs.core.Response;
import org.eclipse.microprofile.rest.client.RestClientBuilder;
import org.eclipse.microprofile.rest.client.tck.WiremockArquillianTest;
import org.eclipse.microprofile.rest.client.tck.interfaces.JsonPClient;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.testng.Assert;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

public class InvokeWithJsonPProviderTest
extends WiremockArquillianTest {
    private static final String CDI = "cdi";
    private static final String BUILT = "built";
    @Inject
    private JsonPClient cdiJsonPClient;
    private JsonPClient builtJsonPClient;

    @Deployment
    public static WebArchive createDeployment() {
        StringAsset mpConfig = new StringAsset(JsonPClient.class.getName() + "/mp-rest/url=" + InvokeWithJsonPProviderTest.getStringURL());
        return (WebArchive)((WebArchive)((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)(InvokeWithJsonPProviderTest.class.getSimpleName() + ".war"))).addClass(JsonPClient.class)).addAsWebInfResource((Asset)EmptyAsset.INSTANCE, "beans.xml")).addAsWebInfResource((Asset)mpConfig, "classes/META-INF/microprofile-config.properties");
    }

    @BeforeTest
    public void setupClient() throws Exception {
        this.builtJsonPClient = (JsonPClient)RestClientBuilder.newBuilder().baseUrl(InvokeWithJsonPProviderTest.getServerURL()).build(JsonPClient.class);
    }

    @Test
    public void testGetExecutesForBothClients() {
        this.testGet(this.builtJsonPClient, BUILT);
        this.testGet(this.cdiJsonPClient, CDI);
    }

    @Test
    public void testGetSingleExecutesForBothClients() {
        this.testGetSingle(this.builtJsonPClient, BUILT);
        this.testGetSingle(this.cdiJsonPClient, CDI);
    }

    @Test
    public void testPostExecutes() {
        this.testPost(this.builtJsonPClient, BUILT);
        this.testPost(this.cdiJsonPClient, CDI);
    }

    @Test
    public void testPutExecutes() {
        this.testPut(this.builtJsonPClient, BUILT);
        this.testPut(this.cdiJsonPClient, CDI);
    }

    private void testGet(JsonPClient client, String clientType) {
        WireMock.reset();
        WireMock.stubFor((MappingBuilder)WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/")).willReturn(WireMock.aResponse().withHeader("Content-Type", new String[]{"application/json"}).withBody("[{\"key\": \"value\"}, {\"key\": \"anotherValue\"}]")));
        JsonArray jsonArray = client.get();
        Assert.assertEquals((int)jsonArray.size(), (int)2, (String)("Expected 2 values in the array for client " + clientType));
        List jsonObjects = jsonArray.getValuesAs(JsonObject.class);
        JsonObject one = (JsonObject)jsonObjects.get(0);
        Assert.assertEquals((int)one.keySet().size(), (int)1, (String)("There should only be one key in object 1 for client " + clientType));
        Assert.assertEquals((String)one.getString("key"), (String)"value", (String)("The value of 'key' on object 1 should be 'value' in client " + clientType));
        JsonObject two = (JsonObject)jsonObjects.get(1);
        Assert.assertEquals((int)two.keySet().size(), (int)1, (String)("There should only be one key in object 2 for client " + clientType));
        Assert.assertEquals((String)two.getString("key"), (String)"anotherValue", (String)("The value of 'key' on object 2 should be 'anotherValue' in client " + clientType));
    }

    private void testGetSingle(JsonPClient client, String clientType) {
        WireMock.reset();
        WireMock.stubFor((MappingBuilder)WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/id")).willReturn(WireMock.aResponse().withHeader("Content-Type", new String[]{"application/json"}).withBody("{\"key\": \"value\"}")));
        JsonObject jsonObject = client.get("id");
        Assert.assertEquals((int)jsonObject.keySet().size(), (int)1, (String)("There should only be one key in object for client " + clientType));
        Assert.assertEquals((String)jsonObject.getString("key"), (String)"value", (String)("The value of 'key' on object should be 'value' in client " + clientType));
    }

    private void testPost(JsonPClient client, String clientType) {
        WireMock.reset();
        WireMock.stubFor((MappingBuilder)WireMock.post((UrlPattern)WireMock.urlEqualTo((String)"/")).willReturn(WireMock.aResponse().withHeader("Content-Type", new String[]{"application/json"}).withStatus(200)));
        JsonObject jsonObject = Json.createObjectBuilder().add("someKey", "newValue").build();
        String jsonObjectAsString = jsonObject.toString();
        Response response = client.post(jsonObject);
        response.close();
        Assert.assertEquals((int)response.getStatus(), (int)200, (String)("Expected a 200 OK on client " + clientType));
        WireMock.verify((int)1, (RequestPatternBuilder)WireMock.postRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/")).withRequestBody((ContentPattern)WireMock.equalTo((String)jsonObjectAsString)));
    }

    private void testPut(JsonPClient client, String clientType) {
        WireMock.reset();
        WireMock.stubFor((MappingBuilder)WireMock.put((UrlPattern)WireMock.urlEqualTo((String)"/id")).willReturn(WireMock.aResponse().withHeader("Content-Type", new String[]{"application/json"}).withStatus(200).withBody("{\"someOtherKey\":\"newValue\"}")));
        JsonObject jsonObject = Json.createObjectBuilder().add("someKey", "newValue").build();
        String jsonObjectAsString = jsonObject.toString();
        JsonObject response = client.update("id", jsonObject);
        Assert.assertEquals((String)response.getString("someOtherKey"), (String)"newValue", (String)("The value of 'someOtherKey' on response should be 'someOtherKey' in client " + clientType));
        WireMock.verify((int)1, (RequestPatternBuilder)WireMock.putRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/id")).withRequestBody((ContentPattern)WireMock.equalTo((String)jsonObjectAsString)));
    }
}

