/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.openapi.tck;

import java.beans.Introspector;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.microprofile.openapi.OASFactory;
import org.eclipse.microprofile.openapi.models.Components;
import org.eclipse.microprofile.openapi.models.Constructible;
import org.eclipse.microprofile.openapi.models.Extensible;
import org.eclipse.microprofile.openapi.models.ExternalDocumentation;
import org.eclipse.microprofile.openapi.models.OpenAPI;
import org.eclipse.microprofile.openapi.models.Operation;
import org.eclipse.microprofile.openapi.models.PathItem;
import org.eclipse.microprofile.openapi.models.Paths;
import org.eclipse.microprofile.openapi.models.Reference;
import org.eclipse.microprofile.openapi.models.callbacks.Callback;
import org.eclipse.microprofile.openapi.models.examples.Example;
import org.eclipse.microprofile.openapi.models.headers.Header;
import org.eclipse.microprofile.openapi.models.info.Contact;
import org.eclipse.microprofile.openapi.models.info.Info;
import org.eclipse.microprofile.openapi.models.info.License;
import org.eclipse.microprofile.openapi.models.links.Link;
import org.eclipse.microprofile.openapi.models.media.Content;
import org.eclipse.microprofile.openapi.models.media.Discriminator;
import org.eclipse.microprofile.openapi.models.media.Encoding;
import org.eclipse.microprofile.openapi.models.media.MediaType;
import org.eclipse.microprofile.openapi.models.media.Schema;
import org.eclipse.microprofile.openapi.models.media.XML;
import org.eclipse.microprofile.openapi.models.parameters.Parameter;
import org.eclipse.microprofile.openapi.models.parameters.RequestBody;
import org.eclipse.microprofile.openapi.models.responses.APIResponse;
import org.eclipse.microprofile.openapi.models.responses.APIResponses;
import org.eclipse.microprofile.openapi.models.security.OAuthFlow;
import org.eclipse.microprofile.openapi.models.security.OAuthFlows;
import org.eclipse.microprofile.openapi.models.security.Scopes;
import org.eclipse.microprofile.openapi.models.security.SecurityRequirement;
import org.eclipse.microprofile.openapi.models.security.SecurityScheme;
import org.eclipse.microprofile.openapi.models.servers.Server;
import org.eclipse.microprofile.openapi.models.servers.ServerVariable;
import org.eclipse.microprofile.openapi.models.servers.ServerVariables;
import org.eclipse.microprofile.openapi.models.tags.Tag;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ModelConstructionTest
extends Arquillian {
    @Deployment
    public static WebArchive createDeployment() {
        return (WebArchive)ShrinkWrap.create(WebArchive.class);
    }

    @Test
    public void componentsTest() {
        Components c = this.processConstructible(Components.class);
        String callbackKey = "myCallback";
        Callback callbackValue = this.createConstructibleInstance(Callback.class);
        this.checkSameObject(c, c.addCallback("myCallback", callbackValue));
        this.checkMapEntry(c.getCallbacks(), "myCallback", callbackValue);
        String exampleKey = "myExample";
        Example exampleValue = this.createConstructibleInstance(Example.class);
        this.checkSameObject(c, c.addExample("myExample", exampleValue));
        this.checkMapEntry(c.getExamples(), "myExample", exampleValue);
        String headerKey = "myHeader";
        Header headerValue = this.createConstructibleInstance(Header.class);
        this.checkSameObject(c, c.addHeader("myHeader", headerValue));
        this.checkMapEntry(c.getHeaders(), "myHeader", headerValue);
        String linkKey = "myLink";
        Link linkValue = this.createConstructibleInstance(Link.class);
        this.checkSameObject(c, c.addLink("myLink", linkValue));
        this.checkMapEntry(c.getLinks(), "myLink", linkValue);
        String parameterKey = "myParameter";
        Parameter parameterValue = this.createConstructibleInstance(Parameter.class);
        this.checkSameObject(c, c.addParameter("myParameter", parameterValue));
        this.checkMapEntry(c.getParameters(), "myParameter", parameterValue);
        String requestBodyKey = "myRequestBody";
        RequestBody requestBodyValue = this.createConstructibleInstance(RequestBody.class);
        this.checkSameObject(c, c.addRequestBody("myRequestBody", requestBodyValue));
        this.checkMapEntry(c.getRequestBodies(), "myRequestBody", requestBodyValue);
        String responseKey = "myResponse";
        APIResponse responseValue = this.createConstructibleInstance(APIResponse.class);
        this.checkSameObject(c, c.addResponse("myResponse", responseValue));
        this.checkMapEntry(c.getResponses(), "myResponse", responseValue);
        String schemaKey = "mySchema";
        Schema schemaValue = this.createConstructibleInstance(Schema.class);
        this.checkSameObject(c, c.addSchema("mySchema", schemaValue));
        this.checkMapEntry(c.getSchemas(), "mySchema", schemaValue);
        String securitySchemeKey = "mySecurityScheme";
        SecurityScheme securitySchemeValue = this.createConstructibleInstance(SecurityScheme.class);
        this.checkSameObject(c, c.addSecurityScheme("mySecurityScheme", securitySchemeValue));
        this.checkMapEntry(c.getSecuritySchemes(), "mySecurityScheme", securitySchemeValue);
    }

    @Test
    public void externalDocumentationTest() {
        this.processConstructible(ExternalDocumentation.class);
    }

    @Test
    public void openAPITest() {
        OpenAPI o = this.processConstructible(OpenAPI.class);
        SecurityRequirement sr = this.createConstructibleInstance(SecurityRequirement.class);
        this.checkSameObject(o, o.addSecurityRequirement(sr));
        this.checkListEntry(o.getSecurity(), sr);
        Server s = this.createConstructibleInstance(Server.class);
        this.checkSameObject(o, o.addServer(s));
        this.checkListEntry(o.getServers(), s);
        Tag t = this.createConstructibleInstance(Tag.class);
        this.checkSameObject(o, o.addTag(t));
        this.checkListEntry(o.getTags(), t);
    }

    @Test
    public void operationTest() {
        Operation o = this.processConstructible(Operation.class);
        Parameter p = this.createConstructibleInstance(Parameter.class);
        this.checkSameObject(o, o.addParameter(p));
        this.checkListEntry(o.getParameters(), p);
        SecurityRequirement sr = this.createConstructibleInstance(SecurityRequirement.class);
        this.checkSameObject(o, o.addSecurityRequirement(sr));
        this.checkListEntry(o.getSecurity(), sr);
        Server s = this.createConstructibleInstance(Server.class);
        this.checkSameObject(o, o.addServer(s));
        this.checkListEntry(o.getServers(), s);
        String tag = new String("myTag");
        this.checkSameObject(o, o.addTag(tag));
        this.checkListEntry(o.getTags(), tag);
    }

    @Test
    public void pathItemTest() {
        PathItem pi = this.processConstructible(PathItem.class);
        Parameter p = this.createConstructibleInstance(Parameter.class);
        this.checkSameObject(pi, pi.addParameter(p));
        this.checkListEntry(pi.getParameters(), p);
        Server s = this.createConstructibleInstance(Server.class);
        this.checkSameObject(pi, pi.addServer(s));
        this.checkListEntry(pi.getServers(), s);
    }

    @Test
    public void pathsTest() {
        Paths p = this.processConstructible(Paths.class);
        String pathItemKey = "myPathItem";
        PathItem pathItemValue = this.createConstructibleInstance(PathItem.class);
        this.checkSameObject(p, p.addPathItem("myPathItem", pathItemValue));
        this.checkMapEntry((Map)p, "myPathItem", (Object)pathItemValue);
        String pathItemKey2 = "myPathItem2";
        PathItem pathItemValue2 = this.createConstructibleInstance(PathItem.class);
        Assert.assertNull((Object)p.put((Object)"myPathItem2", (Object)pathItemValue2), (String)"No previous mapping expected.");
        this.checkMapEntry((Map)p, "myPathItem2", (Object)pathItemValue2);
        Assert.assertEquals((int)p.size(), (int)2, (String)"The map is expected to contain two entries.");
    }

    @Test
    public void callbackTest() {
        Callback c = this.processConstructible(Callback.class);
        String pathItemKey = "myPathItem";
        PathItem pathItemValue = this.createConstructibleInstance(PathItem.class);
        this.checkSameObject(c, c.addPathItem("myPathItem", pathItemValue));
        this.checkMapEntry((Map)c, "myPathItem", (Object)pathItemValue);
        String pathItemKey2 = "myPathItem2";
        PathItem pathItemValue2 = this.createConstructibleInstance(PathItem.class);
        Assert.assertNull((Object)c.put((Object)"myPathItem2", (Object)pathItemValue2), (String)"No previous mapping expected.");
        this.checkMapEntry((Map)c, "myPathItem2", (Object)pathItemValue2);
        Assert.assertEquals((int)c.size(), (int)2, (String)"The map is expected to contain two entries.");
    }

    @Test
    public void exampleTest() {
        this.processConstructible(Example.class);
    }

    @Test
    public void headerTest() {
        Header h = this.processConstructible(Header.class);
        String exampleKey = "myExample";
        Example exampleValue = this.createConstructibleInstance(Example.class);
        this.checkSameObject(h, h.addExample("myExample", exampleValue));
        this.checkMapEntry(h.getExamples(), "myExample", exampleValue);
    }

    @Test
    public void contactTest() {
        this.processConstructible(Contact.class);
    }

    @Test
    public void infoTest() {
        this.processConstructible(Info.class);
    }

    @Test
    public void licenseTest() {
        this.processConstructible(License.class);
    }

    @Test
    public void linkTest() {
        Link l = this.processConstructible(Link.class);
        String parameterKey = "myParameter";
        Parameter parameterValue = this.createConstructibleInstance(Parameter.class);
        this.checkSameObject(l, l.addParameter("myParameter", (Object)parameterValue));
        this.checkMapEntry(l.getParameters(), "myParameter", parameterValue);
    }

    @Test
    public void contentTest() {
        Content c = this.processConstructible(Content.class);
        String mediaTypeKey = "myPathItem";
        MediaType mediaTypeValue = this.createConstructibleInstance(MediaType.class);
        this.checkSameObject(c, c.addMediaType("myPathItem", mediaTypeValue));
        this.checkMapEntry((Map)c, "myPathItem", (Object)mediaTypeValue);
        String mediaTypeKey2 = "myPathItem2";
        MediaType mediaTypeValue2 = this.createConstructibleInstance(MediaType.class);
        Assert.assertNull((Object)c.put((Object)"myPathItem2", (Object)mediaTypeValue2), (String)"No previous mapping expected.");
        this.checkMapEntry((Map)c, "myPathItem2", (Object)mediaTypeValue2);
        Assert.assertEquals((int)c.size(), (int)2, (String)"The map is expected to contain two entries.");
    }

    @Test
    public void discriminatorTest() {
        Discriminator d = this.processConstructible(Discriminator.class);
        String key = "myKey";
        String value = new String("myValue");
        this.checkSameObject(d, d.addMapping("myKey", value));
        this.checkMapEntry(d.getMapping(), "myKey", value);
    }

    @Test
    public void encodingTest() {
        this.processConstructible(Encoding.class);
    }

    @Test
    public void mediaTypeTest() {
        MediaType mt = this.processConstructible(MediaType.class);
        String encodingKey = "myEncoding";
        Encoding encodingValue = this.createConstructibleInstance(Encoding.class);
        this.checkSameObject(mt, mt.addEncoding("myEncoding", encodingValue));
        this.checkMapEntry(mt.getEncoding(), "myEncoding", encodingValue);
        String exampleKey = "myExample";
        Example exampleValue = this.createConstructibleInstance(Example.class);
        this.checkSameObject(mt, mt.addExample("myExample", exampleValue));
        this.checkMapEntry(mt.getExamples(), "myExample", exampleValue);
    }

    @Test
    public void schemaTest() {
        Schema s = this.processConstructible(Schema.class);
        Schema allOf = this.createConstructibleInstance(Schema.class);
        this.checkSameObject(s, s.addAllOf(allOf));
        this.checkListEntry(s.getAllOf(), allOf);
        Schema anyOf = this.createConstructibleInstance(Schema.class);
        this.checkSameObject(s, s.addAnyOf(anyOf));
        this.checkListEntry(s.getAnyOf(), anyOf);
        String enumeration = new String("enumValue");
        this.checkSameObject(s, s.addEnumeration((Object)enumeration));
        this.checkListEntry(s.getEnumeration(), enumeration);
        Schema oneOf = this.createConstructibleInstance(Schema.class);
        this.checkSameObject(s, s.addOneOf(oneOf));
        this.checkListEntry(s.getOneOf(), oneOf);
        String propertySchemaKey = "myPropertySchemaKey";
        Schema propertySchemaValue = this.createConstructibleInstance(Schema.class);
        this.checkSameObject(s, s.addProperty("myPropertySchemaKey", propertySchemaValue));
        this.checkMapEntry(s.getProperties(), "myPropertySchemaKey", propertySchemaValue);
        String required = new String("required");
        this.checkSameObject(s, s.addRequired(required));
        this.checkListEntry(s.getRequired(), required);
    }

    @Test
    public void xmlTest() {
        this.processConstructible(XML.class);
    }

    @Test
    public void parameterTest() {
        Parameter p = this.processConstructible(Parameter.class);
        String exampleKey = "myExample";
        Example exampleValue = this.createConstructibleInstance(Example.class);
        this.checkSameObject(p, p.addExample("myExample", exampleValue));
        this.checkMapEntry(p.getExamples(), "myExample", exampleValue);
    }

    @Test
    public void requestBodyTest() {
        this.processConstructible(RequestBody.class);
    }

    @Test
    public void apiResponseTest() {
        APIResponse response = this.processConstructible(APIResponse.class);
        String headerKey = "myHeaderKey";
        Header headerValue = this.createConstructibleInstance(Header.class);
        this.checkSameObject(response, response.addHeader("myHeaderKey", headerValue));
        this.checkMapEntry(response.getHeaders(), "myHeaderKey", headerValue);
        String linkKey = "myLinkKey";
        Link linkValue = this.createConstructibleInstance(Link.class);
        this.checkSameObject(response, response.addLink("myLinkKey", linkValue));
        this.checkMapEntry(response.getLinks(), "myLinkKey", linkValue);
    }

    @Test
    public void apiResponsesTest() {
        APIResponses responses = this.processConstructible(APIResponses.class);
        String responseKey = "myResponse";
        APIResponse responseValue = this.createConstructibleInstance(APIResponse.class);
        this.checkSameObject(responses, responses.addApiResponse("myResponse", responseValue));
        this.checkMapEntry((Map)responses, "myResponse", (Object)responseValue);
        String responseKey2 = "myResponse2";
        APIResponse responseValue2 = this.createConstructibleInstance(APIResponse.class);
        Assert.assertNull((Object)responses.put((Object)"myResponse2", (Object)responseValue2), (String)"No previous mapping expected.");
        this.checkMapEntry((Map)responses, "myResponse2", (Object)responseValue2);
        Assert.assertEquals((int)responses.size(), (int)2, (String)"The map is expected to contain two entries.");
    }

    @Test
    public void oAuthFlowTest() {
        this.processConstructible(OAuthFlow.class);
    }

    @Test
    public void oAuthFlowsTest() {
        this.processConstructible(OAuthFlows.class);
    }

    @Test
    public void scopesTest() {
        Scopes s = this.processConstructible(Scopes.class);
        String scopeKey = "myScope";
        String scopeValue = new String("myDescription");
        this.checkSameObject(s, s.addScope("myScope", scopeValue));
        this.checkMapEntry((Map)s, "myScope", (Object)scopeValue);
        String scopeKey2 = "myScope2";
        String scopeValue2 = new String("myDescription2");
        Assert.assertNull((Object)s.put((Object)"myScope2", (Object)scopeValue2), (String)"No previous mapping expected.");
        this.checkMapEntry((Map)s, "myScope2", (Object)scopeValue2);
        Assert.assertEquals((int)s.size(), (int)2, (String)"The map is expected to contain two entries.");
    }

    @Test
    public void securityRequirementTest() {
        SecurityRequirement sr = this.processConstructible(SecurityRequirement.class);
        String schemeKey = "myResponse";
        ArrayList schemeValue = new ArrayList();
        this.checkSameObject(sr, sr.addScheme("myResponse", schemeValue));
        this.checkMapEntry((Map)sr, "myResponse", (Object)schemeValue);
        String schemeKey2 = "myResponse2";
        ArrayList schemeValue2 = new ArrayList();
        Assert.assertNull((Object)sr.put((Object)"myResponse2", schemeValue2), (String)"No previous mapping expected.");
        this.checkMapEntry((Map)sr, "myResponse2", (Object)schemeValue2);
        Assert.assertEquals((int)sr.size(), (int)2, (String)"The map is expected to contain two entries.");
    }

    @Test
    public void securitySchemeTest() {
        this.processConstructible(SecurityScheme.class);
    }

    @Test
    public void serverTest() {
        this.processConstructible(Server.class);
    }

    @Test
    public void serverVariableTest() {
        ServerVariable sv = this.processConstructible(ServerVariable.class);
        String enumeration = new String("enumValue");
        this.checkSameObject(sv, sv.addEnumeration(enumeration));
        this.checkListEntry(sv.getEnumeration(), enumeration);
    }

    @Test
    public void serverVariablesTest() {
        ServerVariables svs = this.processConstructible(ServerVariables.class);
        String varKey = "myServerVariable";
        ServerVariable varValue = this.createConstructibleInstance(ServerVariable.class);
        this.checkSameObject(svs, svs.addServerVariable("myServerVariable", varValue));
        this.checkMapEntry((Map)svs, "myServerVariable", (Object)varValue);
        String varKey2 = "myServerVariable2";
        ServerVariable varValue2 = this.createConstructibleInstance(ServerVariable.class);
        Assert.assertNull((Object)svs.put((Object)"myServerVariable2", (Object)varValue2), (String)"No previous mapping expected.");
        this.checkMapEntry((Map)svs, "myServerVariable2", (Object)varValue2);
        Assert.assertEquals((int)svs.size(), (int)2, (String)"The map is expected to contain two entries.");
    }

    @Test
    public void tagTest() {
        this.processConstructible(Tag.class);
    }

    private <T extends Constructible> T processConstructible(Class<T> clazz) {
        Object o = this.createConstructibleInstance(clazz);
        if (o instanceof Extensible && Extensible.class.isAssignableFrom(clazz)) {
            this.processExtensible((Extensible)o);
        }
        if (o instanceof Reference && Reference.class.isAssignableFrom(clazz)) {
            this.processReference((Reference)o);
        }
        Map<String, Property> properties = this.collectProperties(clazz);
        properties.values().stream().filter(p -> p.isComplete()).forEach(p -> this.processConstructibleProperty((Constructible)o, (Property)p, clazz));
        return o;
    }

    private <T extends Constructible> T createConstructibleInstance(Class<T> clazz) {
        Constructible o1 = OASFactory.createObject(clazz);
        Assert.assertNotNull((Object)o1, (String)("The return value of OASFactory.createObject(" + clazz.getName() + ") must not be null."));
        Assert.assertTrue((boolean)clazz.isInstance(o1), (String)("The return value of OASFactory.createObject() is expected to be an instance of: " + clazz.getName()));
        Constructible o2 = OASFactory.createObject(clazz);
        Assert.assertNotNull((Object)o2, (String)("The return value of OASFactory.createObject(" + clazz.getName() + ") must not be null."));
        Assert.assertTrue((boolean)clazz.isInstance(o2), (String)("The return value of OASFactory.createObject() is expected to be an instance of: " + clazz.getName()));
        Assert.assertNotSame((Object)o2, (Object)o1, (String)("OASFactory.createObject(" + clazz.getName() + ") is expected to create a new object on each invocation."));
        return (T)o1;
    }

    private void processExtensible(Extensible e) {
        String extensionName1 = "x-" + e.getClass().getName() + "-1";
        Object obj1 = new Object();
        String extensionName2 = "x-" + e.getClass().getName() + "-2";
        Object obj2 = new Object();
        e.addExtension(extensionName1, obj1);
        e.addExtension(extensionName2, obj2);
        Map map = e.getExtensions();
        Assert.assertEquals((int)map.size(), (int)2, (String)"The extensions map is expected to contain two entries.");
        Assert.assertTrue((boolean)map.containsKey(extensionName1), (String)("The extensions map is expected to contain the key: " + extensionName1));
        Assert.assertTrue((boolean)map.containsKey(extensionName2), (String)("The extensions map is expected to contain the key: " + extensionName2));
        Assert.assertSame(map.get(extensionName1), (Object)obj1, (String)("The value associated with the key: " + extensionName1 + " is expected to be the same one that was added."));
        Assert.assertSame(map.get(extensionName2), (Object)obj2, (String)("The value associated with the key: " + extensionName2 + " is expected to be the same one that was added."));
        HashMap newMap = new HashMap();
        e.setExtensions(newMap);
        Map map2 = e.getExtensions();
        Assert.assertEquals((int)map2.size(), (int)0, (String)"The extensions map is expected to contain no entries.");
        Assert.assertSame((Object)map2, newMap, (String)"The return value of getExtensions() is expected to be the same value that was set.");
    }

    private void processReference(Reference<?> r) {
        String myRef1 = this.createReference(r, "myRef1");
        r.setRef(myRef1);
        Assert.assertEquals((String)r.getRef(), (String)myRef1, (String)"The return value of getRef() is expected to be equal to the value that was set.");
        if (!(r instanceof PathItem)) {
            String shortName = "myRef2";
            String myRef2 = this.createReference(r, "myRef2");
            r.setRef("myRef2");
            Assert.assertEquals((String)r.getRef(), (String)myRef2, (String)"The return value of getRef() is expected to be a fully expanded name.");
        }
        String myRef3 = this.createReference(r, "myRef3");
        Reference self = r.ref(myRef3);
        Assert.assertSame((Object)self, r, (String)"The return value of ref() is expected to return the current instance.");
        Assert.assertEquals((String)r.getRef(), (String)myRef3, (String)"The return value of getRef() is expected to be equal to the value that was set.");
        if (!(r instanceof PathItem)) {
            String shortName = "myRef4";
            String myRef4 = this.createReference(r, "myRef4");
            Reference self2 = r.ref("myRef4");
            Assert.assertSame((Object)self2, r, (String)"The return value of ref() is expected to return the current instance.");
            Assert.assertEquals((String)r.getRef(), (String)myRef4, (String)"The return value of getRef() is expected to be a fully expanded name.");
        }
    }

    private void processConstructibleProperty(Constructible o, Property p, Class<?> enclosingInterface) {
        Object value1 = this.getInstanceOf(p.getType(), false);
        p.invokeSetter(o, value1);
        if (!p.isPrimitive()) {
            Assert.assertSame((Object)p.invokeGetter(o), (Object)value1, (String)("The return value of the getter method for property \"" + p.getName() + "\" of interface \"" + enclosingInterface.getName() + "\" is expected to be the same as the value that was set."));
        } else {
            Assert.assertEquals((Object)p.invokeGetter(o), (Object)value1, (String)("The return value of the getter method for property \"" + p.getName() + "\" of interface \"" + enclosingInterface.getName() + "\" is expected to be equal to the value that was set."));
        }
        if (p.hasBuilder()) {
            Object value2 = this.getInstanceOf(p.getType(), true);
            Object self = p.invokeBuilder(o, value2);
            Assert.assertSame((Object)self, (Object)o, (String)("The return value of the builder method for property \"" + p.getName() + "\" of interface \"" + enclosingInterface.getName() + "\" is expected to be the same as the value that was set."));
            if (!p.isPrimitive()) {
                Assert.assertSame((Object)p.invokeGetter(o), (Object)value2, (String)("The return value of the getter method for property \"" + p.getName() + "\" of interface \"" + enclosingInterface.getName() + "\" is expected to be the same as the value that was set."));
            } else {
                Assert.assertEquals((Object)p.invokeGetter(o), (Object)value2, (String)("The return value of the getter method for property \"" + p.getName() + "\" of interface \"" + enclosingInterface.getName() + "\" is expected to be equal to the value that was set."));
            }
        }
    }

    private Object getInstanceOf(Class<?> clazz, boolean alternateEnumValue) {
        if (Constructible.class.isAssignableFrom(clazz)) {
            return this.createConstructibleInstance(clazz);
        }
        if (Enum.class.isAssignableFrom(clazz)) {
            ?[] enumConstants = clazz.getEnumConstants();
            if (enumConstants != null && enumConstants.length > 0) {
                if (alternateEnumValue && enumConstants.length > 1) {
                    return enumConstants[1];
                }
                return enumConstants[0];
            }
        } else {
            if (clazz == List.class) {
                return new ArrayList();
            }
            if (clazz == Map.class) {
                return new HashMap();
            }
            if (clazz == String.class) {
                return new String("value");
            }
            if (clazz == Boolean.class || clazz == Boolean.TYPE) {
                return new Boolean(true);
            }
            if (clazz == Byte.class || clazz == Byte.TYPE) {
                return new Byte(1);
            }
            if (clazz == Short.class || clazz == Short.TYPE) {
                return new Short(1);
            }
            if (clazz == Integer.class || clazz == Integer.TYPE) {
                return new Integer(1);
            }
            if (clazz == Long.class || clazz == Long.TYPE) {
                return new Long(1L);
            }
            if (clazz == Float.class || clazz == Float.TYPE) {
                return new Float(1.0f);
            }
            if (clazz == Double.class || clazz == Double.TYPE) {
                return new Double(1.0);
            }
            if (clazz == Character.class || clazz == Character.TYPE) {
                return new Character('a');
            }
            if (clazz == BigInteger.class) {
                return new BigInteger("1");
            }
            if (clazz == BigDecimal.class) {
                return new BigDecimal("1.0");
            }
            if (clazz == Object.class) {
                return new String("object");
            }
        }
        return null;
    }

    private String createReference(Reference<?> r, String v) {
        StringBuilder sb = new StringBuilder();
        if (r instanceof APIResponse) {
            sb.append("#/components/responses/");
        } else if (r instanceof Callback) {
            sb.append("#/components/callbacks/");
        } else if (r instanceof Example) {
            sb.append("#/components/examples/");
        } else if (r instanceof Header) {
            sb.append("#/components/headers/");
        } else if (r instanceof Link) {
            sb.append("#/components/links/");
        } else if (r instanceof Parameter) {
            sb.append("#/components/parameters/");
        } else if (r instanceof PathItem) {
            sb.append("http://www.abc.def.ghi/");
        } else if (r instanceof RequestBody) {
            sb.append("#/components/requestBodies/");
        } else if (r instanceof Schema) {
            sb.append("#/components/schemas/");
        } else if (r instanceof SecurityScheme) {
            sb.append("#/components/securitySchemes/");
        }
        sb.append(v);
        return sb.toString();
    }

    private Map<String, Property> collectProperties(Class<?> clazz) {
        HashMap<String, Property> properties = new HashMap<String, Property>();
        Method[] methods = clazz.getDeclaredMethods();
        Arrays.stream(methods).forEach(m -> {
            Class<?> returnType = m.getReturnType();
            int parameterCount = m.getParameterCount();
            String name = m.getName();
            if (returnType == clazz) {
                if (parameterCount == 1) {
                    Class<?> type = m.getParameterTypes()[0];
                    Property p = (Property)properties.get(name);
                    if (p == null) {
                        p = new Property(name, type);
                        properties.put(name, p);
                    }
                    if (p.isCompatible(type)) {
                        p.addBuilder((Method)m);
                    }
                }
            } else if (returnType == Void.TYPE) {
                if (name.startsWith("set") && parameterCount == 1) {
                    name = Introspector.decapitalize(name.substring(3));
                    Class<?> type = m.getParameterTypes()[0];
                    Property p = (Property)properties.get(name);
                    if (p == null) {
                        p = new Property(name, type);
                        properties.put(name, p);
                    }
                    if (p.isCompatible(type)) {
                        p.addSetter((Method)m);
                    }
                }
            } else if (name.startsWith("get") && parameterCount == 0) {
                name = Introspector.decapitalize(name.substring(3));
                Class<?> type = returnType;
                Property p = (Property)properties.get(name);
                if (p == null) {
                    p = new Property(name, type);
                    properties.put(name, p);
                }
                if (p.isCompatible(type)) {
                    p.addGetter((Method)m);
                }
            }
        });
        return properties;
    }

    private <T> void checkMapEntry(Map<String, T> map, String key, T value) {
        Assert.assertNotNull(map, (String)"The map must not be null.");
        Assert.assertTrue((boolean)map.containsKey(key), (String)("The map is expected to contain the key: " + key));
        Assert.assertSame(map.get(key), value, (String)("The value associated with the key: " + key + " is expected to be the same one that was added."));
    }

    private <T> void checkListEntry(List<T> list, T value) {
        Assert.assertNotNull(list, (String)"The list must not be null.");
        Assert.assertTrue((boolean)list.stream().anyMatch(v -> v == value), (String)("The list is expected to contain the value: " + value));
    }

    private <T> void checkSameObject(T expected, T actual) {
        Assert.assertSame(actual, expected, (String)"Expecting same object.");
    }

    static final class Property {
        private final String name;
        private final Class<?> type;
        private Method getter;
        private Method setter;
        private Method builder;

        public Property(String name, Class<?> type) {
            this.name = name;
            this.type = type;
        }

        public void addGetter(Method getter) {
            this.getter = getter;
        }

        public void addSetter(Method setter) {
            this.setter = setter;
        }

        public void addBuilder(Method builder) {
            this.builder = builder;
        }

        public String getName() {
            return this.name;
        }

        public Class<?> getType() {
            return this.type;
        }

        public boolean hasBuilder() {
            return this.builder != null;
        }

        public Object invokeGetter(Object target) {
            try {
                return this.getter.invoke(target, new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                Assert.fail((String)("Invocation of getter method \"" + this.getter.getName() + "\" failed: " + e.getMessage()));
                throw new RuntimeException(e);
            }
        }

        public void invokeSetter(Object target, Object value) {
            try {
                this.setter.invoke(target, value);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                Assert.fail((String)("Invocation of setter method \"" + this.setter.getName() + "\" failed: " + e.getMessage()));
                throw new RuntimeException(e);
            }
        }

        public Object invokeBuilder(Object target, Object value) {
            try {
                return this.builder.invoke(target, value);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                Assert.fail((String)("Invocation of builder method \"" + this.builder.getName() + "\" failed: " + e.getMessage()));
                throw new RuntimeException(e);
            }
        }

        public boolean isCompatible(Class<?> type) {
            return this.type == type;
        }

        public boolean isPrimitive() {
            return this.type.isPrimitive();
        }

        public boolean isComplete() {
            return this.getter != null && this.setter != null;
        }
    }
}

