/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.openapi.tck;

import io.restassured.response.ValidatableResponse;
import org.eclipse.microprofile.openapi.tck.AppTestBase;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.collection.IsMapWithSize;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.container.test.api.RunAsClient;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.testng.annotations.Test;

public class FilterTest
extends AppTestBase {
    @Deployment(name="airlinesFiltered")
    public static WebArchive createDeployment() {
        return (WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)"airlinesFiltered.war")).addPackages(true, new String[]{"org.eclipse.microprofile.openapi.apps.airlines"})).addPackages(true, new String[]{"org.eclipse.microprofile.openapi.filter"})).addAsManifestResource("openapi.yaml", "openapi.yaml")).addAsManifestResource("microprofile-config-filter.properties", "microprofile-config.properties");
    }

    @RunAsClient
    @Test(dataProvider="formatProvider")
    public void testFilterServer(String type) {
        ValidatableResponse vr = this.callEndpoint(type);
        vr.body("servers", Matchers.hasSize((int)2), new Object[0]);
        vr.body("servers.url", Matchers.hasSize((int)2), new Object[0]);
        String url = "https://{username}.gigantic-server.com:{port}/{basePath}";
        String serverPath = "servers.find { it.url == '" + url + "' }";
        vr.body(serverPath + ".description", Matchers.equalTo((Object)"filterServer - The production API server"), new Object[0]);
        vr.body(serverPath + ".variables", IsMapWithSize.aMapWithSize((int)4), new Object[0]);
        vr.body(serverPath + ".variables.username.description", Matchers.equalTo((Object)"Reviews of the app by users"), new Object[0]);
        vr.body(serverPath + ".variables.username.default", Matchers.equalTo((Object)"user1"), new Object[0]);
        vr.body(serverPath + ".variables.username.enum", Matchers.containsInAnyOrder((Object[])new String[]{"user1", "user2"}), new Object[0]);
        vr.body(serverPath + ".variables.port.description", Matchers.equalTo((Object)"Booking data"), new Object[0]);
        vr.body(serverPath + ".variables.port.default", Matchers.equalTo((Object)"8443"), new Object[0]);
        vr.body(serverPath + ".variables.user.description", Matchers.equalTo((Object)"User data"), new Object[0]);
        vr.body(serverPath + ".variables.user.default", Matchers.equalTo((Object)"user"), new Object[0]);
        vr.body(serverPath + ".variables.basePath.default", Matchers.equalTo((Object)"v2"), new Object[0]);
        url = "{protocol}://test-server.com";
        serverPath = "paths.'/reviews/{id}'.delete.servers.find { it.url == '" + url + "' }";
        vr.body(serverPath + ".description", Matchers.equalTo((Object)"filterServer - The production API server"), new Object[0]);
        vr.body(serverPath + ".variables", IsMapWithSize.aMapWithSize((int)1), new Object[0]);
        vr.body(serverPath + ".variables.protocol.default", Matchers.equalTo((Object)"https"), new Object[0]);
        vr.body(serverPath + ".variables.protocol.enum", Matchers.containsInAnyOrder((Object[])new String[]{"http", "https"}), new Object[0]);
    }

    @RunAsClient
    @Test(dataProvider="formatProvider")
    public void testFilterPathItemEnsureOrder(String type) {
        ValidatableResponse vr = this.callEndpoint(type);
        vr.body("paths.'/availability'.get.summary", Matchers.equalTo((Object)"Retrieve all available flights"), new Object[0]);
        vr.body("paths.'/availability'.get.operationId", Matchers.equalTo((Object)"filterPathItemGetFlights"), new Object[0]);
    }

    @RunAsClient
    @Test(dataProvider="formatProvider")
    public void testFilterPathItemAddOperation(String type) {
        ValidatableResponse vr = this.callEndpoint(type);
        vr.body("paths.'/availability'.put.summary", Matchers.equalTo((Object)"filterPathItem - added put operation"), new Object[0]);
        vr.body("paths.'/availability'.put.responses.'200'.description", Matchers.equalTo((Object)"filterPathItem - successfully put airlines"), new Object[0]);
    }

    @RunAsClient
    @Test(dataProvider="formatProvider")
    public void testFilterOperation(String type) {
        ValidatableResponse vr = this.callEndpoint(type);
        vr.body("paths.'/bookings/{id}'.get.summary", Matchers.equalTo((Object)"filterOperation - Get a booking with ID"), new Object[0]);
        vr.body("paths.'/bookings/{id}'.get.operationId", Matchers.equalTo((Object)"getBookingById"), new Object[0]);
    }

    @RunAsClient
    @Test(dataProvider="formatProvider")
    public void testFilterOpenAPI(String type) {
        ValidatableResponse vr = this.callEndpoint(type);
        vr.body("paths.'/bookings/{id}'.put.summary", Matchers.equalTo((Object)"filterOpenAPI - Update a booking with ID"), new Object[0]);
        vr.body("paths.'/bookings/{id}'.put.operationId", Matchers.equalTo((Object)"updateBookingId"), new Object[0]);
    }

    @RunAsClient
    @Test(dataProvider="formatProvider")
    public void testFilterParameter(String type) {
        ValidatableResponse vr = this.callEndpoint(type);
        String reviewParameters = "paths.'/user/login'.get.parameters";
        String username = reviewParameters + ".findAll { it.name == 'username' }";
        vr.body(username + ".in", (Matcher)Matchers.both((Matcher)Matchers.hasSize((int)1)).and(Matchers.contains((Object[])new Object[]{"query"})), new Object[0]);
        vr.body(username + ".description", (Matcher)Matchers.both((Matcher)Matchers.hasSize((int)1)).and(Matchers.contains((Object[])new Object[]{"filterParameter - The user name for login"})), new Object[0]);
        vr.body(username + ".required", (Matcher)Matchers.both((Matcher)Matchers.hasSize((int)1)).and(Matchers.contains((Object[])new Object[]{true})), new Object[0]);
        vr.body(username + ".schema.type", (Matcher)Matchers.both((Matcher)Matchers.hasSize((int)1)).and(Matchers.contains((Object[])new Object[]{"string"})), new Object[0]);
        vr.body(reviewParameters, Matchers.hasSize((int)1), new Object[0]);
    }

    @RunAsClient
    @Test(dataProvider="formatProvider")
    public void testFilterRequestBody(String type) {
        ValidatableResponse vr = this.callEndpoint(type);
        String endpoint = "paths.'/bookings'.post.requestBody";
        vr.body(endpoint + ".description", Matchers.equalTo((Object)"filterRequestBody - Create a new booking with the provided information."), new Object[0]);
        vr.body(endpoint + ".content", Matchers.notNullValue(), new Object[0]);
    }

    @RunAsClient
    @Test(dataProvider="formatProvider")
    public void testFilterSecurityScheme(String type) {
        ValidatableResponse vr = this.callEndpoint(type);
        String booking = "components.securitySchemes.bookingSecurityScheme.";
        vr.body(booking + "type", Matchers.equalTo((Object)"openIdConnect"), new Object[0]);
        vr.body(booking + "description", Matchers.equalTo((Object)"filterSecurityScheme - Security Scheme for booking resource"), new Object[0]);
        vr.body(booking + "openIdConnectUrl", Matchers.equalTo((Object)"http://openidconnect.com/testurl"), new Object[0]);
    }

    @RunAsClient
    @Test(dataProvider="formatProvider")
    public void testFilterLink(String type) {
        ValidatableResponse vr = this.callEndpoint(type);
        String s = "paths.'/user/{id}'.get.responses.'200'.links.'User name'.";
        vr.body(s + "operationId", Matchers.equalTo((Object)"getUserByName"), new Object[0]);
        vr.body(s + "description", Matchers.equalTo((Object)"filterLink - The username corresponding to provided user id"), new Object[0]);
    }

    @RunAsClient
    @Test(dataProvider="formatProvider")
    public void testFilterTag(String type) {
        ValidatableResponse vr = this.callEndpoint(type);
        String tagsPath = "tags.find { it.name == '";
        String desc = "' }.description";
        vr.body(tagsPath + "user" + desc, Matchers.equalTo((Object)"filterTag - Operations about user"), new Object[0]);
    }

    @RunAsClient
    @Test(dataProvider="formatProvider")
    public void testFilterHeader(String type) {
        ValidatableResponse vr = this.callEndpoint(type);
        String maxRate = "components.headers.Max-Rate";
        vr.body(maxRate + ".description", Matchers.equalTo((Object)"filterHeader - Maximum rate"), new Object[0]);
        vr.body(maxRate + ".required", Matchers.equalTo((Object)true), new Object[0]);
        vr.body(maxRate + ".deprecated", Matchers.equalTo((Object)true), new Object[0]);
        vr.body(maxRate + ".allowEmptyValue", Matchers.equalTo((Object)true), new Object[0]);
        vr.body(maxRate + ".style", Matchers.equalTo((Object)"simple"), new Object[0]);
        vr.body(maxRate + ".schema.type", Matchers.equalTo((Object)"integer"), new Object[0]);
    }

    @RunAsClient
    @Test(dataProvider="formatProvider")
    public void testFilterAPIResponse(String type) {
        ValidatableResponse vr = this.callEndpoint(type);
        String response201Path = "paths.'/streams'.post.responses.'201'";
        vr.body("paths.'/streams'.post.responses.'201'.description", Matchers.equalTo((Object)"filterAPIResponse - subscription successfully created"), new Object[0]);
    }

    @RunAsClient
    @Test(dataProvider="formatProvider")
    public void testFilterSchema(String type) {
        ValidatableResponse vr = this.callEndpoint(type);
        String response201Path = "paths.'/streams'.post.responses.'201'";
        vr.body("paths.'/streams'.post.responses.'201'.content.'application/json'.schema.description", Matchers.equalTo((Object)"filterSchema - subscription information"), new Object[0]);
    }

    @RunAsClient
    @Test(dataProvider="formatProvider")
    public void testFilterCallback(String type) {
        ValidatableResponse vr = this.callEndpoint(type);
        String callbacksPath = "paths.'/streams'.post.callbacks.onData.'{$request.query.callbackUrl}/data'.post";
        vr.body("paths.'/streams'.post.callbacks.onData.'{$request.query.callbackUrl}/data'.post.description", Matchers.equalTo((Object)"filterCallback - callback post operation"), new Object[0]);
    }
}

