/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.openapi.reader;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import org.eclipse.microprofile.openapi.OASFactory;
import org.eclipse.microprofile.openapi.OASModelReader;
import org.eclipse.microprofile.openapi.models.Components;
import org.eclipse.microprofile.openapi.models.ExternalDocumentation;
import org.eclipse.microprofile.openapi.models.OpenAPI;
import org.eclipse.microprofile.openapi.models.Operation;
import org.eclipse.microprofile.openapi.models.PathItem;
import org.eclipse.microprofile.openapi.models.Paths;
import org.eclipse.microprofile.openapi.models.examples.Example;
import org.eclipse.microprofile.openapi.models.headers.Header;
import org.eclipse.microprofile.openapi.models.info.Contact;
import org.eclipse.microprofile.openapi.models.info.Info;
import org.eclipse.microprofile.openapi.models.info.License;
import org.eclipse.microprofile.openapi.models.links.Link;
import org.eclipse.microprofile.openapi.models.media.Content;
import org.eclipse.microprofile.openapi.models.media.MediaType;
import org.eclipse.microprofile.openapi.models.media.Schema;
import org.eclipse.microprofile.openapi.models.parameters.Parameter;
import org.eclipse.microprofile.openapi.models.parameters.RequestBody;
import org.eclipse.microprofile.openapi.models.responses.APIResponse;
import org.eclipse.microprofile.openapi.models.responses.APIResponses;
import org.eclipse.microprofile.openapi.models.security.SecurityRequirement;
import org.eclipse.microprofile.openapi.models.security.SecurityScheme;
import org.eclipse.microprofile.openapi.models.servers.Server;
import org.eclipse.microprofile.openapi.models.servers.ServerVariable;
import org.eclipse.microprofile.openapi.models.servers.ServerVariables;
import org.eclipse.microprofile.openapi.models.tags.Tag;

public class MyOASModelReaderImpl
implements OASModelReader {
    public OpenAPI buildModel() {
        return ((OpenAPI)OASFactory.createObject(OpenAPI.class)).info(((Info)OASFactory.createObject(Info.class)).title("AirlinesRatingApp API").version("1.0").termsOfService("http://airlinesratingapp.com/terms").contact(((Contact)OASFactory.createObject(Contact.class)).name("AirlinesRatingApp API Support").url("http://exampleurl.com/contact").email("techsupport@airlinesratingapp.com")).license(((License)OASFactory.createObject(License.class)).name("Apache 2.0").url("http://www.apache.org/licenses/LICENSE-2.0.html"))).security(new ArrayList()).addSecurityRequirement(((SecurityRequirement)OASFactory.createObject(SecurityRequirement.class)).addScheme("airlinesRatingApp_auth")).servers(new ArrayList()).addServer(((Server)OASFactory.createObject(Server.class)).url("https://{username}.gigantic-server.com:{port}/{basePath}").description("The production API server").variables(((ServerVariables)OASFactory.createObject(ServerVariables.class)).addServerVariable("username", ((ServerVariable)OASFactory.createObject(ServerVariable.class)).defaultValue("user1").description("Reviews of the app by users").enumeration(new ArrayList()).addEnumeration("user1").addEnumeration("user2")).addServerVariable("port", ((ServerVariable)OASFactory.createObject(ServerVariable.class)).defaultValue("8443").description("Booking data")).addServerVariable("user", ((ServerVariable)OASFactory.createObject(ServerVariable.class)).defaultValue("user").description("User data")).addServerVariable("basePath", ((ServerVariable)OASFactory.createObject(ServerVariable.class)).defaultValue("v2")))).addServer(((Server)OASFactory.createObject(Server.class)).url("https://test-server.com:80/basePath").description("The test API server")).components(((Components)OASFactory.createObject(Components.class)).schemas(new HashMap()).addSchema("Bookings", (Schema)((Schema)OASFactory.createObject(Schema.class)).type(Schema.SchemaType.INTEGER).title("Bookings").ref("#/components.schemas.Booking")).addSchema("Airlines", ((Schema)OASFactory.createObject(Schema.class)).type(Schema.SchemaType.INTEGER).title("Airlines")).addSchema("AirlinesRef", (Schema)((Schema)OASFactory.createObject(Schema.class)).ref("#/components/schemas/Airlines")).addSchema("id", ((Schema)OASFactory.createObject(Schema.class)).type(Schema.SchemaType.INTEGER).format("int32")).responses(new HashMap()).addResponse("FoundAirlines", ((APIResponse)OASFactory.createObject(APIResponse.class)).description("successfully found airlines").content(((Content)OASFactory.createObject(Content.class)).addMediaType("application/json", ((MediaType)OASFactory.createObject(MediaType.class)).schema(((Schema)OASFactory.createObject(Schema.class)).type(Schema.SchemaType.ARRAY))))).addResponse("FoundBookings", ((APIResponse)OASFactory.createObject(APIResponse.class)).description("Bookings retrieved").content(((Content)OASFactory.createObject(Content.class)).addMediaType("application/json", ((MediaType)OASFactory.createObject(MediaType.class)).schema((Schema)((Schema)OASFactory.createObject(Schema.class)).type(Schema.SchemaType.ARRAY).ref("#/components.schemas.Booking"))))).parameters(new HashMap()).addParameter("departureDate", ((Parameter)OASFactory.createObject(Parameter.class)).required(Boolean.valueOf(true)).description("Customer departure date").schema((Schema)OASFactory.createObject(Schema.class))).addParameter("username", ((Parameter)OASFactory.createObject(Parameter.class)).required(Boolean.valueOf(true)).description("The name that needs to be deleted").schema((Schema)OASFactory.createObject(Schema.class))).examples(new HashMap()).addExample("review", ((Example)OASFactory.createObject(Example.class)).summary("External review example").description("This example exemplifies the content on our site.").externalValue("http://foo.bar/examples/review-example.json")).addExample("user", ((Example)OASFactory.createObject(Example.class)).summary("External user example").externalValue("http://foo.bar/examples/user-example.json")).requestBodies(new HashMap()).addRequestBody("review", ((RequestBody)OASFactory.createObject(RequestBody.class)).required(Boolean.valueOf(true)).description("example review to add").content(((Content)OASFactory.createObject(Content.class)).addMediaType("application/json", ((MediaType)OASFactory.createObject(MediaType.class)).schema((Schema)((Schema)OASFactory.createObject(Schema.class)).ref("#/components.schemas.Review"))))).headers(new HashMap()).addHeader("Max-Rate", ((Header)OASFactory.createObject(Header.class)).description("Maximum rate").schema(((Schema)OASFactory.createObject(Schema.class)).type(Schema.SchemaType.INTEGER)).required(Boolean.valueOf(true)).allowEmptyValue(Boolean.valueOf(true)).deprecated(Boolean.valueOf(true))).addHeader("Request-Limit", ((Header)OASFactory.createObject(Header.class)).description("The number of allowed requests in the current period").schema(((Schema)OASFactory.createObject(Schema.class)).type(Schema.SchemaType.INTEGER))).securitySchemes(new HashMap()).addSecurityScheme("httpTestScheme", ((SecurityScheme)OASFactory.createObject(SecurityScheme.class)).description("user security scheme").type(SecurityScheme.Type.HTTP).scheme("testScheme")).links(new HashMap()).addLink("UserName", ((Link)OASFactory.createObject(Link.class)).description("The username corresponding to provided user id").operationId("getUserByName").parameters(new HashMap()).addParameter("userId", (Object)OASFactory.createObject(Parameter.class)))).tags(new ArrayList()).addTag(((Tag)OASFactory.createObject(Tag.class)).name("Get Airlines").description("method to get all airlines")).addTag(((Tag)OASFactory.createObject(Tag.class)).name("Retrieve Airlines").description("method to retrieve all airlines")).addTag(((Tag)OASFactory.createObject(Tag.class)).name("user").description("Operations about user")).addTag(((Tag)OASFactory.createObject(Tag.class)).name("create").description("Operations about create")).addTag(((Tag)OASFactory.createObject(Tag.class)).name("Bookings").description("All the bookings methods")).addTag(((Tag)OASFactory.createObject(Tag.class)).name("Airlines").description("All the airlines methods")).addTag(((Tag)OASFactory.createObject(Tag.class)).name("Availability").description("All the availability methods")).addTag(((Tag)OASFactory.createObject(Tag.class)).name("Get Flights").description("method to retrieve all flights available").externalDocs(((ExternalDocumentation)OASFactory.createObject(ExternalDocumentation.class)).description("A list of all the flights offered by the app").url("http://airlinesratingapp.com/ourflights"))).externalDocs(((ExternalDocumentation)OASFactory.createObject(ExternalDocumentation.class)).description("instructions for how to deploy this app").url("https://github.com/microservices-api/oas3-airlines/blob/master/README.md")).paths(((Paths)OASFactory.createObject(Paths.class)).addPathItem("/modelReader/airlines", ((PathItem)OASFactory.createObject(PathItem.class)).GET(((Operation)OASFactory.createObject(Operation.class)).summary("Retrieve all available airlines").operationId("getAirlines").responses(((APIResponses)OASFactory.createObject(APIResponses.class)).addApiResponse("404", ((APIResponse)OASFactory.createObject(APIResponse.class)).description("No airlines found").content(((Content)OASFactory.createObject(Content.class)).addMediaType("n/a", (MediaType)OASFactory.createObject(MediaType.class))))))).addPathItem("/availability", ((PathItem)OASFactory.createObject(PathItem.class)).GET(((Operation)OASFactory.createObject(Operation.class)).tags(new ArrayList()).addTag("Availability").summary("TEST SUMMARY").operationId("getTestFlights").responses(((APIResponses)OASFactory.createObject(APIResponses.class)).addApiResponse("200", ((APIResponse)OASFactory.createObject(APIResponse.class)).description("successful operation").content(((Content)OASFactory.createObject(Content.class)).addMediaType("application/json", ((MediaType)OASFactory.createObject(MediaType.class)).schema((Schema)((Schema)OASFactory.createObject(Schema.class)).type(Schema.SchemaType.ARRAY).ref("#/components.schemas.Flight"))))).addApiResponse("404", ((APIResponse)OASFactory.createObject(APIResponse.class)).description("No available flights found").content(((Content)OASFactory.createObject(Content.class)).addMediaType("n/a", (MediaType)OASFactory.createObject(MediaType.class))))).parameters(new ArrayList()).addParameter((Parameter)((Parameter)OASFactory.createObject(Parameter.class)).ref("#/components/parameters/departureDate")).addParameter(((Parameter)OASFactory.createObject(Parameter.class)).name("airportFrom").required(Boolean.valueOf(true)).in(Parameter.In.QUERY).allowEmptyValue(Boolean.valueOf(true)).description("Airport the customer departs from").schema(((Schema)OASFactory.createObject(Schema.class)).type(Schema.SchemaType.STRING))).addParameter(((Parameter)OASFactory.createObject(Parameter.class)).name("returningDate").required(Boolean.valueOf(true)).in(Parameter.In.QUERY).allowReserved(Boolean.valueOf(true)).description("Customer return date").schema(((Schema)OASFactory.createObject(Schema.class)).type(Schema.SchemaType.STRING))).addParameter(((Parameter)OASFactory.createObject(Parameter.class)).name("airportTo").required(Boolean.valueOf(true)).in(Parameter.In.QUERY).description("Airport the customer returns to").schema(((Schema)OASFactory.createObject(Schema.class)).type(Schema.SchemaType.STRING))).addParameter(((Parameter)OASFactory.createObject(Parameter.class)).name("numberOfAdults").required(Boolean.valueOf(true)).in(Parameter.In.QUERY).description("Number of adults on the flight").schema(((Schema)OASFactory.createObject(Schema.class)).minimum(new BigDecimal(0)).type(Schema.SchemaType.STRING))).addParameter(((Parameter)OASFactory.createObject(Parameter.class)).name("numberOfChildren").required(Boolean.valueOf(true)).deprecated(Boolean.valueOf(true)).in(Parameter.In.QUERY).description("Number of children on the flight").schema(((Schema)OASFactory.createObject(Schema.class)).minimum(new BigDecimal(0)).type(Schema.SchemaType.STRING))))).addPathItem("/modelReader/bookings", ((PathItem)OASFactory.createObject(PathItem.class)).GET(((Operation)OASFactory.createObject(Operation.class)).tags(new ArrayList()).addTag("bookings").summary("Retrieve all bookings for current user").operationId("getAllBookings").responses(((APIResponses)OASFactory.createObject(APIResponses.class)).addApiResponse("200", ((APIResponse)OASFactory.createObject(APIResponse.class)).description("Bookings retrieved").content(((Content)OASFactory.createObject(Content.class)).addMediaType("applictaion/json", ((MediaType)OASFactory.createObject(MediaType.class)).schema((Schema)((Schema)OASFactory.createObject(Schema.class)).type(Schema.SchemaType.ARRAY).ref("#/components.schemas.Booking"))))).addApiResponse("404", ((APIResponse)OASFactory.createObject(APIResponse.class)).description("No bookings found for the user")))).POST(((Operation)OASFactory.createObject(Operation.class)).security(new ArrayList()).addSecurityRequirement(((SecurityRequirement)OASFactory.createObject(SecurityRequirement.class)).addScheme("bookingSecurityScheme", new ArrayList<String>(Arrays.asList("write:bookings", "read:bookings")))).summary("Create a booking").description("Create a new booking record with the booking information provided.").operationId("createBooking").responses(((APIResponses)OASFactory.createObject(APIResponses.class)).addApiResponse("201", ((APIResponse)OASFactory.createObject(APIResponse.class)).description("Bookings created").content(((Content)OASFactory.createObject(Content.class)).addMediaType("text/plain", ((MediaType)OASFactory.createObject(MediaType.class)).schema(((Schema)OASFactory.createObject(Schema.class)).title("id").description("id of the new booking").type(Schema.SchemaType.STRING)))))))));
    }
}

