/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.openapi.filter;

import org.eclipse.microprofile.openapi.OASFactory;
import org.eclipse.microprofile.openapi.OASFilter;
import org.eclipse.microprofile.openapi.models.OpenAPI;
import org.eclipse.microprofile.openapi.models.Operation;
import org.eclipse.microprofile.openapi.models.PathItem;
import org.eclipse.microprofile.openapi.models.callbacks.Callback;
import org.eclipse.microprofile.openapi.models.headers.Header;
import org.eclipse.microprofile.openapi.models.links.Link;
import org.eclipse.microprofile.openapi.models.media.Schema;
import org.eclipse.microprofile.openapi.models.parameters.Parameter;
import org.eclipse.microprofile.openapi.models.parameters.RequestBody;
import org.eclipse.microprofile.openapi.models.responses.APIResponse;
import org.eclipse.microprofile.openapi.models.responses.APIResponses;
import org.eclipse.microprofile.openapi.models.security.SecurityScheme;
import org.eclipse.microprofile.openapi.models.servers.Server;
import org.eclipse.microprofile.openapi.models.tags.Tag;

public class AirlinesOASFilter
implements OASFilter {
    public PathItem filterPathItem(PathItem pathItem) {
        if (pathItem.getGET() != null && "Retrieve all available flights".equals(pathItem.getGET().getSummary())) {
            pathItem.PUT(((Operation)OASFactory.createObject(Operation.class)).summary("filterPathItem - added put operation").responses(((APIResponses)OASFactory.createObject(APIResponses.class)).addApiResponse("200", ((APIResponse)OASFactory.createObject(APIResponse.class)).description("filterPathItem - successfully put airlines"))));
            pathItem.getGET().setOperationId("filterPathItemGetFlights");
        }
        return pathItem;
    }

    public Operation filterOperation(Operation operation) {
        if ("Get a booking with ID".equals(operation.getSummary())) {
            operation.setSummary("filterOperation - Get a booking with ID");
        } else if ("Update a booking with ID".equals(operation.getSummary())) {
            operation.setSummary("filterOperation - Update a booking with ID");
        } else if ("Retrieve all available flights".equals(operation.getSummary())) {
            operation.setOperationId("filterOperationGetFlights");
        }
        return operation;
    }

    public Parameter filterParameter(Parameter parameter) {
        if ("The user name for login".equals(parameter.getDescription())) {
            parameter.setDescription("filterParameter - The user name for login");
        } else if ("The password for login in clear text".equals(parameter.getDescription())) {
            return null;
        }
        return parameter;
    }

    public Header filterHeader(Header header) {
        if ("Maximum rate".equals(header.getDescription())) {
            header.setDescription("filterHeader - Maximum rate");
        }
        return header;
    }

    public RequestBody filterRequestBody(RequestBody requestBody) {
        if ("Create a new booking with the provided information.".equals(requestBody.getDescription())) {
            requestBody.setDescription("filterRequestBody - Create a new booking with the provided information.");
        }
        return requestBody;
    }

    public APIResponse filterAPIResponse(APIResponse apiResponse) {
        if ("subscription successfully created".equals(apiResponse.getDescription())) {
            apiResponse.setDescription("filterAPIResponse - subscription successfully created");
        }
        return apiResponse;
    }

    public Schema filterSchema(Schema schema) {
        if ("subscription information".equals(schema.getDescription())) {
            schema.setDescription("filterSchema - subscription information");
        }
        return schema;
    }

    public SecurityScheme filterSecurityScheme(SecurityScheme securityScheme) {
        if ("Security Scheme for booking resource".equals(securityScheme.getDescription())) {
            securityScheme.setDescription("filterSecurityScheme - Security Scheme for booking resource");
        }
        return securityScheme;
    }

    public Server filterServer(Server server) {
        if ("The production API server".equals(server.getDescription())) {
            server.description("filterServer - The production API server");
        }
        return server;
    }

    public Tag filterTag(Tag tag) {
        if ("Operations about user".equals(tag.getDescription())) {
            tag.setDescription("filterTag - Operations about user");
        }
        return tag;
    }

    public Link filterLink(Link link) {
        if ("The username corresponding to provided user id".equals(link.getDescription())) {
            link.setDescription("filterLink - The username corresponding to provided user id");
        }
        return link;
    }

    public Callback filterCallback(Callback callback) {
        if (callback.containsKey((Object)"{$request.query.callbackUrl}/data") && ((PathItem)callback.get((Object)"{$request.query.callbackUrl}/data")).getPOST() != null) {
            ((PathItem)callback.get((Object)"{$request.query.callbackUrl}/data")).getPOST().setDescription("filterCallback - callback post operation");
        }
        return callback;
    }

    public void filterOpenAPI(OpenAPI openAPI) {
        ((PathItem)openAPI.getPaths().get((Object)"/bookings/{id}")).getPUT().setSummary("filterOpenAPI - Update a booking with ID");
    }
}

