/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.metrics.test.multipleinstances;

import jakarta.enterprise.inject.Instance;
import jakarta.inject.Inject;
import org.eclipse.microprofile.metrics.Counter;
import org.eclipse.microprofile.metrics.Meter;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.Timer;
import org.eclipse.microprofile.metrics.test.multipleinstances.DependentScopedBean;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
public class MultipleBeanInstancesTest {
    @Inject
    private MetricRegistry registry;
    @Inject
    private Instance<DependentScopedBean> bean;
    private DependentScopedBean instance1;
    private DependentScopedBean instance2;

    @Deployment
    public static WebArchive createDeployment() {
        WebArchive archive = (WebArchive)((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class)).addClass(DependentScopedBean.class)).addAsWebInfResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
        return archive;
    }

    @Before
    public void getInstances() {
        this.instance1 = (DependentScopedBean)this.bean.get();
        this.instance2 = (DependentScopedBean)this.bean.get();
        Assert.assertFalse((String)"CDI container should return two different bean instances", (boolean)this.instance1.equals(this.instance2));
    }

    @Test
    public void testCounter() {
        this.instance1.countedMethod();
        this.instance2.countedMethod();
        Assert.assertThat((Object)((Counter)this.registry.getCounters((id, metric) -> id.getName().equals("counter")).values().iterator().next()).getCount(), (Matcher)CoreMatchers.is((Object)2L));
    }

    @Test
    public void testMeter() {
        this.instance1.meteredMethod();
        this.instance2.meteredMethod();
        Assert.assertThat((Object)((Meter)this.registry.getMeters((id, metric) -> id.getName().equals("meter")).values().iterator().next()).getCount(), (Matcher)CoreMatchers.is((Object)2L));
    }

    @Test
    public void testTimer() {
        this.instance1.timedMethod();
        this.instance2.timedMethod();
        Assert.assertThat((Object)((Timer)this.registry.getTimers((id, metric) -> id.getName().equals("timer")).values().iterator().next()).getCount(), (Matcher)CoreMatchers.is((Object)2L));
    }
}

