/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.metrics.test;

import io.restassured.RestAssured;
import io.restassured.builder.ResponseBuilder;
import io.restassured.http.Header;
import io.restassured.path.json.JsonPath;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import jakarta.inject.Inject;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.microprofile.metrics.test.MetricAppBean2;
import org.hamcrest.Matchers;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.container.test.api.RunAsClient;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.junit.InSequence;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
public class ReusedMetricsTest {
    private static final String JSON_APP_LABEL_REGEX = ";_app=[-/A-Za-z0-9]+([;\\\"]?)";
    private static final String JSON_APP_LABEL_REGEXS_SUB = "$1";
    private static final String APPLICATION_JSON = "application/json";
    private static final String DEFAULT_PROTOCOL = "http";
    private static final String DEFAULT_HOST = "localhost";
    private static final int DEFAULT_PORT = 8080;
    @Inject
    private MetricAppBean2 metricAppBean;

    @BeforeClass
    public static void setup() throws MalformedURLException {
        String serverUrl = System.getProperty("test.url");
        String protocol = DEFAULT_PROTOCOL;
        String host = DEFAULT_HOST;
        int port = 8080;
        if (serverUrl != null) {
            URL url = new URL(serverUrl);
            protocol = url.getProtocol();
            host = url.getHost();
            port = url.getPort() == -1 ? 8080 : url.getPort();
        }
        RestAssured.baseURI = protocol + "://" + host;
        RestAssured.port = port;
        String userName = System.getProperty("test.user");
        String password = System.getProperty("test.pwd");
        if (userName != null && password != null) {
            RestAssured.authentication = RestAssured.basic((String)userName, (String)password);
            RestAssured.useRelaxedHTTPSValidation();
        }
    }

    @Deployment
    public static WebArchive createDeployment() {
        WebArchive jar = (WebArchive)((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class)).addClass(MetricAppBean2.class)).addAsWebInfResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
        return jar;
    }

    @Test
    @InSequence(value=1)
    public void setA() {
        this.metricAppBean.countMeA();
        this.metricAppBean.meterMeA();
        this.metricAppBean.timeMeA();
        this.metricAppBean.simplyTimeMeA();
    }

    @Test
    @RunAsClient
    @InSequence(value=2)
    public void testSharedCounter() {
        Header acceptJson = new Header("Accept", APPLICATION_JSON);
        Response resp = (Response)RestAssured.given().header(acceptJson).get("/metrics/application", new Object[0]);
        JsonPath filteredJSONPath = new JsonPath(resp.jsonPath().prettify().replaceAll(JSON_APP_LABEL_REGEX, JSON_APP_LABEL_REGEXS_SUB));
        ResponseBuilder responseBuilder = new ResponseBuilder();
        responseBuilder.clone(resp);
        responseBuilder.setBody(filteredJSONPath.prettify());
        resp = responseBuilder.build();
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)resp.then()).assertThat()).body("'countMe2;tier=integration'", Matchers.equalTo((Object)1), new Object[0])).assertThat()).body("'org.eclipse.microprofile.metrics.test.MetricAppBean2.meterMe2'.'count;tier=integration'", Matchers.equalTo((Object)1), new Object[0])).assertThat()).body("'timeMe2'.'count;tier=integration'", Matchers.equalTo((Object)1), new Object[0])).assertThat()).body("'simplyTimeMe2'.'count;tier=integration'", Matchers.equalTo((Object)1), new Object[0]);
    }

    @Test
    @InSequence(value=3)
    public void setB() {
        this.metricAppBean.countMeB();
        this.metricAppBean.meterMeB();
        this.metricAppBean.timeMeB();
        this.metricAppBean.simplyTimeMeB();
    }

    @Test
    @RunAsClient
    @InSequence(value=4)
    public void testSharedCounterAgain() {
        Header acceptJson = new Header("Accept", APPLICATION_JSON);
        Response resp = (Response)RestAssured.given().header(acceptJson).get("/metrics/application", new Object[0]);
        JsonPath filteredJSONPath = new JsonPath(resp.jsonPath().prettify().replaceAll(JSON_APP_LABEL_REGEX, JSON_APP_LABEL_REGEXS_SUB));
        ResponseBuilder responseBuilder = new ResponseBuilder();
        responseBuilder.clone(resp);
        responseBuilder.setBody(filteredJSONPath.prettify());
        resp = responseBuilder.build();
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)resp.then()).assertThat()).body("'countMe2;tier=integration'", Matchers.equalTo((Object)2), new Object[0])).assertThat()).body("'org.eclipse.microprofile.metrics.test.MetricAppBean2.meterMe2'.'count;tier=integration'", Matchers.equalTo((Object)2), new Object[0])).assertThat()).body("'timeMe2'.'count;tier=integration'", Matchers.equalTo((Object)2), new Object[0])).assertThat()).body("'simplyTimeMe2'.'count;tier=integration'", Matchers.equalTo((Object)2), new Object[0]);
    }
}

