/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.metrics.test;

import io.restassured.RestAssured;
import io.restassured.builder.ResponseBuilder;
import io.restassured.http.Header;
import io.restassured.path.json.JsonPath;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.test.MetricAppBean;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.container.test.api.RunAsClient;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.junit.InSequence;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

@RunWith(value=Arquillian.class)
public class MpMetricTest {
    private static final String APPLICATION_JSON = "application/json";
    private static final String TEXT_PLAIN = "text/plain";
    private static final String JSON_APP_LABEL_REGEX = ";_app=[-/A-Za-z0-9]+([;\\\"]?)";
    private static final String JSON_APP_LABEL_REGEXS_SUB = "$1";
    private static final String OPENMETRICS_APP_LABEL_REGEX = "_app=\"[-/A-Za-z0-9]+\"";
    private static final String DEFAULT_PROTOCOL = "http";
    private static final String DEFAULT_HOST = "localhost";
    private static final int DEFAULT_PORT = 8080;
    public static final double TOLERANCE = 0.025;
    @Inject
    private MetricAppBean metricAppBean;

    private static String filterOutAppLabelJSON(String responseBody) {
        return responseBody.replaceAll(JSON_APP_LABEL_REGEX, JSON_APP_LABEL_REGEXS_SUB);
    }

    private static String filterOutAppLabelOpenMetrics(String responseBody) {
        return responseBody.replaceAll(OPENMETRICS_APP_LABEL_REGEX, "").replaceAll("\\{,", "{").replaceAll(",\\}", "}");
    }

    @BeforeClass
    public static void setup() throws MalformedURLException {
        String serverUrl = System.getProperty("test.url");
        String protocol = DEFAULT_PROTOCOL;
        String host = DEFAULT_HOST;
        int port = 8080;
        if (serverUrl != null) {
            URL url = new URL(serverUrl);
            protocol = url.getProtocol();
            host = url.getHost();
            port = url.getPort() == -1 ? 8080 : url.getPort();
        }
        RestAssured.baseURI = protocol + "://" + host;
        RestAssured.port = port;
        String userName = System.getProperty("test.user");
        String password = System.getProperty("test.pwd");
        if (userName != null && password != null) {
            RestAssured.authentication = RestAssured.basic((String)userName, (String)password);
            RestAssured.useRelaxedHTTPSValidation();
        }
    }

    @Deployment
    public static WebArchive createDeployment() {
        WebArchive jar = (WebArchive)((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class)).addClass(MetricAppBean.class)).addAsWebInfResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
        System.out.println(jar.toString(true));
        return jar;
    }

    @Test
    @RunAsClient
    @InSequence(value=1)
    public void testApplicationJsonResponseContentType() {
        Header acceptHeader = new Header("Accept", APPLICATION_JSON);
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().header(acceptHeader).when().get("/metrics", new Object[0])).then()).statusCode(200)).and()).contentType(APPLICATION_JSON);
    }

    @Test
    @RunAsClient
    @InSequence(value=2)
    public void testTextPlainResponseContentType() {
        Header acceptHeader = new Header("Accept", TEXT_PLAIN);
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().header(acceptHeader).when().get("/metrics", new Object[0])).then()).statusCode(200)).and()).contentType(TEXT_PLAIN);
    }

    @Test
    @RunAsClient
    @InSequence(value=3)
    public void testBadSubTreeWillReturn404() {
        ((ValidatableResponse)((Response)RestAssured.when().get("/metrics/bad-tree", new Object[0])).then()).statusCode(404);
    }

    @Test
    @RunAsClient
    @InSequence(value=4)
    public void testListsAllJson() {
        Assume.assumeFalse((boolean)Boolean.getBoolean("skip.base.metric.tests"));
        Header acceptHeader = new Header("Accept", APPLICATION_JSON);
        Map response = (Map)((Response)RestAssured.given().header(acceptHeader).when().get("/metrics", new Object[0])).as(Map.class);
        Assert.assertTrue((boolean)response.containsKey("base"));
        if (response.containsKey("application")) {
            Map applicationData = (Map)response.get("application");
            Assert.assertThat((Object)applicationData.size(), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
        }
        if (response.containsKey("vendor")) {
            Map vendorData = (Map)response.get("vendor");
            Assert.assertThat((Object)vendorData.size(), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
        }
    }

    @Test
    @RunAsClient
    @InSequence(value=5)
    public void testBase() {
        Assume.assumeFalse((boolean)Boolean.getBoolean("skip.base.metric.tests"));
        Response resp = (Response)RestAssured.given().header("Accept", (Object)APPLICATION_JSON, new Object[0]).get("/metrics/base", new Object[0]);
        JsonPath filteredJSONPath = new JsonPath(MpMetricTest.filterOutAppLabelJSON(resp.jsonPath().prettify()));
        ResponseBuilder responseBuilder = new ResponseBuilder();
        responseBuilder.clone(resp);
        responseBuilder.setBody(filteredJSONPath.prettify());
        resp = responseBuilder.build();
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)resp.then()).statusCode(200)).and()).contentType(APPLICATION_JSON)).and()).body(CoreMatchers.containsString((String)"thread.max.count;tier=integration"), new Matcher[0]);
    }

    @Test
    @RunAsClient
    @InSequence(value=6)
    public void testBaseOpenMetrics() {
        Assume.assumeFalse((boolean)Boolean.getBoolean("skip.base.metric.tests"));
        Response resp = (Response)RestAssured.given().header("Accept", (Object)TEXT_PLAIN, new Object[0]).get("/metrics/base", new Object[0]);
        ResponseBuilder responseBuilder = new ResponseBuilder();
        responseBuilder.clone(resp);
        responseBuilder.setBody(MpMetricTest.filterOutAppLabelOpenMetrics(resp.getBody().asString()));
        resp = responseBuilder.build();
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)resp.then()).statusCode(200)).and()).contentType(TEXT_PLAIN)).and()).body(CoreMatchers.containsString((String)"# TYPE base_thread_max_count"), new Matcher[]{CoreMatchers.containsString((String)"base_thread_max_count{tier=\"integration\"}")});
    }

    @Test
    @RunAsClient
    @InSequence(value=7)
    public void testBaseAttributeJson() {
        Assume.assumeFalse((boolean)Boolean.getBoolean("skip.base.metric.tests"));
        Header wantJson = new Header("Accept", APPLICATION_JSON);
        Response resp = (Response)RestAssured.given().header(wantJson).get("/metrics/base/thread.max.count", new Object[0]);
        JsonPath filteredJSONPath = new JsonPath(MpMetricTest.filterOutAppLabelJSON(resp.jsonPath().prettify()));
        ResponseBuilder responseBuilder = new ResponseBuilder();
        responseBuilder.clone(resp);
        responseBuilder.setBody(filteredJSONPath.prettify());
        resp = responseBuilder.build();
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)resp.then()).statusCode(200)).and()).contentType(APPLICATION_JSON)).and()).body(CoreMatchers.containsString((String)"thread.max.count;tier=integration"), new Matcher[0]);
    }

    @Test
    @RunAsClient
    @InSequence(value=8)
    public void testBaseSingularMetricsPresent() {
        Assume.assumeFalse((boolean)Boolean.getBoolean("skip.base.metric.tests"));
        Header wantJson = new Header("Accept", APPLICATION_JSON);
        JsonPath jsonPath = ((Response)RestAssured.given().header(wantJson).get("/metrics/base", new Object[0])).jsonPath();
        JsonPath filteredJSONPath = new JsonPath(jsonPath.prettify().replaceAll(JSON_APP_LABEL_REGEX, JSON_APP_LABEL_REGEXS_SUB));
        Map elements = filteredJSONPath.getMap(".");
        ArrayList<String> missing = new ArrayList<String>();
        Map<String, MiniMeta> baseNames = this.getExpectedMetadataFromXmlFile(MetricRegistry.Type.BASE);
        for (MiniMeta item : baseNames.values()) {
            if (item.name.startsWith("gc.") || elements.containsKey(item.toJSONName()) || baseNames.get(item.name).optional) continue;
            missing.add(item.toJSONName());
        }
        Assert.assertTrue((String)("Following base items are missing: " + Arrays.toString(missing.toArray())), (boolean)missing.isEmpty());
    }

    @Test
    @RunAsClient
    @InSequence(value=9)
    public void testBaseAttributeOpenMetrics() {
        Assume.assumeFalse((boolean)Boolean.getBoolean("skip.base.metric.tests"));
        Response resp = (Response)RestAssured.given().header("Accept", (Object)TEXT_PLAIN, new Object[0]).get("/metrics/base/thread.max.count", new Object[0]);
        ResponseBuilder responseBuilder = new ResponseBuilder();
        responseBuilder.clone(resp);
        responseBuilder.setBody(MpMetricTest.filterOutAppLabelOpenMetrics(resp.getBody().asString()));
        resp = responseBuilder.build();
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)resp.then()).statusCode(200)).and()).contentType(TEXT_PLAIN)).and()).body(CoreMatchers.containsString((String)"# TYPE base_thread_max_count"), new Matcher[]{CoreMatchers.containsString((String)"base_thread_max_count{tier=\"integration\"}")});
    }

    @Test
    @RunAsClient
    @InSequence(value=10)
    public void testBaseMetadata() {
        Assume.assumeFalse((boolean)Boolean.getBoolean("skip.base.metric.tests"));
        Header wantJson = new Header("Accept", APPLICATION_JSON);
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().header(wantJson).options("/metrics/base", new Object[0])).then()).statusCode(200)).and()).contentType(APPLICATION_JSON);
    }

    @Test
    @RunAsClient
    @InSequence(value=11)
    public void testBaseMetadataSingluarItems() {
        Assume.assumeFalse((boolean)Boolean.getBoolean("skip.base.metric.tests"));
        Header wantJson = new Header("Accept", APPLICATION_JSON);
        JsonPath jsonPath = ((Response)RestAssured.given().header(wantJson).options("/metrics/base", new Object[0])).jsonPath();
        Map elements = jsonPath.getMap(".");
        ArrayList<String> missing = new ArrayList<String>();
        Map<String, MiniMeta> baseNames = this.getExpectedMetadataFromXmlFile(MetricRegistry.Type.BASE);
        for (String item : baseNames.keySet()) {
            if (item.startsWith("gc.") || baseNames.get(item).optional || elements.containsKey(item)) continue;
            missing.add(item);
        }
        Assert.assertTrue((String)("Following base items are missing: " + Arrays.toString(missing.toArray())), (boolean)missing.isEmpty());
    }

    @Test
    @RunAsClient
    @InSequence(value=12)
    public void testBaseMetadataTypeAndUnit() {
        Assume.assumeFalse((boolean)Boolean.getBoolean("skip.base.metric.tests"));
        Header wantJson = new Header("Accept", APPLICATION_JSON);
        JsonPath jsonPath = ((Response)RestAssured.given().header(wantJson).options("/metrics/base", new Object[0])).jsonPath();
        Map elements = jsonPath.getMap(".");
        Map<String, MiniMeta> expectedMetadata = this.getExpectedMetadataFromXmlFile(MetricRegistry.Type.BASE);
        this.checkMetadataPresent(elements, expectedMetadata);
    }

    private void checkMetadataPresent(Map<String, Map<String, Object>> elements, Map<String, MiniMeta> expectedMetadata) {
        for (Map.Entry<String, MiniMeta> entry : expectedMetadata.entrySet()) {
            MiniMeta item = entry.getValue();
            if (item.name.startsWith("gc.") || expectedMetadata.get(item.name).optional) continue;
            Map<String, Object> fromServer = elements.get(item.name);
            Assert.assertNotNull((String)("Got no data for metric " + item.name + " from the server"), fromServer);
            Assert.assertEquals((String)("expected " + item.type + " but got " + fromServer.get("type") + " for type of metric " + item.name), (Object)item.type, (Object)fromServer.get("type"));
            Assert.assertEquals((String)("expected " + item.unit + " but got " + fromServer.get("unit") + " for unit of metric " + item.name), (Object)item.unit, (Object)fromServer.get("unit"));
            if (item.description != null && !item.description.isEmpty()) {
                Assert.assertEquals((String)("expected " + item.description + " but got " + fromServer.get("description") + " for description of metric " + item.name), (Object)item.description, (Object)fromServer.get("description"));
            }
            if (item.displayName == null || item.displayName.isEmpty()) continue;
            Assert.assertEquals((String)("expected " + item.displayName + " but got " + fromServer.get("displayName") + " for displayName of " + item.name), (Object)item.displayName, (Object)fromServer.get("displayName"));
        }
    }

    @Test
    @RunAsClient
    @InSequence(value=13)
    public void testOpenMetricsFormatNoBadChars() {
        String[] lines;
        Assume.assumeFalse((boolean)Boolean.getBoolean("skip.base.metric.tests"));
        Header wantOpenMetricsFormat = new Header("Accept", TEXT_PLAIN);
        String data = ((Response)RestAssured.given().header(wantOpenMetricsFormat).get("/metrics/base", new Object[0])).asString();
        for (String line : lines = data.split("\n")) {
            if (line.startsWith("#")) continue;
            String nameAndTagsPart = line.substring(0, line.lastIndexOf(" "));
            String namePart = nameAndTagsPart.contains("{") ? nameAndTagsPart.substring(0, nameAndTagsPart.lastIndexOf("{")) : nameAndTagsPart;
            Assert.assertFalse((String)("Name has illegal chars " + line), (boolean)namePart.matches(".*[-.].*"));
            Assert.assertFalse((String)("Found __ in " + line), (boolean)line.matches(".*__.*"));
        }
    }

    @Test
    @RunAsClient
    @InSequence(value=14)
    public void testBaseMetadataSingluarItemsOpenMetrics() {
        Assume.assumeFalse((boolean)Boolean.getBoolean("skip.base.metric.tests"));
        Header wantOpenMetricsFormat = new Header("Accept", TEXT_PLAIN);
        String data = ((Response)RestAssured.given().header(wantOpenMetricsFormat).get("/metrics/base", new Object[0])).asString();
        String[] lines = data.split("\n");
        Map<String, MiniMeta> expectedMetadata = this.getExpectedMetadataFromXmlFile(MetricRegistry.Type.BASE);
        for (MiniMeta mm : expectedMetadata.values()) {
            boolean found = false;
            if (mm.name.startsWith("gc.") || expectedMetadata.get(mm.name).optional) continue;
            for (String line : lines) {
                if (!line.startsWith("# TYPE base_")) continue;
                String fullLine = line;
                int c = line.indexOf("_");
                line = line.substring(c + 1);
                String promName = mm.toPromString();
                String[] tmp = line.split(" ");
                Assert.assertEquals((String)("Bad entry: " + line), (long)tmp.length, (long)2L);
                if (!tmp[0].startsWith(promName)) continue;
                found = true;
                Assert.assertEquals((String)("Expected [" + mm.toString() + "] got [" + fullLine + "]"), (Object)tmp[1], (Object)mm.type);
            }
            Assert.assertTrue((String)("Not found [" + mm.toString() + "]"), (boolean)found);
        }
    }

    @Test
    @RunAsClient
    @InSequence(value=15)
    public void testBaseMetadataGarbageCollection() {
        Assume.assumeFalse((boolean)Boolean.getBoolean("skip.base.metric.tests"));
        Header wantJson = new Header("Accept", APPLICATION_JSON);
        JsonPath jsonPath = ((Response)RestAssured.given().header(wantJson).options("/metrics/base", new Object[0])).jsonPath();
        int count = 0;
        Map elements = jsonPath.getMap(".");
        for (String name : elements.keySet()) {
            if (!name.startsWith("gc.")) continue;
            Assert.assertTrue((name.endsWith(".total") || name.endsWith(".time") ? 1 : 0) != 0);
            ++count;
        }
        Assert.assertThat((Object)count, (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
    }

    @Test
    @RunAsClient
    @InSequence(value=16)
    public void testApplicationMetadataOkJson() {
        Header wantJson = new Header("Accept", APPLICATION_JSON);
        Response response = (Response)RestAssured.given().header(wantJson).options("/metrics/application", new Object[0]);
        int code = response.getStatusCode();
        Assert.assertTrue((code == 200 || code == 204 ? 1 : 0) != 0);
    }

    @Test
    @InSequence(value=17)
    public void testSetupApplicationMetrics() {
        this.metricAppBean.countMe();
        this.metricAppBean.countMeA();
        this.metricAppBean.countMeB();
        this.metricAppBean.gaugeMe();
        this.metricAppBean.gaugeMeA();
        this.metricAppBean.gaugeMeB();
        this.metricAppBean.gaugeMeTagged();
        this.metricAppBean.gaugeMeTaggedOne();
        this.metricAppBean.gaugeMeTaggedTwo();
        this.metricAppBean.histogramMe();
        this.metricAppBean.meterMe();
        this.metricAppBean.meterMeA();
        this.metricAppBean.timeMe();
        this.metricAppBean.timeMeA();
        this.metricAppBean.concGaugeMeA();
    }

    @Test
    @RunAsClient
    @InSequence(value=18)
    public void testApplicationMetricsJSON() {
        Header wantJson = new Header("Accept", APPLICATION_JSON);
        Response resp = (Response)RestAssured.given().header(wantJson).get("/metrics/application", new Object[0]);
        JsonPath filteredJSONPath = new JsonPath(MpMetricTest.filterOutAppLabelJSON(resp.jsonPath().prettify()));
        ResponseBuilder responseBuilder = new ResponseBuilder();
        responseBuilder.clone(resp);
        responseBuilder.setBody(filteredJSONPath.prettify());
        resp = responseBuilder.build();
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)resp.then()).statusCode(200)).body("'org.eclipse.microprofile.metrics.test.MetricAppBean.redCount;tier=integration'", CoreMatchers.equalTo((Object)0), new Object[0])).body("'org.eclipse.microprofile.metrics.test.MetricAppBean.blue;tier=integration'", CoreMatchers.equalTo((Object)0), new Object[0])).body("'greenCount;tier=integration'", CoreMatchers.equalTo((Object)0), new Object[0])).body("'purple;app=myShop;tier=integration'", CoreMatchers.equalTo((Object)0), new Object[0])).body("'metricTest.test1.count;tier=integration'", CoreMatchers.equalTo((Object)1), new Object[0])).body("'metricTest.test1.countMeA;tier=integration'", CoreMatchers.equalTo((Object)1), new Object[0])).body("'metricTest.test1.countMeB;tier=integration'", CoreMatchers.equalTo((Object)1), new Object[0])).body("'metricTest.test1.gauge;tier=integration'", CoreMatchers.equalTo((Object)19), new Object[0])).body("'org.eclipse.microprofile.metrics.test.MetricAppBean.gaugeMeA;tier=integration'", CoreMatchers.equalTo((Object)1000), new Object[0])).body("'org.eclipse.microprofile.metrics.test.MetricAppBean.gaugeMeB;tier=integration'", CoreMatchers.equalTo((Object)7777777), new Object[0])).body("'metricTest.test1.histogram'.'count;tier=integration'", CoreMatchers.equalTo((Object)1000), new Object[0])).body("'metricTest.test1.histogram'.'max;tier=integration'", CoreMatchers.equalTo((Object)999), new Object[0])).body("'metricTest.test1.histogram'.'mean;tier=integration'", this.closeTo(499.5), new Object[0])).body("'metricTest.test1.histogram'.'min;tier=integration'", CoreMatchers.equalTo((Object)0), new Object[0])).body("'metricTest.test1.histogram'.'p50;tier=integration'", this.closeTo(499.0), new Object[0])).body("'metricTest.test1.histogram'.'p75;tier=integration'", this.closeTo(749.0), new Object[0])).body("'metricTest.test1.histogram'.'p95;tier=integration'", this.closeTo(949.0), new Object[0])).body("'metricTest.test1.histogram'.'p98;tier=integration'", this.closeTo(979.0), new Object[0])).body("'metricTest.test1.histogram'.'p99;tier=integration'", this.closeTo(989.0), new Object[0])).body("'metricTest.test1.histogram'.'p999;tier=integration'", this.closeTo(998.0), new Object[0])).body("'metricTest.test1.histogram'", Matchers.hasKey((Object)"stddev;tier=integration"), new Object[0])).body("'metricTest.test1.meter'.'count;tier=integration'", CoreMatchers.equalTo((Object)1), new Object[0])).body("'metricTest.test1.meter'", Matchers.hasKey((Object)"fifteenMinRate;tier=integration"), new Object[0])).body("'metricTest.test1.meter'", Matchers.hasKey((Object)"fiveMinRate;tier=integration"), new Object[0])).body("'metricTest.test1.meter'", Matchers.hasKey((Object)"meanRate;tier=integration"), new Object[0])).body("'metricTest.test1.meter'", Matchers.hasKey((Object)"oneMinRate;tier=integration"), new Object[0])).body("'meterMeA'.'count;tier=integration'", CoreMatchers.equalTo((Object)1), new Object[0])).body("'meterMeA'", Matchers.hasKey((Object)"fifteenMinRate;tier=integration"), new Object[0])).body("'meterMeA'", Matchers.hasKey((Object)"fiveMinRate;tier=integration"), new Object[0])).body("'meterMeA'", Matchers.hasKey((Object)"meanRate;tier=integration"), new Object[0])).body("'meterMeA'", Matchers.hasKey((Object)"oneMinRate;tier=integration"), new Object[0])).body("'metricTest.test1.timer'.'count;tier=integration'", CoreMatchers.equalTo((Object)1), new Object[0])).body("'metricTest.test1.timer'", Matchers.hasKey((Object)"fifteenMinRate;tier=integration"), new Object[0])).body("'metricTest.test1.timer'", Matchers.hasKey((Object)"fiveMinRate;tier=integration"), new Object[0])).body("'metricTest.test1.timer'", Matchers.hasKey((Object)"meanRate;tier=integration"), new Object[0])).body("'metricTest.test1.timer'", Matchers.hasKey((Object)"oneMinRate;tier=integration"), new Object[0])).body("'metricTest.test1.timer'", Matchers.hasKey((Object)"max;tier=integration"), new Object[0])).body("'metricTest.test1.timer'", Matchers.hasKey((Object)"mean;tier=integration"), new Object[0])).body("'metricTest.test1.timer'", Matchers.hasKey((Object)"min;tier=integration"), new Object[0])).body("'metricTest.test1.timer'", Matchers.hasKey((Object)"p50;tier=integration"), new Object[0])).body("'metricTest.test1.timer'", Matchers.hasKey((Object)"p75;tier=integration"), new Object[0])).body("'metricTest.test1.timer'", Matchers.hasKey((Object)"p95;tier=integration"), new Object[0])).body("'metricTest.test1.timer'", Matchers.hasKey((Object)"p98;tier=integration"), new Object[0])).body("'metricTest.test1.timer'", Matchers.hasKey((Object)"p99;tier=integration"), new Object[0])).body("'metricTest.test1.timer'", Matchers.hasKey((Object)"p999;tier=integration"), new Object[0])).body("'metricTest.test1.timer'", Matchers.hasKey((Object)"stddev;tier=integration"), new Object[0])).body("'org.eclipse.microprofile.metrics.test.MetricAppBean.timeMeA'.'count;tier=integration'", CoreMatchers.equalTo((Object)1), new Object[0])).body("'org.eclipse.microprofile.metrics.test.MetricAppBean.timeMeA'", Matchers.hasKey((Object)"fifteenMinRate;tier=integration"), new Object[0])).body("'org.eclipse.microprofile.metrics.test.MetricAppBean.timeMeA'", Matchers.hasKey((Object)"fiveMinRate;tier=integration"), new Object[0])).body("'org.eclipse.microprofile.metrics.test.MetricAppBean.timeMeA'", Matchers.hasKey((Object)"meanRate;tier=integration"), new Object[0])).body("'org.eclipse.microprofile.metrics.test.MetricAppBean.timeMeA'", Matchers.hasKey((Object)"oneMinRate;tier=integration"), new Object[0])).body("'org.eclipse.microprofile.metrics.test.MetricAppBean.timeMeA'", Matchers.hasKey((Object)"max;tier=integration"), new Object[0])).body("'org.eclipse.microprofile.metrics.test.MetricAppBean.timeMeA'", Matchers.hasKey((Object)"mean;tier=integration"), new Object[0])).body("'org.eclipse.microprofile.metrics.test.MetricAppBean.timeMeA'", Matchers.hasKey((Object)"min;tier=integration"), new Object[0])).body("'org.eclipse.microprofile.metrics.test.MetricAppBean.timeMeA'", Matchers.hasKey((Object)"p50;tier=integration"), new Object[0])).body("'org.eclipse.microprofile.metrics.test.MetricAppBean.timeMeA'", Matchers.hasKey((Object)"p75;tier=integration"), new Object[0])).body("'org.eclipse.microprofile.metrics.test.MetricAppBean.timeMeA'", Matchers.hasKey((Object)"p95;tier=integration"), new Object[0])).body("'org.eclipse.microprofile.metrics.test.MetricAppBean.timeMeA'", Matchers.hasKey((Object)"p98;tier=integration"), new Object[0])).body("'org.eclipse.microprofile.metrics.test.MetricAppBean.timeMeA'", Matchers.hasKey((Object)"p99;tier=integration"), new Object[0])).body("'org.eclipse.microprofile.metrics.test.MetricAppBean.timeMeA'", Matchers.hasKey((Object)"p999;tier=integration"), new Object[0])).body("'org.eclipse.microprofile.metrics.test.MetricAppBean.timeMeA'", Matchers.hasKey((Object)"stddev;tier=integration"), new Object[0]);
    }

    @Test
    @RunAsClient
    @InSequence(value=19)
    public void testApplicationMetadataItems() {
        Header wantJson = new Header("Accept", APPLICATION_JSON);
        JsonPath jsonPath = ((Response)RestAssured.given().header(wantJson).options("/metrics/application", new Object[0])).jsonPath();
        Map elements = jsonPath.getMap(".");
        ArrayList<String> missing = new ArrayList<String>();
        Map<String, MiniMeta> names = this.getExpectedMetadataFromXmlFile(MetricRegistry.Type.APPLICATION);
        for (String item : names.keySet()) {
            if (elements.containsKey(item)) continue;
            missing.add(item);
        }
        Assert.assertTrue((String)("Following application items are missing: " + Arrays.toString(missing.toArray())), (boolean)missing.isEmpty());
    }

    @Test
    @RunAsClient
    @InSequence(value=20)
    public void testApplicationMetadataTypeAndUnit() {
        Header wantJson = new Header("Accept", APPLICATION_JSON);
        JsonPath jsonPath = ((Response)RestAssured.given().header(wantJson).options("/metrics/application", new Object[0])).jsonPath();
        Map elements = jsonPath.getMap(".");
        Map<String, MiniMeta> expectedMetadata = this.getExpectedMetadataFromXmlFile(MetricRegistry.Type.APPLICATION);
        this.checkMetadataPresent(elements, expectedMetadata);
    }

    @Test
    @RunAsClient
    @InSequence(value=21)
    public void testApplicationTagJson() {
        JsonPath jsonPath = ((Response)RestAssured.given().header("Accept", (Object)APPLICATION_JSON, new Object[0]).when().options("/metrics/application/purple", new Object[0])).jsonPath();
        String tags = jsonPath.getString("purple.tags");
        Assert.assertNotNull((Object)tags);
        Assert.assertTrue((boolean)tags.contains("app=myShop"));
        Assert.assertTrue((boolean)tags.contains("tier=integration"));
    }

    @Test
    @RunAsClient
    @InSequence(value=22)
    public void testApplicationTagOpenMetrics() {
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().header("Accept", (Object)TEXT_PLAIN, new Object[0]).when().get("/metrics/application/purple", new Object[0])).then()).statusCode(200)).and()).body(CoreMatchers.containsString((String)"tier=\"integration\""), new Matcher[0])).body(CoreMatchers.containsString((String)"app=\"myShop\""), new Matcher[0]);
    }

    @Test
    @RunAsClient
    @InSequence(value=23)
    public void testApplicationMeterUnitOpenMetrics() {
        String prefix = "meterMeA_";
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().header("Accept", (Object)TEXT_PLAIN, new Object[0]).when().get("/metrics/application/meterMeA", new Object[0])).then()).statusCode(200)).and()).body(CoreMatchers.containsString((String)(prefix + "total")), new Matcher[0])).body(CoreMatchers.containsString((String)(prefix + "rate_per_second")), new Matcher[0])).body(CoreMatchers.containsString((String)(prefix + "one_min_rate_per_second")), new Matcher[0])).body(CoreMatchers.containsString((String)(prefix + "five_min_rate_per_second")), new Matcher[0])).body(CoreMatchers.containsString((String)(prefix + "fifteen_min_rate_per_second")), new Matcher[0]);
    }

    @Test
    @RunAsClient
    @InSequence(value=24)
    public void testApplicationTimerUnitOpenMetrics() {
        String prefix = "org_eclipse_microprofile_metrics_test_MetricAppBean_timeMeA_";
        Response resp = (Response)RestAssured.given().header("Accept", (Object)TEXT_PLAIN, new Object[0]).get("/metrics/application/org.eclipse.microprofile.metrics.test.MetricAppBean.timeMeA", new Object[0]);
        ResponseBuilder responseBuilder = new ResponseBuilder();
        responseBuilder.clone(resp);
        responseBuilder.setBody(MpMetricTest.filterOutAppLabelOpenMetrics(resp.getBody().asString()));
        resp = responseBuilder.build();
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)resp.then()).statusCode(200)).and()).body(CoreMatchers.containsString((String)("# TYPE application_" + prefix + "seconds summary")), new Matcher[0])).body(CoreMatchers.containsString((String)(prefix + "seconds_count")), new Matcher[0])).body(CoreMatchers.containsString((String)(prefix + "rate_per_second")), new Matcher[0])).body(CoreMatchers.containsString((String)(prefix + "one_min_rate_per_second")), new Matcher[0])).body(CoreMatchers.containsString((String)(prefix + "five_min_rate_per_second")), new Matcher[0])).body(CoreMatchers.containsString((String)(prefix + "fifteen_min_rate_per_second")), new Matcher[0])).body(CoreMatchers.containsString((String)(prefix + "mean_seconds")), new Matcher[0])).body(CoreMatchers.containsString((String)(prefix + "min_seconds")), new Matcher[0])).body(CoreMatchers.containsString((String)(prefix + "max_seconds")), new Matcher[0])).body(CoreMatchers.containsString((String)(prefix + "stddev_second")), new Matcher[0])).body(CoreMatchers.containsString((String)(prefix + "seconds{tier=\"integration\",quantile=\"0.5\"}")), new Matcher[0])).body(CoreMatchers.containsString((String)(prefix + "seconds{tier=\"integration\",quantile=\"0.75\"}")), new Matcher[0])).body(CoreMatchers.containsString((String)(prefix + "seconds{tier=\"integration\",quantile=\"0.95\"}")), new Matcher[0])).body(CoreMatchers.containsString((String)(prefix + "seconds{tier=\"integration\",quantile=\"0.98\"}")), new Matcher[0])).body(CoreMatchers.containsString((String)(prefix + "seconds{tier=\"integration\",quantile=\"0.99\"}")), new Matcher[0])).body(CoreMatchers.containsString((String)(prefix + "seconds{tier=\"integration\",quantile=\"0.999\"}")), new Matcher[0]);
    }

    @Test
    @RunAsClient
    @InSequence(value=25)
    public void testApplicationHistogramUnitBytesOpenMetrics() {
        String prefix = "metricTest_test1_histogram_";
        Response resp = (Response)RestAssured.given().header("Accept", (Object)TEXT_PLAIN, new Object[0]).get("/metrics/application/metricTest.test1.histogram", new Object[0]);
        ResponseBuilder responseBuilder = new ResponseBuilder();
        responseBuilder.clone(resp);
        responseBuilder.setBody(MpMetricTest.filterOutAppLabelOpenMetrics(resp.getBody().asString()));
        resp = responseBuilder.build();
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)resp.then()).statusCode(200)).and()).body(CoreMatchers.containsString((String)(prefix + "bytes_count")), new Matcher[0])).body(CoreMatchers.containsString((String)("# TYPE application_" + prefix + "bytes summary")), new Matcher[0])).body(CoreMatchers.containsString((String)(prefix + "mean_bytes")), new Matcher[0])).body(CoreMatchers.containsString((String)(prefix + "min_bytes")), new Matcher[0])).body(CoreMatchers.containsString((String)(prefix + "max_bytes")), new Matcher[0])).body(CoreMatchers.containsString((String)(prefix + "stddev_bytes")), new Matcher[0])).body(CoreMatchers.containsString((String)(prefix + "bytes{tier=\"integration\",quantile=\"0.5\"}")), new Matcher[0])).body(CoreMatchers.containsString((String)(prefix + "bytes{tier=\"integration\",quantile=\"0.75\"}")), new Matcher[0])).body(CoreMatchers.containsString((String)(prefix + "bytes{tier=\"integration\",quantile=\"0.95\"}")), new Matcher[0])).body(CoreMatchers.containsString((String)(prefix + "bytes{tier=\"integration\",quantile=\"0.98\"}")), new Matcher[0])).body(CoreMatchers.containsString((String)(prefix + "bytes{tier=\"integration\",quantile=\"0.99\"}")), new Matcher[0])).body(CoreMatchers.containsString((String)(prefix + "bytes{tier=\"integration\",quantile=\"0.999\"}")), new Matcher[0]);
    }

    @Test
    @RunAsClient
    @InSequence(value=26)
    public void testApplicationHistogramUnitNoneOpenMetrics() {
        String prefix = "metricTest_test1_histogram2";
        Response resp = (Response)RestAssured.given().header("Accept", (Object)TEXT_PLAIN, new Object[0]).get("/metrics/application/metricTest.test1.histogram2", new Object[0]);
        ResponseBuilder responseBuilder = new ResponseBuilder();
        responseBuilder.clone(resp);
        responseBuilder.setBody(MpMetricTest.filterOutAppLabelOpenMetrics(resp.getBody().asString()));
        resp = responseBuilder.build();
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)resp.then()).statusCode(200)).and()).body(CoreMatchers.containsString((String)(prefix + "_count")), new Matcher[0])).body(CoreMatchers.containsString((String)("# TYPE application_" + prefix + " summary")), new Matcher[0])).body(CoreMatchers.containsString((String)(prefix + "_mean")), new Matcher[0])).body(CoreMatchers.containsString((String)(prefix + "_min")), new Matcher[0])).body(CoreMatchers.containsString((String)(prefix + "_max")), new Matcher[0])).body(CoreMatchers.containsString((String)(prefix + "_stddev")), new Matcher[0])).body(CoreMatchers.containsString((String)(prefix + "{tier=\"integration\",quantile=\"0.5\"}")), new Matcher[0])).body(CoreMatchers.containsString((String)(prefix + "{tier=\"integration\",quantile=\"0.75\"}")), new Matcher[0])).body(CoreMatchers.containsString((String)(prefix + "{tier=\"integration\",quantile=\"0.95\"}")), new Matcher[0])).body(CoreMatchers.containsString((String)(prefix + "{tier=\"integration\",quantile=\"0.98\"}")), new Matcher[0])).body(CoreMatchers.containsString((String)(prefix + "{tier=\"integration\",quantile=\"0.99\"}")), new Matcher[0])).body(CoreMatchers.containsString((String)(prefix + "{tier=\"integration\",quantile=\"0.999\"}")), new Matcher[0]);
    }

    @Test
    @RunAsClient
    @InSequence(value=27)
    public void testOpenMetrics406ForOptions() {
        ((ValidatableResponse)((Response)RestAssured.given().header("Accept", (Object)TEXT_PLAIN, new Object[0]).when().options("/metrics/application/metricTest.test1.histogram2", new Object[0])).then()).statusCode(406);
    }

    @Test
    @RunAsClient
    @InSequence(value=28)
    public void testConvertingToBaseUnit() {
        Header wantOpenMetricsFormat = new Header("Accept", TEXT_PLAIN);
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().header(wantOpenMetricsFormat).get("/metrics/application", new Object[0])).then()).statusCode(200)).and()).body(CoreMatchers.containsString((String)"TYPE application_org_eclipse_microprofile_metrics_test_MetricAppBean_gaugeMeA_bytes gauge"), new Matcher[0])).and()).body(CoreMatchers.containsString((String)"TYPE application_metricTest_test1_gauge_bytes gauge"), new Matcher[0]);
    }

    @Test
    @RunAsClient
    @InSequence(value=29)
    public void testNonStandardUnitsJSON() {
        Header wantJSONFormat = new Header("Accept", APPLICATION_JSON);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().header(wantJSONFormat).options("/metrics/application/jellybeanHistogram", new Object[0])).then()).statusCode(200)).body("jellybeanHistogram.unit", CoreMatchers.equalTo((Object)"jellybeans"), new Object[0]);
    }

    @Test
    @RunAsClient
    @InSequence(value=30)
    public void testNonStandardUnitsOpenMetrics() {
        String prefix = "jellybeanHistogram_";
        Header wantOpenMetricsFormat = new Header("Accept", TEXT_PLAIN);
        Response resp = (Response)RestAssured.given().header(wantOpenMetricsFormat).get("/metrics/application/jellybeanHistogram", new Object[0]);
        ResponseBuilder responseBuilder = new ResponseBuilder();
        responseBuilder.clone(resp);
        responseBuilder.setBody(MpMetricTest.filterOutAppLabelOpenMetrics(resp.getBody().asString()));
        resp = responseBuilder.build();
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)resp.then()).statusCode(200)).and()).body(CoreMatchers.containsString((String)(prefix + "jellybeans_count")), new Matcher[0])).body(CoreMatchers.containsString((String)("# TYPE application_" + prefix + "jellybeans summary")), new Matcher[0])).body(CoreMatchers.containsString((String)(prefix + "mean_jellybeans")), new Matcher[0])).body(CoreMatchers.containsString((String)(prefix + "min_jellybeans")), new Matcher[0])).body(CoreMatchers.containsString((String)(prefix + "max_jellybeans")), new Matcher[0])).body(CoreMatchers.containsString((String)(prefix + "stddev_jellybeans")), new Matcher[0])).body(CoreMatchers.containsString((String)(prefix + "jellybeans{tier=\"integration\",quantile=\"0.5\"}")), new Matcher[0])).body(CoreMatchers.containsString((String)(prefix + "jellybeans{tier=\"integration\",quantile=\"0.75\"}")), new Matcher[0])).body(CoreMatchers.containsString((String)(prefix + "jellybeans{tier=\"integration\",quantile=\"0.95\"}")), new Matcher[0])).body(CoreMatchers.containsString((String)(prefix + "jellybeans{tier=\"integration\",quantile=\"0.98\"}")), new Matcher[0])).body(CoreMatchers.containsString((String)(prefix + "jellybeans{tier=\"integration\",quantile=\"0.99\"}")), new Matcher[0])).body(CoreMatchers.containsString((String)(prefix + "jellybeans{tier=\"integration\",quantile=\"0.999\"}")), new Matcher[0]);
    }

    @Test
    @RunAsClient
    @InSequence(value=31)
    public void testOptionalBaseMetrics() {
        Assume.assumeFalse((boolean)Boolean.getBoolean("skip.base.metric.tests"));
        Header wantJson = new Header("Accept", APPLICATION_JSON);
        JsonPath jsonPath = ((Response)RestAssured.given().header(wantJson).options("/metrics/base", new Object[0])).jsonPath();
        Map elements = jsonPath.getMap(".");
        Map<String, MiniMeta> names = this.getExpectedMetadataFromXmlFile(MetricRegistry.Type.BASE);
        for (MiniMeta item : names.values()) {
            if (!elements.containsKey(item.toJSONName()) || !names.get(item.name).optional) continue;
            String prefix = names.get(item.name).name;
            String type = "'" + item.toJSONName() + "'.type";
            String unit = "'" + item.toJSONName() + "'.unit";
            ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().header(wantJson).options("/metrics/base/" + prefix, new Object[0])).then()).statusCode(200)).body(type, CoreMatchers.equalTo((Object)names.get(item.name).type), new Object[0])).body(unit, CoreMatchers.equalTo((Object)names.get(item.name).unit), new Object[0]);
        }
    }

    @Test
    @InSequence(value=32)
    public void testGlobalTagsViaConfig() {
        boolean expectedTag = this.metricAppBean.getGlobalTags().contains("tier=integration");
        Assert.assertEquals((Object)expectedTag, (Object)true);
    }

    @Test
    @InSequence(value=33)
    public void testSetupPromNoBadCharsInNames() {
        this.metricAppBean.createPromMetrics();
    }

    @Test
    @RunAsClient
    @InSequence(value=34)
    public void testPromNoBadCharsInNames() {
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().header("Accept", (Object)TEXT_PLAIN, new Object[0]).when().get("/metrics/application", new Object[0])).then()).statusCode(200)).and()).body(CoreMatchers.containsString((String)"pm_counter_with_dashes"), new Matcher[0])).body(CoreMatchers.containsString((String)"pm_counter_hash_x_y_"), new Matcher[0])).body(CoreMatchers.containsString((String)"pm_counter_umlaut_"), new Matcher[0])).body(CoreMatchers.containsString((String)"pm_counter_accent_"), new Matcher[0]);
    }

    @Test
    @RunAsClient
    @InSequence(value=35)
    public void testAccept1() {
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().header("Accept", (Object)"application/json;q=0.5,text/plain;q=0.5", new Object[0]).when().get("/metrics/application", new Object[0])).then()).statusCode(200)).and()).contentType(TEXT_PLAIN);
    }

    @Test
    @RunAsClient
    @InSequence(value=36)
    public void testAccept2() {
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().header("Accept", (Object)"application/json;q=0.1,text/plain;q=0.9", new Object[0]).when().get("/metrics/application", new Object[0])).then()).statusCode(200)).and()).contentType(TEXT_PLAIN);
    }

    @Test
    @RunAsClient
    @InSequence(value=37)
    public void testAccept3() {
        ((ValidatableResponse)((Response)RestAssured.given().header("Accept", (Object)"image/png,image/jpeg", new Object[0]).when().get("/metrics/application", new Object[0])).then()).statusCode(406);
    }

    @Test
    @RunAsClient
    @InSequence(value=38)
    public void testAccept4() {
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().header("Accept", (Object)"*/*", new Object[0]).when().get("/metrics/application", new Object[0])).then()).statusCode(200)).and()).contentType(TEXT_PLAIN);
    }

    @Test
    @RunAsClient
    @InSequence(value=39)
    public void testAccept5() {
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().header("Accept", (Object)"image/png;q=1,*/*;q=0.1", new Object[0]).when().get("/metrics/application", new Object[0])).then()).statusCode(200)).and()).contentType(TEXT_PLAIN);
    }

    @Test
    @RunAsClient
    @InSequence(value=40)
    public void testNoAcceptHeader() {
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get("/metrics/application", new Object[0])).then()).statusCode(200)).and()).contentType(TEXT_PLAIN);
    }

    @Test
    @RunAsClient
    @InSequence(value=41)
    public void testCustomUnitAppendToGaugeName() {
        Header wantOpenMetricsFormat = new Header("Accept", TEXT_PLAIN);
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().header(wantOpenMetricsFormat).get("/metrics/application", new Object[0])).then()).statusCode(200)).and()).body(CoreMatchers.containsString((String)"TYPE application_org_eclipse_microprofile_metrics_test_MetricAppBean_gaugeMeB_hands gauge"), new Matcher[0]);
    }

    @Test
    @RunAsClient
    @InSequence(value=42)
    public void testNoCustomUnitForCounter() {
        Header wantOpenMetricsFormat = new Header("Accept", TEXT_PLAIN);
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().header(wantOpenMetricsFormat).get("/metrics/application", new Object[0])).then()).statusCode(200)).and()).body(CoreMatchers.containsString((String)"TYPE application_metricTest_test1_countMeB_total counter"), new Matcher[0]);
    }

    @Test
    @RunAsClient
    @InSequence(value=43)
    public void testGcCountMetrics() {
        Assume.assumeFalse((boolean)Boolean.getBoolean("skip.base.metric.tests"));
        Header wantJson = new Header("Accept", APPLICATION_JSON);
        JsonPath jsonPath = ((Response)RestAssured.given().header(wantJson).get("/metrics/base", new Object[0])).jsonPath();
        Map<String, MiniMeta> baseNames = this.getExpectedMetadataFromXmlFile(MetricRegistry.Type.BASE);
        MiniMeta gcCountMetricMeta = baseNames.get("gc.total");
        Set expectedTags = gcCountMetricMeta.tags.keySet();
        Map elements = jsonPath.getMap(".");
        boolean found = false;
        for (Map.Entry metricEntry : elements.entrySet()) {
            if (!((String)metricEntry.getKey()).startsWith("gc.total")) continue;
            for (String expectedTag : expectedTags) {
                Assert.assertThat((String)("The metric should contain a " + expectedTag + " tag"), metricEntry.getKey(), (Matcher)CoreMatchers.containsString((String)(expectedTag + "=")));
            }
            Assert.assertTrue((String)"gc.total value should be numeric", (boolean)(metricEntry.getValue() instanceof Number));
            Assert.assertTrue((String)"gc.total value should not be a negative number", ((Integer)metricEntry.getValue() >= 0 ? 1 : 0) != 0);
            found = true;
        }
        Assert.assertTrue((String)"At least one metric named gc.total is expected", (boolean)found);
    }

    @Test
    @RunAsClient
    @InSequence(value=44)
    public void testGcTimeMetrics() {
        Assume.assumeFalse((boolean)Boolean.getBoolean("skip.base.metric.tests"));
        Header wantJson = new Header("Accept", APPLICATION_JSON);
        JsonPath jsonPath = ((Response)RestAssured.given().header(wantJson).get("/metrics/base", new Object[0])).jsonPath();
        Map<String, MiniMeta> baseNames = this.getExpectedMetadataFromXmlFile(MetricRegistry.Type.BASE);
        MiniMeta gcTimeMetricMeta = baseNames.get("gc.time");
        Set expectedTags = gcTimeMetricMeta.tags.keySet();
        Map elements = jsonPath.getMap(".");
        boolean found = false;
        for (Map.Entry metricEntry : elements.entrySet()) {
            if (!((String)metricEntry.getKey()).startsWith("gc.time")) continue;
            for (String expectedTag : expectedTags) {
                Assert.assertThat((String)("The metric should contain a " + expectedTag + " tag"), metricEntry.getKey(), (Matcher)CoreMatchers.containsString((String)(expectedTag + "=")));
            }
            Assert.assertTrue((String)"gc.time value should be numeric", (boolean)(metricEntry.getValue() instanceof Number));
            Assert.assertTrue((String)"gc.time value should not be a negative number", ((Integer)metricEntry.getValue() >= 0 ? 1 : 0) != 0);
            found = true;
        }
        Assert.assertTrue((String)"At least one metric named gc.time is expected", (boolean)found);
    }

    @Test
    @RunAsClient
    @InSequence(value=45)
    public void testMultipleTaggedMetricsJSON() {
        Header wantJson = new Header("Accept", APPLICATION_JSON);
        Response resp = (Response)RestAssured.given().header(wantJson).get("/metrics/application", new Object[0]);
        JsonPath filteredJSONPath = new JsonPath(MpMetricTest.filterOutAppLabelJSON(resp.jsonPath().prettify()));
        ResponseBuilder responseBuilder = new ResponseBuilder();
        responseBuilder.clone(resp);
        responseBuilder.setBody(filteredJSONPath.prettify());
        resp = responseBuilder.build();
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)resp.then()).statusCode(200)).body("'org.eclipse.microprofile.metrics.test.MetricAppBean.taggedCounter;tier=integration'", CoreMatchers.equalTo((Object)0), new Object[0])).body("'org.eclipse.microprofile.metrics.test.MetricAppBean.taggedCounter;number=one;tier=integration'", CoreMatchers.equalTo((Object)0), new Object[0])).body("'org.eclipse.microprofile.metrics.test.MetricAppBean.taggedCounter;number=two;tier=integration'", CoreMatchers.equalTo((Object)0), new Object[0])).body("'taggedConcurrentGauge'.'current;number=one;tier=integration'", CoreMatchers.equalTo((Object)0), new Object[0])).body("'taggedConcurrentGauge'.'min;number=one;tier=integration'", CoreMatchers.equalTo((Object)0), new Object[0])).body("'taggedConcurrentGauge'.'max;number=one;tier=integration'", CoreMatchers.equalTo((Object)0), new Object[0])).body("'taggedConcurrentGauge'.'current;number=two;tier=integration'", CoreMatchers.equalTo((Object)0), new Object[0])).body("'taggedConcurrentGauge'.'min;number=two;tier=integration'", CoreMatchers.equalTo((Object)0), new Object[0])).body("'taggedConcurrentGauge'.'max;number=two;tier=integration'", CoreMatchers.equalTo((Object)0), new Object[0])).body("'taggedGauge;number=one;tier=integration'", CoreMatchers.equalTo((Object)1000), new Object[0])).body("'taggedGauge;number=two;tier=integration'", CoreMatchers.equalTo((Object)1000), new Object[0])).body("'taggedHistogram'.'count;tier=integration'", CoreMatchers.equalTo((Object)0), new Object[0])).body("'taggedHistogram'", Matchers.hasKey((Object)"max;tier=integration"), new Object[0])).body("'taggedHistogram'", Matchers.hasKey((Object)"mean;tier=integration"), new Object[0])).body("'taggedHistogram'", Matchers.hasKey((Object)"min;tier=integration"), new Object[0])).body("'taggedHistogram'", Matchers.hasKey((Object)"p50;tier=integration"), new Object[0])).body("'taggedHistogram'", Matchers.hasKey((Object)"p75;tier=integration"), new Object[0])).body("'taggedHistogram'", Matchers.hasKey((Object)"p95;tier=integration"), new Object[0])).body("'taggedHistogram'", Matchers.hasKey((Object)"p98;tier=integration"), new Object[0])).body("'taggedHistogram'", Matchers.hasKey((Object)"p99;tier=integration"), new Object[0])).body("'taggedHistogram'", Matchers.hasKey((Object)"p999;tier=integration"), new Object[0])).body("'taggedHistogram'", Matchers.hasKey((Object)"stddev;tier=integration"), new Object[0])).body("'taggedHistogram'.'count;number=one;tier=integration'", CoreMatchers.equalTo((Object)0), new Object[0])).body("'taggedHistogram'", Matchers.hasKey((Object)"max;number=one;tier=integration"), new Object[0])).body("'taggedHistogram'", Matchers.hasKey((Object)"mean;number=one;tier=integration"), new Object[0])).body("'taggedHistogram'", Matchers.hasKey((Object)"min;number=one;tier=integration"), new Object[0])).body("'taggedHistogram'", Matchers.hasKey((Object)"p50;number=one;tier=integration"), new Object[0])).body("'taggedHistogram'", Matchers.hasKey((Object)"p75;number=one;tier=integration"), new Object[0])).body("'taggedHistogram'", Matchers.hasKey((Object)"p95;number=one;tier=integration"), new Object[0])).body("'taggedHistogram'", Matchers.hasKey((Object)"p98;number=one;tier=integration"), new Object[0])).body("'taggedHistogram'", Matchers.hasKey((Object)"p99;number=one;tier=integration"), new Object[0])).body("'taggedHistogram'", Matchers.hasKey((Object)"p999;number=one;tier=integration"), new Object[0])).body("'taggedHistogram'", Matchers.hasKey((Object)"stddev;number=one;tier=integration"), new Object[0])).body("'taggedHistogram'.'count;number=two;tier=integration'", CoreMatchers.equalTo((Object)0), new Object[0])).body("'taggedHistogram'", Matchers.hasKey((Object)"max;number=two;tier=integration"), new Object[0])).body("'taggedHistogram'", Matchers.hasKey((Object)"mean;number=two;tier=integration"), new Object[0])).body("'taggedHistogram'", Matchers.hasKey((Object)"min;number=two;tier=integration"), new Object[0])).body("'taggedHistogram'", Matchers.hasKey((Object)"p50;number=two;tier=integration"), new Object[0])).body("'taggedHistogram'", Matchers.hasKey((Object)"p75;number=two;tier=integration"), new Object[0])).body("'taggedHistogram'", Matchers.hasKey((Object)"p95;number=two;tier=integration"), new Object[0])).body("'taggedHistogram'", Matchers.hasKey((Object)"p98;number=two;tier=integration"), new Object[0])).body("'taggedHistogram'", Matchers.hasKey((Object)"p99;number=two;tier=integration"), new Object[0])).body("'taggedHistogram'", Matchers.hasKey((Object)"p999;number=two;tier=integration"), new Object[0])).body("'taggedHistogram'", Matchers.hasKey((Object)"stddev;number=two;tier=integration"), new Object[0])).body("'taggedTimer'.'count;tier=integration'", CoreMatchers.equalTo((Object)0), new Object[0])).body("'taggedTimer'", Matchers.hasKey((Object)"fifteenMinRate;tier=integration"), new Object[0])).body("'taggedTimer'", Matchers.hasKey((Object)"fiveMinRate;tier=integration"), new Object[0])).body("'taggedTimer'", Matchers.hasKey((Object)"meanRate;tier=integration"), new Object[0])).body("'taggedTimer'", Matchers.hasKey((Object)"oneMinRate;tier=integration"), new Object[0])).body("'taggedTimer'", Matchers.hasKey((Object)"max;tier=integration"), new Object[0])).body("'taggedTimer'", Matchers.hasKey((Object)"mean;tier=integration"), new Object[0])).body("'taggedTimer'", Matchers.hasKey((Object)"min;tier=integration"), new Object[0])).body("'taggedTimer'", Matchers.hasKey((Object)"p50;tier=integration"), new Object[0])).body("'taggedTimer'", Matchers.hasKey((Object)"p75;tier=integration"), new Object[0])).body("'taggedTimer'", Matchers.hasKey((Object)"p95;tier=integration"), new Object[0])).body("'taggedTimer'", Matchers.hasKey((Object)"p98;tier=integration"), new Object[0])).body("'taggedTimer'", Matchers.hasKey((Object)"p99;tier=integration"), new Object[0])).body("'taggedTimer'", Matchers.hasKey((Object)"p999;tier=integration"), new Object[0])).body("'taggedTimer'", Matchers.hasKey((Object)"stddev;tier=integration"), new Object[0])).body("'taggedTimer'.'count;number=one;tier=integration'", CoreMatchers.equalTo((Object)0), new Object[0])).body("'taggedTimer'", Matchers.hasKey((Object)"fifteenMinRate;number=one;tier=integration"), new Object[0])).body("'taggedTimer'", Matchers.hasKey((Object)"fiveMinRate;number=one;tier=integration"), new Object[0])).body("'taggedTimer'", Matchers.hasKey((Object)"meanRate;number=one;tier=integration"), new Object[0])).body("'taggedTimer'", Matchers.hasKey((Object)"oneMinRate;number=one;tier=integration"), new Object[0])).body("'taggedTimer'", Matchers.hasKey((Object)"max;number=one;tier=integration"), new Object[0])).body("'taggedTimer'", Matchers.hasKey((Object)"mean;number=one;tier=integration"), new Object[0])).body("'taggedTimer'", Matchers.hasKey((Object)"min;number=one;tier=integration"), new Object[0])).body("'taggedTimer'", Matchers.hasKey((Object)"p50;number=one;tier=integration"), new Object[0])).body("'taggedTimer'", Matchers.hasKey((Object)"p75;number=one;tier=integration"), new Object[0])).body("'taggedTimer'", Matchers.hasKey((Object)"p95;number=one;tier=integration"), new Object[0])).body("'taggedTimer'", Matchers.hasKey((Object)"p98;number=one;tier=integration"), new Object[0])).body("'taggedTimer'", Matchers.hasKey((Object)"p99;number=one;tier=integration"), new Object[0])).body("'taggedTimer'", Matchers.hasKey((Object)"p999;number=one;tier=integration"), new Object[0])).body("'taggedTimer'", Matchers.hasKey((Object)"stddev;number=one;tier=integration"), new Object[0])).body("'taggedTimer'.'count;number=two;tier=integration'", CoreMatchers.equalTo((Object)0), new Object[0])).body("'taggedTimer'", Matchers.hasKey((Object)"fifteenMinRate;number=two;tier=integration"), new Object[0])).body("'taggedTimer'", Matchers.hasKey((Object)"fiveMinRate;number=two;tier=integration"), new Object[0])).body("'taggedTimer'", Matchers.hasKey((Object)"meanRate;number=two;tier=integration"), new Object[0])).body("'taggedTimer'", Matchers.hasKey((Object)"oneMinRate;number=two;tier=integration"), new Object[0])).body("'taggedTimer'", Matchers.hasKey((Object)"max;number=two;tier=integration"), new Object[0])).body("'taggedTimer'", Matchers.hasKey((Object)"mean;number=two;tier=integration"), new Object[0])).body("'taggedTimer'", Matchers.hasKey((Object)"min;number=two;tier=integration"), new Object[0])).body("'taggedTimer'", Matchers.hasKey((Object)"p50;number=two;tier=integration"), new Object[0])).body("'taggedTimer'", Matchers.hasKey((Object)"p75;number=two;tier=integration"), new Object[0])).body("'taggedTimer'", Matchers.hasKey((Object)"p95;number=two;tier=integration"), new Object[0])).body("'taggedTimer'", Matchers.hasKey((Object)"p98;number=two;tier=integration"), new Object[0])).body("'taggedTimer'", Matchers.hasKey((Object)"p99;number=two;tier=integration"), new Object[0])).body("'taggedTimer'", Matchers.hasKey((Object)"p999;number=two;tier=integration"), new Object[0])).body("'taggedTimer'", Matchers.hasKey((Object)"stddev;number=two;tier=integration"), new Object[0])).body("'taggedMeter'.'count;tier=integration'", CoreMatchers.equalTo((Object)0), new Object[0])).body("'taggedMeter'", Matchers.hasKey((Object)"fifteenMinRate;tier=integration"), new Object[0])).body("'taggedMeter'", Matchers.hasKey((Object)"fiveMinRate;tier=integration"), new Object[0])).body("'taggedMeter'", Matchers.hasKey((Object)"meanRate;tier=integration"), new Object[0])).body("'taggedMeter'", Matchers.hasKey((Object)"oneMinRate;tier=integration"), new Object[0])).body("'taggedMeter'.'count;number=one;tier=integration'", CoreMatchers.equalTo((Object)0), new Object[0])).body("'taggedMeter'", Matchers.hasKey((Object)"fifteenMinRate;number=one;tier=integration"), new Object[0])).body("'taggedMeter'", Matchers.hasKey((Object)"fiveMinRate;number=one;tier=integration"), new Object[0])).body("'taggedMeter'", Matchers.hasKey((Object)"meanRate;number=one;tier=integration"), new Object[0])).body("'taggedMeter'", Matchers.hasKey((Object)"oneMinRate;number=one;tier=integration"), new Object[0])).body("'taggedMeter'.'count;number=two;tier=integration'", CoreMatchers.equalTo((Object)0), new Object[0])).body("'taggedMeter'", Matchers.hasKey((Object)"fifteenMinRate;number=two;tier=integration"), new Object[0])).body("'taggedMeter'", Matchers.hasKey((Object)"fiveMinRate;number=two;tier=integration"), new Object[0])).body("'taggedMeter'", Matchers.hasKey((Object)"meanRate;number=two;tier=integration"), new Object[0])).body("'taggedMeter'", Matchers.hasKey((Object)"oneMinRate;number=two;tier=integration"), new Object[0]);
    }

    @Test
    @RunAsClient
    @InSequence(value=46)
    public void testTranslateSemiColonToUnderScoreJSON() {
        Header wantJson = new Header("Accept", APPLICATION_JSON);
        Response resp = (Response)RestAssured.given().header(wantJson).get("/metrics/application", new Object[0]);
        JsonPath filteredJSONPath = new JsonPath(MpMetricTest.filterOutAppLabelJSON(resp.jsonPath().prettify()));
        ResponseBuilder responseBuilder = new ResponseBuilder();
        responseBuilder.clone(resp);
        responseBuilder.setBody(filteredJSONPath.prettify());
        resp = responseBuilder.build();
        ((ValidatableResponse)((ValidatableResponse)resp.then()).statusCode(200)).body("'org.eclipse.microprofile.metrics.test.MetricAppBean.semiColonTaggedCounter;scTag=semi_colons_are_bad;tier=integration'", CoreMatchers.equalTo((Object)0), new Object[0]);
    }

    @Test
    @RunAsClient
    @InSequence(value=47)
    public void testApplicationConcurrentGaugeOpenMetrics() {
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().header("Accept", (Object)TEXT_PLAIN, new Object[0]).when().get("/metrics/application/concGaugeMeA", new Object[0])).then()).statusCode(200)).and()).body(CoreMatchers.containsString((String)"concGaugeMeA_current"), new Matcher[0])).body(CoreMatchers.containsString((String)"concGaugeMeA_min"), new Matcher[0])).body(CoreMatchers.containsString((String)"concGaugeMeA_max"), new Matcher[0]);
    }

    private Matcher<Float> closeTo(double operand) {
        double delta = Math.abs(operand) * 0.025;
        return Matchers.allOf((Matcher)Matchers.greaterThan((Comparable)Float.valueOf((float)(operand - delta))), (Matcher)Matchers.lessThan((Comparable)Float.valueOf((float)(operand + delta))));
    }

    private Map<String, MiniMeta> getExpectedMetadataFromXmlFile(MetricRegistry.Type scope) {
        Document document;
        String fileName;
        ClassLoader cl = this.getClass().getClassLoader();
        switch (scope) {
            case BASE: {
                fileName = "base_metrics.xml";
                break;
            }
            case APPLICATION: {
                fileName = "application_metrics.xml";
                break;
            }
            default: {
                throw new IllegalArgumentException("No definitions for " + scope.getName() + " supported");
            }
        }
        InputStream is = cl.getResourceAsStream(fileName);
        DocumentBuilderFactory fac = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder builder = fac.newDocumentBuilder();
            document = builder.parse(is);
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw new RuntimeException(e);
        }
        Element root = (Element)document.getElementsByTagName("config").item(0);
        NodeList metrics = root.getElementsByTagName("metric");
        HashMap<String, MiniMeta> metaMap = new HashMap<String, MiniMeta>(metrics.getLength());
        for (int i = 0; i < metrics.getLength(); ++i) {
            Element metric = (Element)metrics.item(i);
            MiniMeta mm = new MiniMeta();
            mm.multi = Boolean.parseBoolean(metric.getAttribute("multi"));
            mm.name = metric.getAttribute("name");
            mm.type = metric.getAttribute("type");
            mm.unit = metric.getAttribute("unit");
            mm.description = metric.getAttribute("description");
            mm.displayName = metric.getAttribute("display-name");
            mm.optional = Boolean.parseBoolean(metric.getAttribute("optional"));
            String tags = metric.getAttribute("tags");
            if (tags != null && tags.length() != 0) {
                for (String tag : tags.split(",")) {
                    String[] str = tag.split("=");
                    mm.tags.put(str[0], str[1]);
                }
            }
            metaMap.put(mm.name, mm);
        }
        return metaMap;
    }

    private static class MiniMeta {
        private String name;
        private String type;
        private String unit;
        private String description;
        private String displayName;
        private boolean multi;
        private boolean optional;
        private Map<String, String> tags = new TreeMap<String, String>();

        public MiniMeta() {
            this.tags.put("tier", "integration");
        }

        String toPromString() {
            String out = this.name.replace('-', '_').replace('.', '_').replace(' ', '_');
            if (!this.unit.equals("none")) {
                out = out + "_" + this.getBaseUnitAsOpenMetricsString(this.unit);
            }
            out = out.replace("__", "_");
            out = out.replace(":_", ":");
            return out;
        }

        String toJSONName() {
            return this.name + ";" + this.tags.entrySet().stream().map(e -> (String)e.getKey() + "=" + (String)e.getValue()).collect(Collectors.joining(";"));
        }

        private String getBaseUnitAsOpenMetricsString(String unit) {
            String out;
            switch (unit) {
                case "milliseconds": {
                    out = "seconds";
                    break;
                }
                case "bytes": {
                    out = "bytes";
                    break;
                }
                case "percent": {
                    out = "percent";
                    break;
                }
                default: {
                    out = "none";
                }
            }
            return out;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("MiniMeta{");
            sb.append("name='").append(this.name).append('\'');
            sb.append(", type='").append(this.type).append('\'');
            sb.append(", unit='").append(this.unit).append('\'');
            sb.append(", multi=").append(this.multi);
            sb.append(", optional=").append(this.optional);
            sb.append(", description=").append(this.description);
            sb.append(", display-name=").append(this.displayName);
            sb.append('}');
            return sb.toString();
        }
    }
}

