/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.metrics.test;

import com.jayway.restassured.RestAssured;
import com.jayway.restassured.path.json.JsonPath;
import com.jayway.restassured.response.Header;
import com.jayway.restassured.response.Response;
import java.net.MalformedURLException;
import java.net.URL;
import javax.inject.Inject;
import org.eclipse.microprofile.metrics.test.MetricAppBean2;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.container.test.api.RunAsClient;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.junit.InSequence;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
public class ReusableMetricsTest {
    private static final String APPLICATION_JSON = "application/json";
    private static final String DEFAULT_PROTOCOL = "http";
    private static final String DEFAULT_HOST = "localhost";
    private static final int DEFAULT_PORT = 8080;
    @Inject
    private MetricAppBean2 metricAppBean;

    @BeforeClass
    public static void setup() throws MalformedURLException {
        String serverUrl = System.getProperty("test.url");
        String protocol = DEFAULT_PROTOCOL;
        String host = DEFAULT_HOST;
        int port = 8080;
        if (serverUrl != null) {
            URL url = new URL(serverUrl);
            protocol = url.getProtocol();
            host = url.getHost();
            port = url.getPort() == -1 ? 8080 : url.getPort();
        }
        RestAssured.baseURI = protocol + "://" + host;
        RestAssured.port = port;
        String userName = System.getProperty("test.user");
        String password = System.getProperty("test.pwd");
        if (userName != null && password != null) {
            RestAssured.authentication = RestAssured.basic((String)userName, (String)password);
            RestAssured.useRelaxedHTTPSValidation();
        }
    }

    @Deployment
    public static JavaArchive createDeployment() {
        JavaArchive jar = (JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class)).addClass(MetricAppBean2.class)).addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
        return jar;
    }

    @Test
    @InSequence(value=1)
    public void setA() {
        this.metricAppBean.countMeA();
        this.metricAppBean.meterMeA();
        this.metricAppBean.timeMeA();
    }

    @Test
    @RunAsClient
    @InSequence(value=2)
    public void testSharedCounter() {
        Header acceptJson = new Header("Accept", APPLICATION_JSON);
        JsonPath path = ((Response)RestAssured.given().header(acceptJson).get("/metrics/application", new Object[0])).jsonPath();
        assert (path.getInt("countMe2") == 1);
        assert (path.getInt("'org.eclipse.microprofile.metrics.test.MetricAppBean2.meterMe2'.count") == 1);
        assert (path.getInt("timeMe2.count") == 1);
    }

    @Test
    @InSequence(value=3)
    public void setB() {
        this.metricAppBean.countMeB();
        this.metricAppBean.meterMeB();
        this.metricAppBean.timeMeB();
    }

    @Test
    @RunAsClient
    @InSequence(value=4)
    public void testSharedCounterAgain() {
        Header acceptJson = new Header("Accept", APPLICATION_JSON);
        JsonPath path = ((Response)RestAssured.given().header(acceptJson).get("/metrics/application", new Object[0])).jsonPath();
        assert (path.getInt("countMe2") == 2);
        assert (path.getInt("'org.eclipse.microprofile.metrics.test.MetricAppBean2.meterMe2'.count") == 2);
        assert (path.getInt("timeMe2.count") == 2);
    }

    @Test
    @InSequence(value=5)
    public void setReusableHistogram() {
        this.metricAppBean.registerReusableHistogram();
    }

    @Test
    @RunAsClient
    @InSequence(value=6)
    public void testReusedHistogram() {
        Header acceptJson = new Header("Accept", APPLICATION_JSON);
        JsonPath path = ((Response)RestAssured.given().header(acceptJson).get("/metrics/application", new Object[0])).jsonPath();
        assert (path.getInt("reusableHisto.count") == 2);
        assert (path.getInt("reusableHisto.min") == 1);
        assert (path.getInt("reusableHisto.max") == 3);
    }

    @Test
    @InSequence(value=7)
    public void testBadReusable() {
        try {
            this.metricAppBean.badRegisterReusableHistogram();
        }
        catch (IllegalArgumentException e) {
            return;
        }
        assert (false);
    }

    @Test
    @InSequence(value=8)
    public void testBadReusable2() {
        try {
            this.metricAppBean.badRegisterReusableHistogram2();
        }
        catch (IllegalArgumentException e) {
            return;
        }
        assert (false);
    }

    @Test
    @InSequence(value=9)
    public void testBadReusableMixed() {
        try {
            this.metricAppBean.badRegisterReusableMixed();
        }
        catch (IllegalArgumentException e) {
            return;
        }
        assert (false);
    }
}

