/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.metrics.test;

import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.eclipse.microprofile.metrics.Counter;
import org.eclipse.microprofile.metrics.Gauge;
import org.eclipse.microprofile.metrics.Histogram;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.Meter;
import org.eclipse.microprofile.metrics.Metric;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.MetricType;
import org.eclipse.microprofile.metrics.Timer;
import org.eclipse.microprofile.metrics.annotation.Counted;
import org.eclipse.microprofile.metrics.annotation.Metered;
import org.eclipse.microprofile.metrics.annotation.Timed;

@ApplicationScoped
public class MetricAppBean {
    @Inject
    @org.eclipse.microprofile.metrics.annotation.Metric
    private Counter redCount;
    @Inject
    @org.eclipse.microprofile.metrics.annotation.Metric(name="blue")
    private Counter blueCount;
    @Inject
    @org.eclipse.microprofile.metrics.annotation.Metric(absolute=true)
    private Counter greenCount;
    @Inject
    @org.eclipse.microprofile.metrics.annotation.Metric(name="purple", absolute=true, tags={"app=myShop"})
    private Counter purpleCount;
    @Inject
    @org.eclipse.microprofile.metrics.annotation.Metric(absolute=true, unit="jellybeans")
    private Histogram jellybeanHistogram;
    @Inject
    private MetricRegistry metrics;
    @Inject
    @ConfigProperty(name="MP_METRICS_TAGS")
    private String globalTags;

    public void countMe() {
        Counter counter = this.metrics.counter("metricTest.test1.count");
        counter.inc();
    }

    @Counted(name="metricTest.test1.countMeA", monotonic=true, absolute=true)
    public void countMeA() {
    }

    public void gaugeMe() {
        Gauge gauge = (Gauge)this.metrics.getGauges().get("metricTest.test1.gauge");
        if (gauge == null) {
            gauge = () -> 19L;
            Metadata gaugeMetadata = new Metadata("metricTest.test1.gauge", MetricType.GAUGE, "gigabytes");
            this.metrics.register("metricTest.test1.gauge", (Metric)gauge, gaugeMetadata);
        }
    }

    @org.eclipse.microprofile.metrics.annotation.Gauge(unit="kibibits")
    public long gaugeMeA() {
        return 1000L;
    }

    public void histogramMe() {
        Metadata metadata = new Metadata("metricTest.test1.histogram", MetricType.HISTOGRAM, "bytes");
        Histogram histogram = this.metrics.histogram(metadata);
        for (int i = 0; i < 1000; ++i) {
            histogram.update(i);
        }
        Metadata metadata2 = new Metadata("metricTest.test1.histogram2", MetricType.HISTOGRAM, "none");
        Histogram histogram2 = this.metrics.histogram(metadata2);
        histogram2.update(1);
    }

    public void meterMe() {
        Meter meter = this.metrics.meter("metricTest.test1.meter");
        meter.mark();
    }

    @Metered(absolute=true)
    public void meterMeA() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void timeMe() {
        Timer timer = this.metrics.timer("metricTest.test1.timer");
        Timer.Context context = timer.time();
        try {
            Thread.sleep((long)(Math.random() * 1000.0));
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            context.stop();
        }
    }

    @Timed
    public void timeMeA() {
    }

    public String getGlobalTags() {
        return this.globalTags;
    }
}

