/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.metrics.test;

import io.restassured.RestAssured;
import io.restassured.http.Header;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.net.MalformedURLException;
import java.net.URL;
import javax.inject.Inject;
import org.eclipse.microprofile.metrics.test.MetricAppBean2;
import org.hamcrest.Matchers;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.container.test.api.RunAsClient;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.junit.InSequence;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
public class ReusableMetricsTest {
    private static final String APPLICATION_JSON = "application/json";
    private static final String DEFAULT_PROTOCOL = "http";
    private static final String DEFAULT_HOST = "localhost";
    private static final int DEFAULT_PORT = 8080;
    @Inject
    private MetricAppBean2 metricAppBean;

    @BeforeClass
    public static void setup() throws MalformedURLException {
        String serverUrl = System.getProperty("test.url");
        String protocol = DEFAULT_PROTOCOL;
        String host = DEFAULT_HOST;
        int port = 8080;
        if (serverUrl != null) {
            URL url = new URL(serverUrl);
            protocol = url.getProtocol();
            host = url.getHost();
            port = url.getPort() == -1 ? 8080 : url.getPort();
        }
        RestAssured.baseURI = protocol + "://" + host;
        RestAssured.port = port;
        String userName = System.getProperty("test.user");
        String password = System.getProperty("test.pwd");
        if (userName != null && password != null) {
            RestAssured.authentication = RestAssured.basic((String)userName, (String)password);
            RestAssured.useRelaxedHTTPSValidation();
        }
    }

    @Deployment
    public static JavaArchive createDeployment() {
        JavaArchive jar = (JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class)).addClass(MetricAppBean2.class)).addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
        return jar;
    }

    @Test
    @InSequence(value=1)
    public void setA() {
        this.metricAppBean.countMeA();
        this.metricAppBean.meterMeA();
        this.metricAppBean.timeMeA();
    }

    @Test
    @RunAsClient
    @InSequence(value=2)
    public void testSharedCounter() {
        Header acceptJson = new Header("Accept", APPLICATION_JSON);
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().header(acceptJson).get("/metrics/application", new Object[0])).then()).assertThat()).body("countMe2", Matchers.equalTo((Object)1), new Object[0])).assertThat()).body("'org.eclipse.microprofile.metrics.test.MetricAppBean2.meterMe2'.count", Matchers.equalTo((Object)1), new Object[0])).assertThat()).body("timeMe2.count", Matchers.equalTo((Object)1), new Object[0]);
    }

    @Test
    @InSequence(value=3)
    public void setB() {
        this.metricAppBean.countMeB();
        this.metricAppBean.meterMeB();
        this.metricAppBean.timeMeB();
    }

    @Test
    @RunAsClient
    @InSequence(value=4)
    public void testSharedCounterAgain() {
        Header acceptJson = new Header("Accept", APPLICATION_JSON);
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().header(acceptJson).get("/metrics/application", new Object[0])).then()).assertThat()).body("countMe2", Matchers.equalTo((Object)2), new Object[0])).assertThat()).body("'org.eclipse.microprofile.metrics.test.MetricAppBean2.meterMe2'.count", Matchers.equalTo((Object)2), new Object[0])).assertThat()).body("timeMe2.count", Matchers.equalTo((Object)2), new Object[0]);
    }

    @Test
    @InSequence(value=5)
    public void setReusableHistogram() {
        this.metricAppBean.registerReusableHistogram();
    }

    @Test
    @RunAsClient
    @InSequence(value=6)
    public void testReusedHistogram() {
        Header acceptJson = new Header("Accept", APPLICATION_JSON);
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().header(acceptJson).get("/metrics/application", new Object[0])).then()).assertThat()).body("reusableHisto.count", Matchers.equalTo((Object)2), new Object[0])).assertThat()).body("reusableHisto.min", Matchers.equalTo((Object)1), new Object[0])).assertThat()).body("reusableHisto.max", Matchers.equalTo((Object)3), new Object[0]);
    }

    @Test(expected=IllegalArgumentException.class)
    @InSequence(value=7)
    public void testBadReusableMixed() {
        this.metricAppBean.badRegisterReusableMixed();
    }
}

