/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.metrics.test;

import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.eclipse.microprofile.metrics.Counter;
import org.eclipse.microprofile.metrics.Gauge;
import org.eclipse.microprofile.metrics.Histogram;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.Meter;
import org.eclipse.microprofile.metrics.Metric;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.MetricType;
import org.eclipse.microprofile.metrics.Timer;
import org.eclipse.microprofile.metrics.annotation.Counted;
import org.eclipse.microprofile.metrics.annotation.Metered;
import org.eclipse.microprofile.metrics.annotation.Timed;

@ApplicationScoped
public class MetricAppBean {
    @Inject
    @org.eclipse.microprofile.metrics.annotation.Metric(description="red-description", displayName="red-display-name")
    private Counter redCount;
    @Inject
    @org.eclipse.microprofile.metrics.annotation.Metric(name="blue")
    private Counter blueCount;
    @Inject
    @org.eclipse.microprofile.metrics.annotation.Metric(absolute=true)
    private Counter greenCount;
    @Inject
    @org.eclipse.microprofile.metrics.annotation.Metric(name="purple", absolute=true, tags={"app=myShop"})
    private Counter purpleCount;
    @Inject
    @org.eclipse.microprofile.metrics.annotation.Metric(absolute=true, unit="jellybeans", description="jellybeans-description", displayName="jellybeans-displayName")
    private Histogram jellybeanHistogram;
    @Inject
    private MetricRegistry metrics;
    @Inject
    @ConfigProperty(name="MP_METRICS_TAGS")
    private String globalTags;

    @Produces
    @org.eclipse.microprofile.metrics.annotation.Metric(name="coffee_price_produces", unit="USD", absolute=true, description="getCoffeePriceDescription", displayName="getCoffeePriceDisplayName")
    protected Gauge<Long> getCoffeePrice() {
        return () -> 4L;
    }

    public void countMe() {
        Counter counter = this.metrics.counter("metricTest.test1.count");
        counter.inc();
    }

    @Counted(name="metricTest.test1.countMeA", monotonic=true, absolute=true, description="count-me-a-description", displayName="count-me-a-display-name")
    public void countMeA() {
    }

    @Counted(name="metricTest.test1.countMeB", monotonic=true, absolute=true, unit="jellybean")
    public long countMeB() {
        return 666666L;
    }

    public void gaugeMe() {
        Gauge gauge = (Gauge)this.metrics.getGauges().get("metricTest.test1.gauge");
        if (gauge == null) {
            gauge = () -> 19L;
            Metadata gaugeMetadata = new Metadata("metricTest.test1.gauge", MetricType.GAUGE, "gigabytes");
            this.metrics.register("metricTest.test1.gauge", (Metric)gauge, gaugeMetadata);
        }
    }

    @org.eclipse.microprofile.metrics.annotation.Gauge(unit="kibibits", description="gauge-me-a-description", displayName="gauge-me-a-displayname")
    public long gaugeMeA() {
        return 1000L;
    }

    @org.eclipse.microprofile.metrics.annotation.Gauge(unit="hands")
    public long gaugeMeB() {
        return 7777777L;
    }

    public void histogramMe() {
        Metadata metadata = new Metadata("metricTest.test1.histogram", MetricType.HISTOGRAM, "bytes");
        Histogram histogram = this.metrics.histogram(metadata);
        for (int i = 0; i < 500; ++i) {
            histogram.update(i);
            histogram.update(999 - i);
        }
        Metadata metadata2 = new Metadata("metricTest.test1.histogram2", MetricType.HISTOGRAM, "none");
        Histogram histogram2 = this.metrics.histogram(metadata2);
        histogram2.update(1);
    }

    public void meterMe() {
        Meter meter = this.metrics.meter("metricTest.test1.meter");
        meter.mark();
    }

    @Metered(absolute=true, description="meter-me-a-description", displayName="meter-me-a-display-name")
    public void meterMeA() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void timeMe() {
        Timer timer = this.metrics.timer("metricTest.test1.timer");
        Timer.Context context = timer.time();
        try {
            Thread.sleep((long)(Math.random() * 1000.0));
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            context.stop();
        }
    }

    @Timed
    public void timeMeA() {
    }

    public String getGlobalTags() {
        return this.globalTags;
    }
}

