/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.metrics.test;

import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.eclipse.microprofile.metrics.Counter;
import org.eclipse.microprofile.metrics.Gauge;
import org.eclipse.microprofile.metrics.Histogram;
import org.eclipse.microprofile.metrics.Meter;
import org.eclipse.microprofile.metrics.Metric;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.Timer;
import org.eclipse.microprofile.metrics.annotation.Counted;
import org.eclipse.microprofile.metrics.annotation.Metered;
import org.eclipse.microprofile.metrics.annotation.Timed;

@ApplicationScoped
public class MetricAppBean {
    @Inject
    @org.eclipse.microprofile.metrics.annotation.Metric
    private Counter redCount;
    @Inject
    @org.eclipse.microprofile.metrics.annotation.Metric(name="blue")
    private Counter blueCount;
    @Inject
    @org.eclipse.microprofile.metrics.annotation.Metric(absolute=true)
    private Counter greenCount;
    @Inject
    @org.eclipse.microprofile.metrics.annotation.Metric(name="purple", absolute=true)
    private Counter purpleCount;
    @Inject
    private MetricRegistry metrics;

    public void countMe() {
        Counter counter = this.metrics.counter("metricTest.test1.count");
        counter.inc();
    }

    @Counted(name="metricTest.test1.countMeA", monotonic=true, absolute=true)
    public void countMeA() {
    }

    public void gaugeMe() {
        Gauge gauge = (Gauge)this.metrics.getGauges().get("metricTest.test1.gauge");
        if (gauge == null) {
            gauge = () -> 19L;
            this.metrics.register("metricTest.test1.gauge", (Metric)gauge);
        }
    }

    @org.eclipse.microprofile.metrics.annotation.Gauge(unit="kibibits")
    public long gaugeMeA() {
        return 1000L;
    }

    public void histogramMe() {
        Histogram histogram = this.metrics.histogram("metricTest.test1.histogram");
        for (int i = 0; i < 1000; ++i) {
            histogram.update(i);
        }
    }

    public void meterMe() {
        Meter meter = this.metrics.meter("metricTest.test1.meter");
        meter.mark();
    }

    @Metered(absolute=true)
    public void meterMeA() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void timeMe() {
        Timer timer = this.metrics.timer("metricTest.test1.timer");
        Timer.Context context = timer.time();
        try {
            Thread.sleep((long)(Math.random() * 1000.0));
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            context.stop();
        }
    }

    @Timed
    public void timeMeA() {
    }
}

