/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.metrics.test;

import com.jayway.restassured.RestAssured;
import com.jayway.restassured.path.json.JsonPath;
import com.jayway.restassured.response.Header;
import com.jayway.restassured.response.Response;
import com.jayway.restassured.response.ValidatableResponse;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.test.MetricAppBean;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.container.test.api.RunAsClient;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.junit.InSequence;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

@RunWith(value=Arquillian.class)
public class MpMetricTest {
    private static final String APPLICATION_JSON = "application/json";
    private static final String TEXT_PLAIN = "text/plain";
    private static final String DEFAULT_PROTOCOL = "http";
    private static final String DEFAULT_HOST = "localhost";
    private static final int DEFAULT_PORT = 8080;
    @Inject
    private MetricAppBean metricAppBean;

    @BeforeClass
    public static void setup() throws MalformedURLException {
        String serverUrl = System.getProperty("test.url");
        String protocol = DEFAULT_PROTOCOL;
        String host = DEFAULT_HOST;
        int port = 8080;
        if (serverUrl != null) {
            URL url = new URL(serverUrl);
            protocol = url.getProtocol();
            host = url.getHost();
            port = url.getPort() == -1 ? 8080 : url.getPort();
        }
        RestAssured.baseURI = protocol + "://" + host;
        RestAssured.port = port;
        String userName = System.getProperty("test.user");
        String password = System.getProperty("test.pwd");
        if (userName != null && password != null) {
            RestAssured.authentication = RestAssured.basic((String)userName, (String)password);
            RestAssured.useRelaxedHTTPSValidation();
        }
    }

    @Deployment
    public static JavaArchive createDeployment() {
        JavaArchive jar = (JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class)).addClass(MetricAppBean.class)).addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
        System.out.println(jar.toString(true));
        return jar;
    }

    @Test
    @RunAsClient
    @InSequence(value=1)
    public void testApplicationJsonResponseContentType() {
        Header acceptHeader = new Header("Accept", APPLICATION_JSON);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().header(acceptHeader).when().get("/metrics", new Object[0])).then().statusCode(200)).and()).contentType(APPLICATION_JSON);
    }

    @Test
    @RunAsClient
    @InSequence(value=2)
    public void testTextPlainResponseContentType() {
        Header acceptHeader = new Header("Accept", TEXT_PLAIN);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().header(acceptHeader).when().get("/metrics", new Object[0])).then().statusCode(200)).and()).contentType(TEXT_PLAIN);
    }

    @Test
    @RunAsClient
    @InSequence(value=3)
    public void testBadSubTreeWillReturn404() {
        ((Response)RestAssured.when().get("/metrics/bad-tree", new Object[0])).then().statusCode(404);
    }

    @Test
    @RunAsClient
    @InSequence(value=4)
    public void testListsAllJson() {
        Header acceptHeader = new Header("Accept", APPLICATION_JSON);
        Map response = (Map)((Response)RestAssured.given().header(acceptHeader).when().get("/metrics", new Object[0])).as(Map.class);
        assert (response.containsKey("base"));
        if (response.containsKey("application")) {
            Map applicationData = (Map)response.get("application");
            assert (applicationData.size() > 0);
        }
        if (response.containsKey("vendor")) {
            Map vendorData = (Map)response.get("vendor");
            assert (vendorData.size() > 0);
        }
    }

    @Test
    @RunAsClient
    @InSequence(value=5)
    public void testBase() {
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().header("Accept", (Object)APPLICATION_JSON, new Object[0]).when().get("/metrics/base", new Object[0])).then().statusCode(200)).and()).contentType(APPLICATION_JSON)).and()).body(CoreMatchers.containsString((String)"thread.max.count"), new Matcher[0]);
    }

    @Test
    @RunAsClient
    @InSequence(value=6)
    public void testBasePrometheus() {
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().header("Accept", (Object)TEXT_PLAIN, new Object[0]).when().get("/metrics/base", new Object[0])).then().statusCode(200)).and()).contentType(TEXT_PLAIN)).and()).body(CoreMatchers.containsString((String)"# TYPE base:thread_max_count"), new Matcher[]{CoreMatchers.containsString((String)"base:thread_max_count{tier=\"integration\"}")});
    }

    @Test
    @RunAsClient
    @InSequence(value=7)
    public void testBaseAttributeJson() {
        Header wantJson = new Header("Accept", APPLICATION_JSON);
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().header(wantJson).when().get("/metrics/base/thread.max.count", new Object[0])).then().statusCode(200)).and()).contentType(APPLICATION_JSON)).and()).body(CoreMatchers.containsString((String)"thread.max.count"), new Matcher[0]);
    }

    @Test
    @RunAsClient
    @InSequence(value=8)
    public void testBaseSingularMetricsPresent() {
        Header wantJson = new Header("Accept", APPLICATION_JSON);
        JsonPath jsonPath = ((Response)RestAssured.given().header(wantJson).get("/metrics/base", new Object[0])).jsonPath();
        Map elements = jsonPath.getMap(".");
        ArrayList<String> missing = new ArrayList<String>();
        Map<String, MiniMeta> baseNames = this.getExpectedMetadataFromXmlFile(MetricRegistry.Type.BASE);
        for (String item : baseNames.keySet()) {
            if (item.startsWith("gc.") || elements.containsKey(item) || baseNames.get(item).optional) continue;
            missing.add(item);
        }
        assert (missing.isEmpty()) : "Following base items are missing: " + Arrays.toString(missing.toArray());
    }

    @Test
    @RunAsClient
    @InSequence(value=9)
    public void testBaseAttributePrometheus() {
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().header("Accept", (Object)TEXT_PLAIN, new Object[0]).when().get("/metrics/base/thread.max.count", new Object[0])).then().statusCode(200)).and()).contentType(TEXT_PLAIN)).and()).body(CoreMatchers.containsString((String)"# TYPE base:thread_max_count"), new Matcher[]{CoreMatchers.containsString((String)"base:thread_max_count{tier=\"integration\"}")});
    }

    @Test
    @RunAsClient
    @InSequence(value=10)
    public void testBaseMetadata() {
        Header wantJson = new Header("Accept", APPLICATION_JSON);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().header(wantJson).options("/metrics/base", new Object[0])).then().statusCode(200)).and()).contentType(APPLICATION_JSON);
    }

    @Test
    @RunAsClient
    @InSequence(value=11)
    public void testBaseMetadataSingluarItems() {
        Header wantJson = new Header("Accept", APPLICATION_JSON);
        JsonPath jsonPath = ((Response)RestAssured.given().header(wantJson).options("/metrics/base", new Object[0])).jsonPath();
        Map elements = jsonPath.getMap(".");
        ArrayList<String> missing = new ArrayList<String>();
        Map<String, MiniMeta> baseNames = this.getExpectedMetadataFromXmlFile(MetricRegistry.Type.BASE);
        for (String item : baseNames.keySet()) {
            if (item.startsWith("gc.") || baseNames.get(item).optional || elements.containsKey(item)) continue;
            missing.add(item);
        }
        assert (missing.isEmpty()) : "Following base items are missing: " + Arrays.toString(missing.toArray());
    }

    @Test
    @RunAsClient
    @InSequence(value=12)
    public void testBaseMetadataTypeAndUnit() {
        Header wantJson = new Header("Accept", APPLICATION_JSON);
        JsonPath jsonPath = ((Response)RestAssured.given().header(wantJson).options("/metrics/base", new Object[0])).jsonPath();
        Map elements = jsonPath.getMap(".");
        Map<String, MiniMeta> expectedMetadata = this.getExpectedMetadataFromXmlFile(MetricRegistry.Type.BASE);
        this.checkMetadataPresent(elements, expectedMetadata);
    }

    private void checkMetadataPresent(Map<String, Map<String, Object>> elements, Map<String, MiniMeta> expectedMetadata) {
        for (Map.Entry<String, MiniMeta> entry : expectedMetadata.entrySet()) {
            MiniMeta item = entry.getValue();
            if (item.name.startsWith("gc.") || expectedMetadata.get(item.name).optional) continue;
            Map<String, Object> fromServer = elements.get(item.name);
            assert (item.type.equals(fromServer.get("type"))) : "expected " + MiniMeta.access$200(item) + " but got " + fromServer.get("type") + " for " + MiniMeta.access$100(item);
            assert (item.unit.equals(fromServer.get("unit"))) : "expected " + MiniMeta.access$300(item) + " but got " + fromServer.get("unit") + " for " + MiniMeta.access$100(item);
        }
    }

    @Test
    @RunAsClient
    @InSequence(value=13)
    public void testPrometheusFormatNoBadChars() throws Exception {
        String[] lines;
        Header wantPrometheusFormat = new Header("Accept", TEXT_PLAIN);
        String data = ((Response)RestAssured.given().header(wantPrometheusFormat).get("/metrics/base", new Object[0])).asString();
        for (String line : lines = data.split("\n")) {
            if (line.startsWith("#")) continue;
            String[] tmp = line.split(" ");
            assert (tmp.length == 2);
            assert (!tmp[0].matches("[-.]")) : "Line has illegal chars " + line;
            assert (!tmp[0].matches("__")) : "Found __ in " + line;
        }
    }

    @Test
    @RunAsClient
    @InSequence(value=14)
    public void testBaseMetadataSingluarItemsPrometheus() {
        Header wantPrometheusFormat = new Header("Accept", TEXT_PLAIN);
        String data = ((Response)RestAssured.given().header(wantPrometheusFormat).get("/metrics/base", new Object[0])).asString();
        String[] lines = data.split("\n");
        Map<String, MiniMeta> expectedMetadata = this.getExpectedMetadataFromXmlFile(MetricRegistry.Type.BASE);
        for (MiniMeta mm : expectedMetadata.values()) {
            boolean found = false;
            if (mm.name.startsWith("gc.") || expectedMetadata.get(mm.name).optional) continue;
            for (String line : lines) {
                if (!line.startsWith("# TYPE base:")) continue;
                String fullLine = line;
                int c = line.indexOf(":");
                line = line.substring(c + 1);
                String promName = mm.toPromString();
                String[] tmp = line.split(" ");
                assert (tmp.length == 2);
                if (!tmp[0].startsWith(promName)) continue;
                found = true;
                assert (tmp[1].equals(mm.type)) : "Expected [" + mm.toString() + "] got [" + fullLine + "]";
            }
            assert (found) : "Not found [" + mm.toString() + "]";
        }
    }

    @Test
    @RunAsClient
    @InSequence(value=15)
    public void testBaseMetadataGarbageCollection() throws Exception {
        Header wantJson = new Header("Accept", APPLICATION_JSON);
        JsonPath jsonPath = ((Response)RestAssured.given().header(wantJson).options("/metrics/base", new Object[0])).jsonPath();
        int count = 0;
        Map elements = jsonPath.getMap(".");
        for (String name : elements.keySet()) {
            if (!name.startsWith("gc.")) continue;
            assert (name.endsWith(".count") || name.endsWith(".time"));
            ++count;
        }
        assert (count > 0);
    }

    @Test
    @RunAsClient
    @InSequence(value=16)
    public void testApplicationMetadataOkJson() {
        Header wantJson = new Header("Accept", APPLICATION_JSON);
        Response response = (Response)RestAssured.given().header(wantJson).options("/metrics/application", new Object[0]);
        int code = response.getStatusCode();
        assert (code == 200 || code == 204);
    }

    @Test
    @InSequence(value=17)
    public void testSetupApplicationMetrics() {
        this.metricAppBean.countMe();
        this.metricAppBean.countMeA();
        this.metricAppBean.gaugeMe();
        this.metricAppBean.gaugeMeA();
        this.metricAppBean.histogramMe();
        this.metricAppBean.meterMe();
        this.metricAppBean.meterMeA();
        this.metricAppBean.timeMe();
        this.metricAppBean.timeMeA();
    }

    @Test
    @RunAsClient
    @InSequence(value=18)
    public void testApplicationMetricsJSON() {
        Header wantJson = new Header("Accept", APPLICATION_JSON);
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().header(wantJson).get("/metrics/application", new Object[0])).then().statusCode(200)).body("'org.eclipse.microprofile.metrics.test.MetricAppBean.redCount'", CoreMatchers.equalTo((Object)0), new Object[0])).body("'org.eclipse.microprofile.metrics.test.MetricAppBean.blue'", CoreMatchers.equalTo((Object)0), new Object[0])).body("greenCount", CoreMatchers.equalTo((Object)0), new Object[0])).body("purple", CoreMatchers.equalTo((Object)0), new Object[0])).body("'metricTest.test1.count'", CoreMatchers.equalTo((Object)1), new Object[0])).body("'metricTest.test1.countMeA'", CoreMatchers.equalTo((Object)1), new Object[0])).body("'metricTest.test1.gauge'", CoreMatchers.equalTo((Object)19), new Object[0])).body("'org.eclipse.microprofile.metrics.test.MetricAppBean.gaugeMeA'", CoreMatchers.equalTo((Object)1000), new Object[0])).body("'metricTest.test1.histogram'.count", CoreMatchers.equalTo((Object)1000), new Object[0])).body("'metricTest.test1.histogram'.max", CoreMatchers.equalTo((Object)999), new Object[0])).body("'metricTest.test1.histogram'.mean", CoreMatchers.equalTo((Object)Float.valueOf(499.5f)), new Object[0])).body("'metricTest.test1.histogram'.min", CoreMatchers.equalTo((Object)0), new Object[0])).body("'metricTest.test1.histogram'.p50", CoreMatchers.equalTo((Object)Float.valueOf(499.0f)), new Object[0])).body("'metricTest.test1.histogram'.p75", CoreMatchers.equalTo((Object)Float.valueOf(749.0f)), new Object[0])).body("'metricTest.test1.histogram'.p95", CoreMatchers.equalTo((Object)Float.valueOf(949.0f)), new Object[0])).body("'metricTest.test1.histogram'.p98", CoreMatchers.equalTo((Object)Float.valueOf(979.0f)), new Object[0])).body("'metricTest.test1.histogram'.p99", CoreMatchers.equalTo((Object)Float.valueOf(989.0f)), new Object[0])).body("'metricTest.test1.histogram'.p999", CoreMatchers.equalTo((Object)Float.valueOf(998.0f)), new Object[0])).body("'metricTest.test1.histogram'", Matchers.hasKey((Object)"stddev"), new Object[0])).body("'metricTest.test1.meter'.count", CoreMatchers.equalTo((Object)1), new Object[0])).body("'metricTest.test1.meter'", Matchers.hasKey((Object)"fifteenMinRate"), new Object[0])).body("'metricTest.test1.meter'", Matchers.hasKey((Object)"fiveMinRate"), new Object[0])).body("'metricTest.test1.meter'", Matchers.hasKey((Object)"meanRate"), new Object[0])).body("'metricTest.test1.meter'", Matchers.hasKey((Object)"oneMinRate"), new Object[0])).body("meterMeA.count", CoreMatchers.equalTo((Object)1), new Object[0])).body("meterMeA", Matchers.hasKey((Object)"fifteenMinRate"), new Object[0])).body("meterMeA", Matchers.hasKey((Object)"fiveMinRate"), new Object[0])).body("meterMeA", Matchers.hasKey((Object)"meanRate"), new Object[0])).body("meterMeA", Matchers.hasKey((Object)"oneMinRate"), new Object[0])).body("'metricTest.test1.timer'.count", CoreMatchers.equalTo((Object)1), new Object[0])).body("'metricTest.test1.timer'", Matchers.hasKey((Object)"fifteenMinRate"), new Object[0])).body("'metricTest.test1.timer'", Matchers.hasKey((Object)"fiveMinRate"), new Object[0])).body("'metricTest.test1.timer'", Matchers.hasKey((Object)"meanRate"), new Object[0])).body("'metricTest.test1.timer'", Matchers.hasKey((Object)"oneMinRate"), new Object[0])).body("'metricTest.test1.timer'", Matchers.hasKey((Object)"max"), new Object[0])).body("'metricTest.test1.timer'", Matchers.hasKey((Object)"mean"), new Object[0])).body("'metricTest.test1.timer'", Matchers.hasKey((Object)"min"), new Object[0])).body("'metricTest.test1.timer'", Matchers.hasKey((Object)"p50"), new Object[0])).body("'metricTest.test1.timer'", Matchers.hasKey((Object)"p75"), new Object[0])).body("'metricTest.test1.timer'", Matchers.hasKey((Object)"p95"), new Object[0])).body("'metricTest.test1.timer'", Matchers.hasKey((Object)"p98"), new Object[0])).body("'metricTest.test1.timer'", Matchers.hasKey((Object)"p99"), new Object[0])).body("'metricTest.test1.timer'", Matchers.hasKey((Object)"p999"), new Object[0])).body("'metricTest.test1.timer'", Matchers.hasKey((Object)"stddev"), new Object[0])).body("'org.eclipse.microprofile.metrics.test.MetricAppBean.timeMeA'.count", CoreMatchers.equalTo((Object)1), new Object[0])).body("'org.eclipse.microprofile.metrics.test.MetricAppBean.timeMeA'", Matchers.hasKey((Object)"fifteenMinRate"), new Object[0])).body("'org.eclipse.microprofile.metrics.test.MetricAppBean.timeMeA'", Matchers.hasKey((Object)"fiveMinRate"), new Object[0])).body("'org.eclipse.microprofile.metrics.test.MetricAppBean.timeMeA'", Matchers.hasKey((Object)"meanRate"), new Object[0])).body("'org.eclipse.microprofile.metrics.test.MetricAppBean.timeMeA'", Matchers.hasKey((Object)"oneMinRate"), new Object[0])).body("'org.eclipse.microprofile.metrics.test.MetricAppBean.timeMeA'", Matchers.hasKey((Object)"max"), new Object[0])).body("'org.eclipse.microprofile.metrics.test.MetricAppBean.timeMeA'", Matchers.hasKey((Object)"mean"), new Object[0])).body("'org.eclipse.microprofile.metrics.test.MetricAppBean.timeMeA'", Matchers.hasKey((Object)"min"), new Object[0])).body("'org.eclipse.microprofile.metrics.test.MetricAppBean.timeMeA'", Matchers.hasKey((Object)"p50"), new Object[0])).body("'org.eclipse.microprofile.metrics.test.MetricAppBean.timeMeA'", Matchers.hasKey((Object)"p75"), new Object[0])).body("'org.eclipse.microprofile.metrics.test.MetricAppBean.timeMeA'", Matchers.hasKey((Object)"p95"), new Object[0])).body("'org.eclipse.microprofile.metrics.test.MetricAppBean.timeMeA'", Matchers.hasKey((Object)"p98"), new Object[0])).body("'org.eclipse.microprofile.metrics.test.MetricAppBean.timeMeA'", Matchers.hasKey((Object)"p99"), new Object[0])).body("'org.eclipse.microprofile.metrics.test.MetricAppBean.timeMeA'", Matchers.hasKey((Object)"p999"), new Object[0])).body("'org.eclipse.microprofile.metrics.test.MetricAppBean.timeMeA'", Matchers.hasKey((Object)"stddev"), new Object[0]);
    }

    @Test
    @RunAsClient
    @InSequence(value=19)
    public void testApplicationMetadataItems() {
        Header wantJson = new Header("Accept", APPLICATION_JSON);
        JsonPath jsonPath = ((Response)RestAssured.given().header(wantJson).options("/metrics/application", new Object[0])).jsonPath();
        Map elements = jsonPath.getMap(".");
        ArrayList<String> missing = new ArrayList<String>();
        Map<String, MiniMeta> names = this.getExpectedMetadataFromXmlFile(MetricRegistry.Type.APPLICATION);
        for (String item : names.keySet()) {
            if (elements.containsKey(item)) continue;
            missing.add(item);
        }
        assert (missing.isEmpty()) : "Following application items are missing: " + Arrays.toString(missing.toArray());
    }

    @Test
    @RunAsClient
    @InSequence(value=20)
    public void testApplicationMetadataTypeAndUnit() {
        Header wantJson = new Header("Accept", APPLICATION_JSON);
        JsonPath jsonPath = ((Response)RestAssured.given().header(wantJson).options("/metrics/application", new Object[0])).jsonPath();
        Map elements = jsonPath.getMap(".");
        Map<String, MiniMeta> expectedMetadata = this.getExpectedMetadataFromXmlFile(MetricRegistry.Type.APPLICATION);
        this.checkMetadataPresent(elements, expectedMetadata);
    }

    @Test
    @RunAsClient
    @InSequence(value=21)
    public void testApplicationTagJson() {
        JsonPath jsonPath = ((Response)RestAssured.given().header("Accept", (Object)APPLICATION_JSON, new Object[0]).when().options("/metrics/application/purple", new Object[0])).jsonPath();
        String tags = jsonPath.getString("purple.tags");
        assert (tags != null);
        assert (tags.contains("app=myShop"));
        assert (tags.contains("tier=integration"));
    }

    @Test
    @RunAsClient
    @InSequence(value=22)
    public void testApplicationTagPrometheus() {
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().header("Accept", (Object)TEXT_PLAIN, new Object[0]).when().get("/metrics/application/purple", new Object[0])).then().statusCode(200)).and()).body(CoreMatchers.containsString((String)"tier=\"integration\""), new Matcher[0])).body(CoreMatchers.containsString((String)"app=\"myShop\""), new Matcher[0]);
    }

    @InSequence(value=23)
    public void testApplicationMeterUnitPrometheus() {
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().header("Accept", (Object)TEXT_PLAIN, new Object[0]).when().get("/metrics/application/meterMeA", new Object[0])).then().statusCode(200)).and()).body(CoreMatchers.containsString((String)"meter_me_a_total"), new Matcher[0])).body(CoreMatchers.containsString((String)"meter_me_a_rate_per_second"), new Matcher[0])).body(CoreMatchers.containsString((String)"meter_me_a_one_min_rate_per_second"), new Matcher[0])).body(CoreMatchers.containsString((String)"meter_me_a_five_min_rate_per_second"), new Matcher[0])).body(CoreMatchers.containsString((String)"meter_me_a_fifteen_min_rate_per_second"), new Matcher[0]);
    }

    @Test
    @RunAsClient
    @InSequence(value=24)
    public void testApplicationTimerUnitPrometheus() {
        String prefix = "org_eclipse_microprofile_metrics_test_metric_app_bean_time_me_a_";
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().header("Accept", (Object)TEXT_PLAIN, new Object[0]).when().get("/metrics/application/org.eclipse.microprofile.metrics.test.MetricAppBean.timeMeA", new Object[0])).then().statusCode(200)).and()).body(CoreMatchers.containsString((String)("# TYPE application:" + prefix + "seconds summary")), new Matcher[0])).body(CoreMatchers.containsString((String)(prefix + "seconds_count")), new Matcher[0])).body(CoreMatchers.containsString((String)(prefix + "rate_per_second")), new Matcher[0])).body(CoreMatchers.containsString((String)(prefix + "one_min_rate_per_second")), new Matcher[0])).body(CoreMatchers.containsString((String)(prefix + "five_min_rate_per_second")), new Matcher[0])).body(CoreMatchers.containsString((String)(prefix + "fifteen_min_rate_per_second")), new Matcher[0])).body(CoreMatchers.containsString((String)(prefix + "mean_seconds")), new Matcher[0])).body(CoreMatchers.containsString((String)(prefix + "min_seconds")), new Matcher[0])).body(CoreMatchers.containsString((String)(prefix + "max_seconds")), new Matcher[0])).body(CoreMatchers.containsString((String)(prefix + "stddev_second")), new Matcher[0])).body(CoreMatchers.containsString((String)(prefix + "seconds{tier=\"integration\",quantile=\"0.5\"}")), new Matcher[0])).body(CoreMatchers.containsString((String)(prefix + "seconds{tier=\"integration\",quantile=\"0.75\"}")), new Matcher[0])).body(CoreMatchers.containsString((String)(prefix + "seconds{tier=\"integration\",quantile=\"0.95\"}")), new Matcher[0])).body(CoreMatchers.containsString((String)(prefix + "seconds{tier=\"integration\",quantile=\"0.98\"}")), new Matcher[0])).body(CoreMatchers.containsString((String)(prefix + "seconds{tier=\"integration\",quantile=\"0.99\"}")), new Matcher[0])).body(CoreMatchers.containsString((String)(prefix + "seconds{tier=\"integration\",quantile=\"0.999\"}")), new Matcher[0]);
    }

    @InSequence(value=25)
    public void testApplicationHistogramUnitBytesPrometheus() {
        String prefix = "metric_test_test1_histogram_";
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().header("Accept", (Object)TEXT_PLAIN, new Object[0]).when().get("/metrics/application/metricTest.test1.histogram", new Object[0])).then().statusCode(200)).and()).body(CoreMatchers.containsString((String)(prefix + "bytes_count")), new Matcher[0])).body(CoreMatchers.containsString((String)("# TYPE application:" + prefix + "bytes summary")), new Matcher[0])).body(CoreMatchers.containsString((String)(prefix + "mean_bytes")), new Matcher[0])).body(CoreMatchers.containsString((String)(prefix + "min_bytes")), new Matcher[0])).body(CoreMatchers.containsString((String)(prefix + "max_bytes")), new Matcher[0])).body(CoreMatchers.containsString((String)(prefix + "stddev_bytes")), new Matcher[0])).body(CoreMatchers.containsString((String)(prefix + "bytes{tier=\"integration\",quantile=\"0.5\"}")), new Matcher[0])).body(CoreMatchers.containsString((String)(prefix + "bytes{tier=\"integration\",quantile=\"0.75\"}")), new Matcher[0])).body(CoreMatchers.containsString((String)(prefix + "bytes{tier=\"integration\",quantile=\"0.95\"}")), new Matcher[0])).body(CoreMatchers.containsString((String)(prefix + "bytes{tier=\"integration\",quantile=\"0.98\"}")), new Matcher[0])).body(CoreMatchers.containsString((String)(prefix + "bytes{tier=\"integration\",quantile=\"0.99\"}")), new Matcher[0])).body(CoreMatchers.containsString((String)(prefix + "bytes{tier=\"integration\",quantile=\"0.999\"}")), new Matcher[0]);
    }

    @Test
    @RunAsClient
    @InSequence(value=26)
    public void testApplicationHistogramUnitNonePrometheus() {
        String prefix = "metric_test_test1_histogram2";
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().header("Accept", (Object)TEXT_PLAIN, new Object[0]).when().get("/metrics/application/metricTest.test1.histogram2", new Object[0])).then().statusCode(200)).and()).body(CoreMatchers.containsString((String)(prefix + "_count")), new Matcher[0])).body(CoreMatchers.containsString((String)("# TYPE application:" + prefix + " summary")), new Matcher[0])).body(CoreMatchers.containsString((String)(prefix + "_mean")), new Matcher[0])).body(CoreMatchers.containsString((String)(prefix + "_min")), new Matcher[0])).body(CoreMatchers.containsString((String)(prefix + "_max")), new Matcher[0])).body(CoreMatchers.containsString((String)(prefix + "_stddev")), new Matcher[0])).body(CoreMatchers.containsString((String)(prefix + "{tier=\"integration\",quantile=\"0.5\"}")), new Matcher[0])).body(CoreMatchers.containsString((String)(prefix + "{tier=\"integration\",quantile=\"0.75\"}")), new Matcher[0])).body(CoreMatchers.containsString((String)(prefix + "{tier=\"integration\",quantile=\"0.95\"}")), new Matcher[0])).body(CoreMatchers.containsString((String)(prefix + "{tier=\"integration\",quantile=\"0.98\"}")), new Matcher[0])).body(CoreMatchers.containsString((String)(prefix + "{tier=\"integration\",quantile=\"0.99\"}")), new Matcher[0])).body(CoreMatchers.containsString((String)(prefix + "{tier=\"integration\",quantile=\"0.999\"}")), new Matcher[0]);
    }

    @Test
    @RunAsClient
    @InSequence(value=27)
    public void testPrometheus406ForOptions() {
        ((Response)RestAssured.given().header("Accept", (Object)TEXT_PLAIN, new Object[0]).when().options("/metrics/application/metricTest.test1.histogram2", new Object[0])).then().statusCode(406);
    }

    @Test
    @RunAsClient
    @InSequence(value=28)
    public void testConvertingToBaseUnit() {
        Header wantPrometheusFormat = new Header("Accept", TEXT_PLAIN);
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().header(wantPrometheusFormat).get("/metrics/application", new Object[0])).then().statusCode(200)).and()).body(CoreMatchers.containsString((String)"TYPE application:org_eclipse_microprofile_metrics_test_metric_app_bean_gauge_me_a_bytes gauge"), new Matcher[0])).and()).body(CoreMatchers.containsString((String)"TYPE application:metric_test_test1_gauge_bytes gauge"), new Matcher[0]);
    }

    @Test
    @RunAsClient
    @InSequence(value=29)
    public void testNonStandardUnitsJSON() {
        Header wantJSONFormat = new Header("Accept", APPLICATION_JSON);
        ((ValidatableResponse)((Response)RestAssured.given().header(wantJSONFormat).options("/metrics/application/jellybeanHistogram", new Object[0])).then().statusCode(200)).body("jellybeanHistogram.unit", CoreMatchers.equalTo((Object)"jellybeans"), new Object[0]);
    }

    @Test
    @RunAsClient
    @InSequence(value=30)
    public void testNonStandardUnitsPrometheus() {
        String prefix = "jellybean_histogram_";
        Header wantPrometheusFormat = new Header("Accept", TEXT_PLAIN);
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().header(wantPrometheusFormat).get("/metrics/application/jellybeanHistogram", new Object[0])).then().statusCode(200)).and()).body(CoreMatchers.containsString((String)(prefix + "jellybeans_count")), new Matcher[0])).body(CoreMatchers.containsString((String)("# TYPE application:" + prefix + "jellybeans summary")), new Matcher[0])).body(CoreMatchers.containsString((String)(prefix + "mean_jellybeans")), new Matcher[0])).body(CoreMatchers.containsString((String)(prefix + "min_jellybeans")), new Matcher[0])).body(CoreMatchers.containsString((String)(prefix + "max_jellybeans")), new Matcher[0])).body(CoreMatchers.containsString((String)(prefix + "stddev_jellybeans")), new Matcher[0])).body(CoreMatchers.containsString((String)(prefix + "jellybeans{tier=\"integration\",quantile=\"0.5\"}")), new Matcher[0])).body(CoreMatchers.containsString((String)(prefix + "jellybeans{tier=\"integration\",quantile=\"0.75\"}")), new Matcher[0])).body(CoreMatchers.containsString((String)(prefix + "jellybeans{tier=\"integration\",quantile=\"0.95\"}")), new Matcher[0])).body(CoreMatchers.containsString((String)(prefix + "jellybeans{tier=\"integration\",quantile=\"0.98\"}")), new Matcher[0])).body(CoreMatchers.containsString((String)(prefix + "jellybeans{tier=\"integration\",quantile=\"0.99\"}")), new Matcher[0])).body(CoreMatchers.containsString((String)(prefix + "jellybeans{tier=\"integration\",quantile=\"0.999\"}")), new Matcher[0]);
    }

    @Test
    @RunAsClient
    @InSequence(value=31)
    public void testOptionalBaseMetrics() {
        Header wantJson = new Header("Accept", APPLICATION_JSON);
        JsonPath jsonPath = ((Response)RestAssured.given().header(wantJson).options("/metrics/base", new Object[0])).jsonPath();
        Map elements = jsonPath.getMap(".");
        Map<String, MiniMeta> names = this.getExpectedMetadataFromXmlFile(MetricRegistry.Type.BASE);
        for (String item : names.keySet()) {
            if (!elements.containsKey(item) || !names.get(item).optional) continue;
            String prefix = names.get(item).name;
            String type = "\"" + prefix + "\".type";
            String unit = "\"" + prefix + "\".unit";
            ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().header(wantJson).options("/metrics/base/" + prefix, new Object[0])).then().statusCode(200)).body(type, CoreMatchers.equalTo((Object)names.get(item).type), new Object[0])).body(unit, CoreMatchers.equalTo((Object)names.get(item).unit), new Object[0]);
        }
    }

    private Map<String, MiniMeta> getExpectedMetadataFromXmlFile(MetricRegistry.Type scope) {
        Document document;
        String fileName;
        ClassLoader cl = this.getClass().getClassLoader();
        switch (scope) {
            case BASE: {
                fileName = "base_metrics.xml";
                break;
            }
            case APPLICATION: {
                fileName = "application_metrics.xml";
                break;
            }
            default: {
                throw new IllegalArgumentException("No definitions for " + scope.getName() + " supported");
            }
        }
        InputStream is = cl.getResourceAsStream(fileName);
        DocumentBuilderFactory fac = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder builder = fac.newDocumentBuilder();
            document = builder.parse(is);
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw new RuntimeException(e);
        }
        Element root = (Element)document.getElementsByTagName("config").item(0);
        NodeList metrics = root.getElementsByTagName("metric");
        HashMap<String, MiniMeta> metaMap = new HashMap<String, MiniMeta>(metrics.getLength());
        for (int i = 0; i < metrics.getLength(); ++i) {
            Element metric = (Element)metrics.item(i);
            MiniMeta mm = new MiniMeta();
            mm.multi = Boolean.parseBoolean(metric.getAttribute("multi"));
            mm.name = metric.getAttribute("name");
            mm.type = metric.getAttribute("type");
            mm.unit = metric.getAttribute("unit");
            mm.optional = Boolean.parseBoolean(metric.getAttribute("optional"));
            metaMap.put(mm.name, mm);
        }
        return metaMap;
    }

    private static class MiniMeta {
        private String name;
        private String type;
        private String unit;
        private boolean multi;
        private boolean optional;

        private MiniMeta() {
        }

        String toPromString() {
            String out = this.name.replace('-', '_').replace('.', '_').replace(' ', '_');
            out = out.replaceAll("(.)(\\p{Upper})", "$1_$2").toLowerCase();
            if (!this.unit.equals("none")) {
                out = out + "_" + this.getBaseUnitAsPrometheusString(this.unit);
            }
            out = out.replace("__", "_");
            out = out.replace(":_", ":");
            return out;
        }

        private String getBaseUnitAsPrometheusString(String unit) {
            String out;
            switch (unit) {
                case "milliseconds": {
                    out = "seconds";
                    break;
                }
                case "bytes": {
                    out = "bytes";
                    break;
                }
                case "percent": {
                    out = "percent";
                    break;
                }
                default: {
                    out = "none";
                }
            }
            return out;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("MiniMeta{");
            sb.append("name='").append(this.name).append('\'');
            sb.append(", type='").append(this.type).append('\'');
            sb.append(", unit='").append(this.unit).append('\'');
            sb.append(", multi=").append(this.multi);
            sb.append(", optional =").append(this.optional);
            sb.append('}');
            return sb.toString();
        }
    }
}

