/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.metrics.test.optional;

import io.restassured.RestAssured;
import io.restassured.builder.ResponseBuilder;
import io.restassured.http.Header;
import io.restassured.path.json.JsonPath;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import org.eclipse.microprofile.metrics.test.optional.MetricAppBeanOptional;
import org.eclipse.microprofile.metrics.test.optional.MetricsRESTActivator;
import org.eclipse.microprofile.metrics.test.optional.NameObject;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.container.test.api.RunAsClient;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.junit.InSequence;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
public class MpMetricOptionalTest {
    private static final String JSON_APP_LABEL_REGEX = ";_app=[-/A-Za-z0-9]+([;\\\"]?)";
    private static final String JSON_APP_LABEL_REGEXS_SUB = "$1";
    private static final String OPENMETRICS_APP_LABEL_REGEX = "_app=\"[-/A-Za-z0-9]+\"";
    private static final String APPLICATION_JSON = "application/json";
    private static String contextRoot;
    private static int applicationPort;
    private static final String TEXT_PLAIN = "text/plain";
    private static final String STRING_PARAM = "_java.lang.String";
    private static final String INT_PARAM = "_int";
    private static final String INTW_PARAM = "_java.lang.Integer";
    private static final String DOUBLEW_PARAM = "_java.lang.Double";
    private static final String LONGW_PARAM = "_java.lang.Long";
    private static final String BOOLEANW_PARAM = "_java.lang.Boolean";
    private static final String DOUBLE_PARAM = "_double";
    private static final String LONG_PARAM = "_long";
    private static final String BOOLEAN_PARAM = "_boolean";
    private static final String HTTP_HEADERS_PARAM = "_javax.ws.rs.core.HttpHeaders";
    private static final String REQUEST_PARAM = "_javax.ws.rs.core.Request";
    private static final String URI_INFO_PARAM = "_javax.ws.rs.core.UriInfo";
    private static final String RESOURCE_CONTEXT_PARAM = "_javax.ws.rs.container.ResourceContext";
    private static final String PROVIDERS_PARAM = "_javax.ws.rs.ext.Providers";
    private static final String APPLICATION_PARAM = "_javax.ws.rs.core.Application";
    private static final String SECURITY_CONTEXT_PARAM = "_javax.ws.rs.core.SecurityContext";
    private static final String CONFIGURATION_PARAM = "_javax.ws.rs.core.Configuration";
    private static final String LIST_PARAM = "_java.util.List";
    private static final String SET_PARAM = "_java.util.Set";
    private static final String SORTED_SET_PARAM = "_java.util.SortedSet";
    private static final String OBJECT_PARAM = "_java.lang.Object";
    private static final String NAME_OBJECT_PARAM = "_org.eclipse.microprofile.metrics.test.optional.NameObject";
    private static final String AYNC_RESP_PARAM = "_javax.ws.rs.container.AsyncResponse";
    private static final String JSON_BASE_REQUEST_COUNT_START = "'REST.request'.'count;class=org.eclipse.microprofile.metrics.test.optional.MetricAppBeanOptional;method=";
    private static final String JSON_BASE_REQUEST_TIME_START = "'REST.request'.'elapsedTime;class=org.eclipse.microprofile.metrics.test.optional.MetricAppBeanOptional;method=";
    private static final String JSON_BASE_REQUEST_END = ";tier=integration'";
    private static final String OM_BASE_REQUEST_COUNT_START = "base_REST_request_total{class=\"org.eclipse.microprofile.metrics.test.optional.MetricAppBeanOptional\",method=\"";
    private static final String OM_BASE_REQUEST_TIME_START = "base_REST_request_elapsedTime_seconds{class=\"org.eclipse.microprofile.metrics.test.optional.MetricAppBeanOptional\",method=\"";
    private static final String OM_BASE_REQUEST_END = "\",tier=\"integration\"}";
    private static final String METRICS_ENDPOINT = "/metrics";
    private static final String BASE_METRIC_ENDPOINT = "/metrics/base";
    private static final String RESTREQUEST_METRIC_ENDPOINT = "/metrics/base/REST.request";
    @ArquillianResource
    private URL deploymentURL;
    private static final String DEFAULT_PROTOCOL = "http";
    private static final String DEFAULT_HOST = "localhost";
    private static final int DEFAULT_PORT = 8080;

    private static String filterOutAppLabelJSON(String responseBody) {
        return responseBody.replaceAll(JSON_APP_LABEL_REGEX, JSON_APP_LABEL_REGEXS_SUB);
    }

    private static String filterOutAppLabelOpenMetrics(String responseBody) {
        return responseBody.replaceAll(OPENMETRICS_APP_LABEL_REGEX, "").replaceAll("\\{,", "{").replaceAll(",\\}", "}");
    }

    @BeforeClass
    public static void setup() throws MalformedURLException {
        String serverUrl = System.getProperty("test.url");
        String protocol = DEFAULT_PROTOCOL;
        String host = DEFAULT_HOST;
        int port = 8080;
        if (serverUrl != null) {
            URL url = new URL(serverUrl);
            protocol = url.getProtocol();
            host = url.getHost();
            port = url.getPort() == -1 ? 8080 : url.getPort();
        }
        RestAssured.baseURI = protocol + "://" + host;
        RestAssured.port = port;
        String userName = System.getProperty("test.user");
        String password = System.getProperty("test.pwd");
        if (userName != null && password != null) {
            RestAssured.authentication = RestAssured.basic((String)userName, (String)password);
            RestAssured.useRelaxedHTTPSValidation();
        }
        contextRoot = System.getProperty("context.root", "/optionalTCK");
        applicationPort = Integer.parseInt(System.getProperty("application.port", Integer.toString(port)));
    }

    @Deployment
    public static WebArchive createDeployment() {
        WebArchive jar = (WebArchive)((WebArchive)((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)"optionalTCK.war")).addPackage(MetricAppBeanOptional.class.getPackage())).addClasses(new Class[]{MetricsRESTActivator.class, MetricAppBeanOptional.class, NameObject.class})).addAsWebInfResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
        System.out.println(jar.toString(true));
        return jar;
    }

    @Test
    @RunAsClient
    @InSequence(value=1)
    public void testSimpleRESTGet() throws InterruptedException {
        Header acceptHeader = new Header("Accept", TEXT_PLAIN);
        ((ValidatableResponse)((Response)RestAssured.given().header(acceptHeader).port(applicationPort).when().get(contextRoot + "/get-noparam", new Object[0])).then()).statusCode(200);
        Response resp = (Response)RestAssured.given().header(acceptHeader).when().get(METRICS_ENDPOINT, new Object[0]);
        ResponseBuilder responseBuilder = new ResponseBuilder();
        responseBuilder.clone(resp);
        responseBuilder.setBody(MpMetricOptionalTest.filterOutAppLabelOpenMetrics(resp.getBody().asString()));
        resp = responseBuilder.build();
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)resp.then()).statusCode(200)).contentType(TEXT_PLAIN)).body(CoreMatchers.containsString((String)"base_REST_request_total{class=\"org.eclipse.microprofile.metrics.test.optional.MetricAppBeanOptional\",method=\"getNoParam\",tier=\"integration\"}"), new Matcher[]{CoreMatchers.containsString((String)"base_REST_request_elapsedTime_seconds{class=\"org.eclipse.microprofile.metrics.test.optional.MetricAppBeanOptional\",method=\"getNoParam\",tier=\"integration\"}")});
    }

    @Test
    @RunAsClient
    @InSequence(value=2)
    public void testSimpleRESTGetExplicit() throws InterruptedException {
        Header acceptHeader = new Header("Accept", TEXT_PLAIN);
        ((ValidatableResponse)((Response)RestAssured.given().header(acceptHeader).port(applicationPort).when().get(contextRoot + "/get-noparam", new Object[0])).then()).statusCode(200);
        Response resp = (Response)RestAssured.given().header(acceptHeader).when().get(RESTREQUEST_METRIC_ENDPOINT, new Object[0]);
        ResponseBuilder responseBuilder = new ResponseBuilder();
        responseBuilder.clone(resp);
        responseBuilder.setBody(MpMetricOptionalTest.filterOutAppLabelOpenMetrics(resp.getBody().asString()));
        resp = responseBuilder.build();
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)resp.then()).statusCode(200)).contentType(TEXT_PLAIN)).body(CoreMatchers.containsString((String)"base_REST_request_total{class=\"org.eclipse.microprofile.metrics.test.optional.MetricAppBeanOptional\",method=\"getNoParam\",tier=\"integration\"} 2"), new Matcher[]{CoreMatchers.containsString((String)"base_REST_request_elapsedTime_seconds{class=\"org.eclipse.microprofile.metrics.test.optional.MetricAppBeanOptional\",method=\"getNoParam\",tier=\"integration\"}")});
    }

    @Test
    @RunAsClient
    @InSequence(value=3)
    public void testSimpleRESTOptions() throws InterruptedException {
        Header acceptHeader = new Header("Accept", TEXT_PLAIN);
        ((ValidatableResponse)((Response)RestAssured.given().header(acceptHeader).port(applicationPort).when().options(contextRoot + "/options-noparam", new Object[0])).then()).statusCode(200);
        Response resp = (Response)RestAssured.given().header(acceptHeader).when().get(RESTREQUEST_METRIC_ENDPOINT, new Object[0]);
        ResponseBuilder responseBuilder = new ResponseBuilder();
        responseBuilder.clone(resp);
        responseBuilder.setBody(MpMetricOptionalTest.filterOutAppLabelOpenMetrics(resp.getBody().asString()));
        resp = responseBuilder.build();
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)resp.then()).statusCode(200)).contentType(TEXT_PLAIN)).body(CoreMatchers.containsString((String)"base_REST_request_total{class=\"org.eclipse.microprofile.metrics.test.optional.MetricAppBeanOptional\",method=\"optionsNoParam\",tier=\"integration\"}"), new Matcher[]{CoreMatchers.containsString((String)"base_REST_request_elapsedTime_seconds{class=\"org.eclipse.microprofile.metrics.test.optional.MetricAppBeanOptional\",method=\"optionsNoParam\",tier=\"integration\"}")});
    }

    @Test
    @RunAsClient
    @InSequence(value=4)
    public void testSimpleRESTHead() throws InterruptedException {
        Header acceptHeader = new Header("Accept", TEXT_PLAIN);
        ((ValidatableResponse)((Response)RestAssured.given().header(acceptHeader).port(applicationPort).when().head(contextRoot + "/head-noparam", new Object[0])).then()).statusCode(200);
        Response resp = (Response)RestAssured.given().header(acceptHeader).when().get(RESTREQUEST_METRIC_ENDPOINT, new Object[0]);
        ResponseBuilder responseBuilder = new ResponseBuilder();
        responseBuilder.clone(resp);
        responseBuilder.setBody(MpMetricOptionalTest.filterOutAppLabelOpenMetrics(resp.getBody().asString()));
        resp = responseBuilder.build();
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)resp.then()).statusCode(200)).contentType(TEXT_PLAIN)).body(CoreMatchers.containsString((String)"base_REST_request_total{class=\"org.eclipse.microprofile.metrics.test.optional.MetricAppBeanOptional\",method=\"headNoParam\",tier=\"integration\"}"), new Matcher[]{CoreMatchers.containsString((String)"base_REST_request_elapsedTime_seconds{class=\"org.eclipse.microprofile.metrics.test.optional.MetricAppBeanOptional\",method=\"headNoParam\",tier=\"integration\"}")});
    }

    @Test
    @RunAsClient
    @InSequence(value=5)
    public void testSimpleRESTPut() throws InterruptedException {
        Header acceptHeader = new Header("Accept", TEXT_PLAIN);
        ((ValidatableResponse)((Response)RestAssured.given().header(acceptHeader).port(applicationPort).when().put(contextRoot + "/put-noparam", new Object[0])).then()).statusCode(200);
        Response resp = (Response)RestAssured.given().header(acceptHeader).when().get(RESTREQUEST_METRIC_ENDPOINT, new Object[0]);
        ResponseBuilder responseBuilder = new ResponseBuilder();
        responseBuilder.clone(resp);
        responseBuilder.setBody(MpMetricOptionalTest.filterOutAppLabelOpenMetrics(resp.getBody().asString()));
        resp = responseBuilder.build();
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)resp.then()).statusCode(200)).contentType(TEXT_PLAIN)).body(CoreMatchers.containsString((String)"base_REST_request_total{class=\"org.eclipse.microprofile.metrics.test.optional.MetricAppBeanOptional\",method=\"putNoParam\",tier=\"integration\"}"), new Matcher[]{CoreMatchers.containsString((String)"base_REST_request_elapsedTime_seconds{class=\"org.eclipse.microprofile.metrics.test.optional.MetricAppBeanOptional\",method=\"putNoParam\",tier=\"integration\"}")});
    }

    @Test
    @RunAsClient
    @InSequence(value=6)
    public void testSimpleRESTPost() throws InterruptedException {
        Header acceptHeader = new Header("Accept", TEXT_PLAIN);
        ((ValidatableResponse)((Response)RestAssured.given().header(acceptHeader).port(applicationPort).when().post(contextRoot + "/post-noparam", new Object[0])).then()).statusCode(200);
        Response resp = (Response)RestAssured.given().header(acceptHeader).when().get(RESTREQUEST_METRIC_ENDPOINT, new Object[0]);
        ResponseBuilder responseBuilder = new ResponseBuilder();
        responseBuilder.clone(resp);
        responseBuilder.setBody(MpMetricOptionalTest.filterOutAppLabelOpenMetrics(resp.getBody().asString()));
        resp = responseBuilder.build();
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)resp.then()).statusCode(200)).contentType(TEXT_PLAIN)).body(CoreMatchers.containsString((String)"base_REST_request_total{class=\"org.eclipse.microprofile.metrics.test.optional.MetricAppBeanOptional\",method=\"postNoParam\",tier=\"integration\"}"), new Matcher[]{CoreMatchers.containsString((String)"base_REST_request_elapsedTime_seconds{class=\"org.eclipse.microprofile.metrics.test.optional.MetricAppBeanOptional\",method=\"postNoParam\",tier=\"integration\"}")});
    }

    @Test
    @RunAsClient
    @InSequence(value=7)
    public void testDeleteNoParam() throws InterruptedException {
        Header acceptHeader = new Header("Accept", TEXT_PLAIN);
        ((ValidatableResponse)((Response)RestAssured.given().header(acceptHeader).port(applicationPort).when().delete(contextRoot + "/delete-noparam", new Object[0])).then()).statusCode(200);
        Response resp = (Response)RestAssured.given().header(acceptHeader).when().get(RESTREQUEST_METRIC_ENDPOINT, new Object[0]);
        ResponseBuilder responseBuilder = new ResponseBuilder();
        responseBuilder.clone(resp);
        responseBuilder.setBody(MpMetricOptionalTest.filterOutAppLabelOpenMetrics(resp.getBody().asString()));
        resp = responseBuilder.build();
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)resp.then()).statusCode(200)).contentType(TEXT_PLAIN)).body(CoreMatchers.containsString((String)"base_REST_request_total{class=\"org.eclipse.microprofile.metrics.test.optional.MetricAppBeanOptional\",method=\"deleteNoParam\",tier=\"integration\"}"), new Matcher[]{CoreMatchers.containsString((String)"base_REST_request_elapsedTime_seconds{class=\"org.eclipse.microprofile.metrics.test.optional.MetricAppBeanOptional\",method=\"deleteNoParam\",tier=\"integration\"}")});
    }

    @Test
    @RunAsClient
    @InSequence(value=8)
    public void testGetSingleParams() throws InterruptedException {
        Header acceptHeader = new Header("Accept", TEXT_PLAIN);
        ((ValidatableResponse)((Response)RestAssured.given().header(acceptHeader).port(applicationPort).queryParam("qp1", new Object[]{"s1"}).when().get(contextRoot + "/get-single-string-param", new Object[0])).then()).statusCode(200);
        ((ValidatableResponse)((Response)RestAssured.given().header(acceptHeader).port(applicationPort).queryParam("qp1", new Object[]{123}).when().get(contextRoot + "/get-single-int-param", new Object[0])).then()).statusCode(200);
        ((ValidatableResponse)((Response)RestAssured.given().header(acceptHeader).port(applicationPort).queryParam("qp1", new Object[]{123.45}).when().get(contextRoot + "/get-single-double-param", new Object[0])).then()).statusCode(200);
        ((ValidatableResponse)((Response)RestAssured.given().header(acceptHeader).port(applicationPort).queryParam("qp1", new Object[]{123L}).when().get(contextRoot + "/get-single-long-param", new Object[0])).then()).statusCode(200);
        ((ValidatableResponse)((Response)RestAssured.given().header(acceptHeader).port(applicationPort).queryParam("qp1", new Object[]{true}).when().get(contextRoot + "/get-single-boolean-param", new Object[0])).then()).statusCode(200);
        Response resp = (Response)RestAssured.given().header(acceptHeader).when().get(RESTREQUEST_METRIC_ENDPOINT, new Object[0]);
        ResponseBuilder responseBuilder = new ResponseBuilder();
        responseBuilder.clone(resp);
        responseBuilder.setBody(MpMetricOptionalTest.filterOutAppLabelOpenMetrics(resp.getBody().asString()));
        resp = responseBuilder.build();
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)resp.then()).statusCode(200)).contentType(TEXT_PLAIN)).body(CoreMatchers.containsString((String)"base_REST_request_total{class=\"org.eclipse.microprofile.metrics.test.optional.MetricAppBeanOptional\",method=\"getSingleStringParam_java.lang.String\",tier=\"integration\"}"), new Matcher[]{CoreMatchers.containsString((String)"base_REST_request_elapsedTime_seconds{class=\"org.eclipse.microprofile.metrics.test.optional.MetricAppBeanOptional\",method=\"getSingleStringParam_java.lang.String\",tier=\"integration\"}"), CoreMatchers.containsString((String)"base_REST_request_total{class=\"org.eclipse.microprofile.metrics.test.optional.MetricAppBeanOptional\",method=\"getSingleIntParam_int\",tier=\"integration\"}"), CoreMatchers.containsString((String)"base_REST_request_elapsedTime_seconds{class=\"org.eclipse.microprofile.metrics.test.optional.MetricAppBeanOptional\",method=\"getSingleIntParam_int\",tier=\"integration\"}"), CoreMatchers.containsString((String)"base_REST_request_total{class=\"org.eclipse.microprofile.metrics.test.optional.MetricAppBeanOptional\",method=\"getSingleDoubleParam_double\",tier=\"integration\"}"), CoreMatchers.containsString((String)"base_REST_request_elapsedTime_seconds{class=\"org.eclipse.microprofile.metrics.test.optional.MetricAppBeanOptional\",method=\"getSingleDoubleParam_double\",tier=\"integration\"}"), CoreMatchers.containsString((String)"base_REST_request_total{class=\"org.eclipse.microprofile.metrics.test.optional.MetricAppBeanOptional\",method=\"getSingleLongParam_long\",tier=\"integration\"}"), CoreMatchers.containsString((String)"base_REST_request_elapsedTime_seconds{class=\"org.eclipse.microprofile.metrics.test.optional.MetricAppBeanOptional\",method=\"getSingleLongParam_long\",tier=\"integration\"}"), CoreMatchers.containsString((String)"base_REST_request_total{class=\"org.eclipse.microprofile.metrics.test.optional.MetricAppBeanOptional\",method=\"getSingleBooleanParam_boolean\",tier=\"integration\"}"), CoreMatchers.containsString((String)"base_REST_request_elapsedTime_seconds{class=\"org.eclipse.microprofile.metrics.test.optional.MetricAppBeanOptional\",method=\"getSingleBooleanParam_boolean\",tier=\"integration\"}")});
    }

    @Test
    @RunAsClient
    @InSequence(value=9)
    public void testGetContextParams() throws InterruptedException {
        Header acceptHeader = new Header("Accept", TEXT_PLAIN);
        ((ValidatableResponse)((Response)RestAssured.given().header(acceptHeader).port(applicationPort).when().get(contextRoot + "/get-context-params", new Object[0])).then()).statusCode(200);
        Response resp = (Response)RestAssured.given().header(acceptHeader).when().get(RESTREQUEST_METRIC_ENDPOINT, new Object[0]);
        ResponseBuilder responseBuilder = new ResponseBuilder();
        responseBuilder.clone(resp);
        responseBuilder.setBody(MpMetricOptionalTest.filterOutAppLabelOpenMetrics(resp.getBody().asString()));
        resp = responseBuilder.build();
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)resp.then()).statusCode(200)).contentType(TEXT_PLAIN)).body(CoreMatchers.containsString((String)"base_REST_request_total{class=\"org.eclipse.microprofile.metrics.test.optional.MetricAppBeanOptional\",method=\"getContextParams_javax.ws.rs.core.HttpHeaders_javax.ws.rs.core.Request_javax.ws.rs.core.UriInfo_javax.ws.rs.container.ResourceContext_javax.ws.rs.ext.Providers_javax.ws.rs.core.Application_javax.ws.rs.core.SecurityContext_javax.ws.rs.core.Configuration\",tier=\"integration\"}"), new Matcher[]{CoreMatchers.containsString((String)"base_REST_request_elapsedTime_seconds{class=\"org.eclipse.microprofile.metrics.test.optional.MetricAppBeanOptional\",method=\"getContextParams_javax.ws.rs.core.HttpHeaders_javax.ws.rs.core.Request_javax.ws.rs.core.UriInfo_javax.ws.rs.container.ResourceContext_javax.ws.rs.ext.Providers_javax.ws.rs.core.Application_javax.ws.rs.core.SecurityContext_javax.ws.rs.core.Configuration\",tier=\"integration\"}")});
    }

    @Test
    @RunAsClient
    @InSequence(value=10)
    public void testGetListParam() throws InterruptedException {
        Header acceptHeader = new Header("Accept", TEXT_PLAIN);
        ((ValidatableResponse)((Response)RestAssured.given().header(acceptHeader).port(applicationPort).queryParam("qp1", Arrays.asList("a", "b", "c")).when().get(contextRoot + "/get-list-param1", new Object[0])).then()).statusCode(200);
        ((ValidatableResponse)((Response)RestAssured.given().header(acceptHeader).port(applicationPort).queryParam("qp1", Arrays.asList(1, 2)).when().get(contextRoot + "/get-list-param2", new Object[0])).then()).statusCode(200);
        ((ValidatableResponse)((Response)RestAssured.given().header(acceptHeader).port(applicationPort).queryParam("qp1", Arrays.asList(1.0, 2.0)).queryParam("qp2", Arrays.asList(1L, 2L)).when().get(contextRoot + "/get-list-param3", new Object[0])).then()).statusCode(200);
        Response resp = (Response)RestAssured.given().header(acceptHeader).when().get(RESTREQUEST_METRIC_ENDPOINT, new Object[0]);
        ResponseBuilder responseBuilder = new ResponseBuilder();
        responseBuilder.clone(resp);
        responseBuilder.setBody(MpMetricOptionalTest.filterOutAppLabelOpenMetrics(resp.getBody().asString()));
        resp = responseBuilder.build();
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)resp.then()).statusCode(200)).contentType(TEXT_PLAIN)).body(CoreMatchers.containsString((String)"base_REST_request_total{class=\"org.eclipse.microprofile.metrics.test.optional.MetricAppBeanOptional\",method=\"getListParam1_java.util.List\",tier=\"integration\"}"), new Matcher[]{CoreMatchers.containsString((String)"base_REST_request_elapsedTime_seconds{class=\"org.eclipse.microprofile.metrics.test.optional.MetricAppBeanOptional\",method=\"getListParam1_java.util.List\",tier=\"integration\"}"), CoreMatchers.containsString((String)"base_REST_request_total{class=\"org.eclipse.microprofile.metrics.test.optional.MetricAppBeanOptional\",method=\"getListParam2_java.util.List\",tier=\"integration\"}"), CoreMatchers.containsString((String)"base_REST_request_elapsedTime_seconds{class=\"org.eclipse.microprofile.metrics.test.optional.MetricAppBeanOptional\",method=\"getListParam2_java.util.List\",tier=\"integration\"}"), CoreMatchers.containsString((String)"base_REST_request_total{class=\"org.eclipse.microprofile.metrics.test.optional.MetricAppBeanOptional\",method=\"getListParam3_java.util.List_java.util.List\",tier=\"integration\"}"), CoreMatchers.containsString((String)"base_REST_request_elapsedTime_seconds{class=\"org.eclipse.microprofile.metrics.test.optional.MetricAppBeanOptional\",method=\"getListParam3_java.util.List_java.util.List\",tier=\"integration\"}")});
    }

    @Test
    @RunAsClient
    @InSequence(value=12)
    public void testGetMultiParam() throws InterruptedException {
        Header acceptHeader = new Header("Accept", TEXT_PLAIN);
        ((ValidatableResponse)((Response)RestAssured.given().header(acceptHeader).port(applicationPort).queryParam("qp1", new Object[]{true}).queryParam("qp2", new Object[]{1}).queryParam("qp3", new Object[]{1.0}).queryParam("qp4", new Object[]{"a"}).queryParam("qp5", new Object[]{1L}).when().get(contextRoot + "/get-multiple-param1", new Object[0])).then()).statusCode(200);
        ((ValidatableResponse)((Response)RestAssured.given().header(acceptHeader).port(applicationPort).queryParam("qp1", new Object[]{"a"}).queryParam("qp2", Arrays.asList("b", "c")).when().get(contextRoot + "/get-multiple-param2", new Object[0])).then()).statusCode(200);
        ((ValidatableResponse)((Response)RestAssured.given().header(acceptHeader).port(applicationPort).queryParam("qp1", Arrays.asList("a", "b", "c")).queryParam("qp1", Arrays.asList("x", "y", "z")).queryParam("qp3", Arrays.asList(1.0, 2.0, 3.0)).when().get(contextRoot + "/get-multiple-param4", new Object[0])).then()).statusCode(200);
        Response resp = (Response)RestAssured.given().header(acceptHeader).when().get(RESTREQUEST_METRIC_ENDPOINT, new Object[0]);
        ResponseBuilder responseBuilder = new ResponseBuilder();
        responseBuilder.clone(resp);
        responseBuilder.setBody(MpMetricOptionalTest.filterOutAppLabelOpenMetrics(resp.getBody().asString()));
        resp = responseBuilder.build();
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)resp.then()).statusCode(200)).contentType(TEXT_PLAIN)).body(CoreMatchers.containsString((String)"base_REST_request_total{class=\"org.eclipse.microprofile.metrics.test.optional.MetricAppBeanOptional\",method=\"getMultipleParam1_boolean_int_double_java.lang.String_long\",tier=\"integration\"}"), new Matcher[]{CoreMatchers.containsString((String)"base_REST_request_elapsedTime_seconds{class=\"org.eclipse.microprofile.metrics.test.optional.MetricAppBeanOptional\",method=\"getMultipleParam1_boolean_int_double_java.lang.String_long\",tier=\"integration\"}"), CoreMatchers.containsString((String)"base_REST_request_total{class=\"org.eclipse.microprofile.metrics.test.optional.MetricAppBeanOptional\",method=\"getMultipleParam2_java.lang.String_java.util.List\",tier=\"integration\"}"), CoreMatchers.containsString((String)"base_REST_request_elapsedTime_seconds{class=\"org.eclipse.microprofile.metrics.test.optional.MetricAppBeanOptional\",method=\"getMultipleParam2_java.lang.String_java.util.List\",tier=\"integration\"}")});
    }

    @Test
    @RunAsClient
    @InSequence(value=13)
    public void testGetNameObject() throws InterruptedException {
        Header acceptHeader = new Header("Accept", TEXT_PLAIN);
        ((ValidatableResponse)((Response)RestAssured.given().header(acceptHeader).port(applicationPort).when().get(contextRoot + "/get-name-object", new Object[0])).then()).statusCode(200);
        Response resp = (Response)RestAssured.given().header(acceptHeader).when().get(RESTREQUEST_METRIC_ENDPOINT, new Object[0]);
        ResponseBuilder responseBuilder = new ResponseBuilder();
        responseBuilder.clone(resp);
        responseBuilder.setBody(MpMetricOptionalTest.filterOutAppLabelOpenMetrics(resp.getBody().asString()));
        resp = responseBuilder.build();
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)resp.then()).statusCode(200)).contentType(TEXT_PLAIN)).body(CoreMatchers.containsString((String)"base_REST_request_total{class=\"org.eclipse.microprofile.metrics.test.optional.MetricAppBeanOptional\",method=\"getNameObject_org.eclipse.microprofile.metrics.test.optional.NameObject\",tier=\"integration\"}"), new Matcher[]{CoreMatchers.containsString((String)"base_REST_request_elapsedTime_seconds{class=\"org.eclipse.microprofile.metrics.test.optional.MetricAppBeanOptional\",method=\"getNameObject_org.eclipse.microprofile.metrics.test.optional.NameObject\",tier=\"integration\"}")});
    }

    @Test
    @RunAsClient
    @InSequence(value=14)
    public void testGetAsync() throws InterruptedException {
        Header acceptHeader = new Header("Accept", TEXT_PLAIN);
        ((ValidatableResponse)((Response)RestAssured.given().header(acceptHeader).port(applicationPort).when().get(contextRoot + "/get-async", new Object[0])).then()).statusCode(200);
        Response resp = (Response)RestAssured.given().header(acceptHeader).when().get(RESTREQUEST_METRIC_ENDPOINT, new Object[0]);
        ResponseBuilder responseBuilder = new ResponseBuilder();
        responseBuilder.clone(resp);
        responseBuilder.setBody(MpMetricOptionalTest.filterOutAppLabelOpenMetrics(resp.getBody().asString()));
        resp = responseBuilder.build();
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)resp.then()).statusCode(200)).contentType(TEXT_PLAIN)).body(CoreMatchers.containsString((String)"base_REST_request_total{class=\"org.eclipse.microprofile.metrics.test.optional.MetricAppBeanOptional\",method=\"getAsync_javax.ws.rs.container.AsyncResponse\",tier=\"integration\"}"), new Matcher[]{CoreMatchers.containsString((String)"base_REST_request_elapsedTime_seconds{class=\"org.eclipse.microprofile.metrics.test.optional.MetricAppBeanOptional\",method=\"getAsync_javax.ws.rs.container.AsyncResponse\",tier=\"integration\"}")});
    }

    @Test
    @RunAsClient
    @InSequence(value=15)
    public void testPostMultiParam() throws InterruptedException {
        Header acceptHeader = new Header("Accept", TEXT_PLAIN);
        ((ValidatableResponse)((Response)RestAssured.given().header(acceptHeader).port(applicationPort).queryParam("qp1", new Object[]{true}).queryParam("qp2", new Object[]{1}).queryParam("qp3", new Object[]{1.0}).queryParam("qp4", new Object[]{"a"}).queryParam("qp5", new Object[]{1L}).when().post(contextRoot + "/post-multiple-param1", new Object[0])).then()).statusCode(200);
        ((ValidatableResponse)((Response)RestAssured.given().header(acceptHeader).port(applicationPort).queryParam("qp1", new Object[]{"a"}).queryParam("qp2", Arrays.asList("b", "c")).when().post(contextRoot + "/post-multiple-param2", new Object[0])).then()).statusCode(200);
        ((ValidatableResponse)((Response)RestAssured.given().header(acceptHeader).port(applicationPort).queryParam("qp1", Arrays.asList("a", "b", "c")).queryParam("qp1", Arrays.asList("x", "y", "z")).queryParam("qp3", Arrays.asList(1.0, 2.0, 3.0)).when().post(contextRoot + "/post-multiple-param4", new Object[0])).then()).statusCode(200);
        Response resp = (Response)RestAssured.given().header(acceptHeader).when().get(RESTREQUEST_METRIC_ENDPOINT, new Object[0]);
        ResponseBuilder responseBuilder = new ResponseBuilder();
        responseBuilder.clone(resp);
        responseBuilder.setBody(MpMetricOptionalTest.filterOutAppLabelOpenMetrics(resp.getBody().asString()));
        resp = responseBuilder.build();
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)resp.then()).statusCode(200)).contentType(TEXT_PLAIN)).body(CoreMatchers.containsString((String)"base_REST_request_total{class=\"org.eclipse.microprofile.metrics.test.optional.MetricAppBeanOptional\",method=\"postMultipleParam1_boolean_int_double_java.lang.String_long\",tier=\"integration\"}"), new Matcher[]{CoreMatchers.containsString((String)"base_REST_request_elapsedTime_seconds{class=\"org.eclipse.microprofile.metrics.test.optional.MetricAppBeanOptional\",method=\"postMultipleParam1_boolean_int_double_java.lang.String_long\",tier=\"integration\"}"), CoreMatchers.containsString((String)"base_REST_request_total{class=\"org.eclipse.microprofile.metrics.test.optional.MetricAppBeanOptional\",method=\"postMultipleParam2_java.lang.String_java.util.List\",tier=\"integration\"}"), CoreMatchers.containsString((String)"base_REST_request_elapsedTime_seconds{class=\"org.eclipse.microprofile.metrics.test.optional.MetricAppBeanOptional\",method=\"postMultipleParam2_java.lang.String_java.util.List\",tier=\"integration\"}")});
    }

    @Test
    @RunAsClient
    @InSequence(value=16)
    public void testValidateGetJSONnoParam() throws InterruptedException {
        Header acceptHeader = new Header("Accept", APPLICATION_JSON);
        Response resp = (Response)RestAssured.given().header(acceptHeader).when().get(RESTREQUEST_METRIC_ENDPOINT, new Object[0]);
        JsonPath filteredJSONPath = new JsonPath(MpMetricOptionalTest.filterOutAppLabelJSON(resp.jsonPath().prettify()));
        ResponseBuilder responseBuilder = new ResponseBuilder();
        responseBuilder.clone(resp);
        responseBuilder.setBody(filteredJSONPath.prettify());
        resp = responseBuilder.build();
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)resp.then()).statusCode(200)).contentType(APPLICATION_JSON)).body("'REST.request'.'count;class=org.eclipse.microprofile.metrics.test.optional.MetricAppBeanOptional;method=getNoParam;tier=integration'", CoreMatchers.equalTo((Object)2), new Object[0])).body("'REST.request'.'elapsedTime;class=org.eclipse.microprofile.metrics.test.optional.MetricAppBeanOptional;method=getNoParam;tier=integration'", Matchers.not((Object)0), new Object[0])).body("'REST.request'.'count;class=org.eclipse.microprofile.metrics.test.optional.MetricAppBeanOptional;method=optionsNoParam;tier=integration'", CoreMatchers.equalTo((Object)1), new Object[0])).body("'REST.request'.'elapsedTime;class=org.eclipse.microprofile.metrics.test.optional.MetricAppBeanOptional;method=optionsNoParam;tier=integration'", Matchers.not((Object)0), new Object[0])).body("'REST.request'.'count;class=org.eclipse.microprofile.metrics.test.optional.MetricAppBeanOptional;method=headNoParam;tier=integration'", CoreMatchers.equalTo((Object)1), new Object[0])).body("'REST.request'.'elapsedTime;class=org.eclipse.microprofile.metrics.test.optional.MetricAppBeanOptional;method=headNoParam;tier=integration'", Matchers.not((Object)0), new Object[0])).body("'REST.request'.'count;class=org.eclipse.microprofile.metrics.test.optional.MetricAppBeanOptional;method=putNoParam;tier=integration'", CoreMatchers.equalTo((Object)1), new Object[0])).body("'REST.request'.'elapsedTime;class=org.eclipse.microprofile.metrics.test.optional.MetricAppBeanOptional;method=putNoParam;tier=integration'", Matchers.not((Object)0), new Object[0])).body("'REST.request'.'count;class=org.eclipse.microprofile.metrics.test.optional.MetricAppBeanOptional;method=postNoParam;tier=integration'", CoreMatchers.equalTo((Object)1), new Object[0])).body("'REST.request'.'elapsedTime;class=org.eclipse.microprofile.metrics.test.optional.MetricAppBeanOptional;method=postNoParam;tier=integration'", Matchers.not((Object)0), new Object[0])).body("'REST.request'.'count;class=org.eclipse.microprofile.metrics.test.optional.MetricAppBeanOptional;method=deleteNoParam;tier=integration'", CoreMatchers.equalTo((Object)1), new Object[0])).body("'REST.request'.'elapsedTime;class=org.eclipse.microprofile.metrics.test.optional.MetricAppBeanOptional;method=deleteNoParam;tier=integration'", Matchers.not((Object)0), new Object[0]);
    }

    @Test
    @RunAsClient
    @InSequence(value=17)
    public void testValidateGetJSONParam() throws InterruptedException {
        Header acceptHeader = new Header("Accept", APPLICATION_JSON);
        Response resp = (Response)RestAssured.given().header(acceptHeader).when().get(RESTREQUEST_METRIC_ENDPOINT, new Object[0]);
        JsonPath filteredJSONPath = new JsonPath(MpMetricOptionalTest.filterOutAppLabelJSON(resp.jsonPath().prettify()));
        ResponseBuilder responseBuilder = new ResponseBuilder();
        responseBuilder.clone(resp);
        responseBuilder.setBody(filteredJSONPath.prettify());
        resp = responseBuilder.build();
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)resp.then()).statusCode(200)).contentType(APPLICATION_JSON)).body("'REST.request'.'count;class=org.eclipse.microprofile.metrics.test.optional.MetricAppBeanOptional;method=getSingleStringParam_java.lang.String;tier=integration'", CoreMatchers.equalTo((Object)1), new Object[0])).body("'REST.request'.'elapsedTime;class=org.eclipse.microprofile.metrics.test.optional.MetricAppBeanOptional;method=getSingleStringParam_java.lang.String;tier=integration'", Matchers.not((Object)0), new Object[0])).body("'REST.request'.'count;class=org.eclipse.microprofile.metrics.test.optional.MetricAppBeanOptional;method=getSingleIntParam_int;tier=integration'", CoreMatchers.equalTo((Object)1), new Object[0])).body("'REST.request'.'elapsedTime;class=org.eclipse.microprofile.metrics.test.optional.MetricAppBeanOptional;method=getSingleIntParam_int;tier=integration'", Matchers.not((Object)0), new Object[0])).body("'REST.request'.'count;class=org.eclipse.microprofile.metrics.test.optional.MetricAppBeanOptional;method=getSingleDoubleParam_double;tier=integration'", CoreMatchers.equalTo((Object)1), new Object[0])).body("'REST.request'.'elapsedTime;class=org.eclipse.microprofile.metrics.test.optional.MetricAppBeanOptional;method=getSingleDoubleParam_double;tier=integration'", Matchers.not((Object)0), new Object[0])).body("'REST.request'.'count;class=org.eclipse.microprofile.metrics.test.optional.MetricAppBeanOptional;method=getSingleLongParam_long;tier=integration'", CoreMatchers.equalTo((Object)1), new Object[0])).body("'REST.request'.'elapsedTime;class=org.eclipse.microprofile.metrics.test.optional.MetricAppBeanOptional;method=getSingleLongParam_long;tier=integration'", Matchers.not((Object)0), new Object[0])).body("'REST.request'.'count;class=org.eclipse.microprofile.metrics.test.optional.MetricAppBeanOptional;method=getSingleBooleanParam_boolean;tier=integration'", CoreMatchers.equalTo((Object)1), new Object[0])).body("'REST.request'.'elapsedTime;class=org.eclipse.microprofile.metrics.test.optional.MetricAppBeanOptional;method=getSingleBooleanParam_boolean;tier=integration'", Matchers.not((Object)0), new Object[0])).body("'REST.request'.'count;class=org.eclipse.microprofile.metrics.test.optional.MetricAppBeanOptional;method=getListParam1_java.util.List;tier=integration'", CoreMatchers.equalTo((Object)1), new Object[0])).body("'REST.request'.'elapsedTime;class=org.eclipse.microprofile.metrics.test.optional.MetricAppBeanOptional;method=getListParam1_java.util.List;tier=integration'", Matchers.not((Object)0), new Object[0])).body("'REST.request'.'count;class=org.eclipse.microprofile.metrics.test.optional.MetricAppBeanOptional;method=getListParam2_java.util.List;tier=integration'", CoreMatchers.equalTo((Object)1), new Object[0])).body("'REST.request'.'elapsedTime;class=org.eclipse.microprofile.metrics.test.optional.MetricAppBeanOptional;method=getListParam2_java.util.List;tier=integration'", Matchers.not((Object)0), new Object[0])).body("'REST.request'.'count;class=org.eclipse.microprofile.metrics.test.optional.MetricAppBeanOptional;method=getListParam3_java.util.List_java.util.List;tier=integration'", CoreMatchers.equalTo((Object)1), new Object[0])).body("'REST.request'.'elapsedTime;class=org.eclipse.microprofile.metrics.test.optional.MetricAppBeanOptional;method=getListParam3_java.util.List_java.util.List;tier=integration'", Matchers.not((Object)0), new Object[0])).body("'REST.request'.'count;class=org.eclipse.microprofile.metrics.test.optional.MetricAppBeanOptional;method=getSingleStringParam_java.lang.String;tier=integration'", CoreMatchers.equalTo((Object)1), new Object[0])).body("'REST.request'.'elapsedTime;class=org.eclipse.microprofile.metrics.test.optional.MetricAppBeanOptional;method=getSingleStringParam_java.lang.String;tier=integration'", Matchers.not((Object)0), new Object[0])).body("'REST.request'.'count;class=org.eclipse.microprofile.metrics.test.optional.MetricAppBeanOptional;method=getSingleIntParam_int;tier=integration'", CoreMatchers.equalTo((Object)1), new Object[0])).body("'REST.request'.'elapsedTime;class=org.eclipse.microprofile.metrics.test.optional.MetricAppBeanOptional;method=getSingleIntParam_int;tier=integration'", Matchers.not((Object)0), new Object[0])).body("'REST.request'.'count;class=org.eclipse.microprofile.metrics.test.optional.MetricAppBeanOptional;method=getSingleDoubleParam_double;tier=integration'", CoreMatchers.equalTo((Object)1), new Object[0])).body("'REST.request'.'elapsedTime;class=org.eclipse.microprofile.metrics.test.optional.MetricAppBeanOptional;method=getSingleDoubleParam_double;tier=integration'", Matchers.not((Object)0), new Object[0])).body("'REST.request'.'count;class=org.eclipse.microprofile.metrics.test.optional.MetricAppBeanOptional;method=getSingleLongParam_long;tier=integration'", CoreMatchers.equalTo((Object)1), new Object[0])).body("'REST.request'.'elapsedTime;class=org.eclipse.microprofile.metrics.test.optional.MetricAppBeanOptional;method=getSingleLongParam_long;tier=integration'", Matchers.not((Object)0), new Object[0])).body("'REST.request'.'count;class=org.eclipse.microprofile.metrics.test.optional.MetricAppBeanOptional;method=getSingleBooleanParam_boolean;tier=integration'", CoreMatchers.equalTo((Object)1), new Object[0])).body("'REST.request'.'elapsedTime;class=org.eclipse.microprofile.metrics.test.optional.MetricAppBeanOptional;method=getSingleBooleanParam_boolean;tier=integration'", Matchers.not((Object)0), new Object[0])).body("'REST.request'.'count;class=org.eclipse.microprofile.metrics.test.optional.MetricAppBeanOptional;method=getMultipleParam1_boolean_int_double_java.lang.String_long;tier=integration'", CoreMatchers.equalTo((Object)1), new Object[0])).body("'REST.request'.'elapsedTime;class=org.eclipse.microprofile.metrics.test.optional.MetricAppBeanOptional;method=getMultipleParam1_boolean_int_double_java.lang.String_long;tier=integration'", Matchers.not((Object)0), new Object[0])).body("'REST.request'.'count;class=org.eclipse.microprofile.metrics.test.optional.MetricAppBeanOptional;method=getMultipleParam2_java.lang.String_java.util.List;tier=integration'", CoreMatchers.equalTo((Object)1), new Object[0])).body("'REST.request'.'elapsedTime;class=org.eclipse.microprofile.metrics.test.optional.MetricAppBeanOptional;method=getMultipleParam2_java.lang.String_java.util.List;tier=integration'", Matchers.not((Object)0), new Object[0])).body("'REST.request'.'count;class=org.eclipse.microprofile.metrics.test.optional.MetricAppBeanOptional;method=getMultipleParam4_java.util.Set_java.util.SortedSet;tier=integration'", CoreMatchers.equalTo((Object)1), new Object[0])).body("'REST.request'.'elapsedTime;class=org.eclipse.microprofile.metrics.test.optional.MetricAppBeanOptional;method=getMultipleParam4_java.util.Set_java.util.SortedSet;tier=integration'", Matchers.not((Object)0), new Object[0])).body("'REST.request'.'count;class=org.eclipse.microprofile.metrics.test.optional.MetricAppBeanOptional;method=postMultipleParam1_boolean_int_double_java.lang.String_long;tier=integration'", CoreMatchers.equalTo((Object)1), new Object[0])).body("'REST.request'.'elapsedTime;class=org.eclipse.microprofile.metrics.test.optional.MetricAppBeanOptional;method=postMultipleParam1_boolean_int_double_java.lang.String_long;tier=integration'", Matchers.not((Object)0), new Object[0])).body("'REST.request'.'count;class=org.eclipse.microprofile.metrics.test.optional.MetricAppBeanOptional;method=postMultipleParam2_java.lang.String_java.util.List;tier=integration'", CoreMatchers.equalTo((Object)1), new Object[0])).body("'REST.request'.'elapsedTime;class=org.eclipse.microprofile.metrics.test.optional.MetricAppBeanOptional;method=postMultipleParam2_java.lang.String_java.util.List;tier=integration'", Matchers.not((Object)0), new Object[0])).body("'REST.request'.'count;class=org.eclipse.microprofile.metrics.test.optional.MetricAppBeanOptional;method=postMultipleParam4_java.util.Set_java.util.SortedSet;tier=integration'", CoreMatchers.equalTo((Object)1), new Object[0])).body("'REST.request'.'elapsedTime;class=org.eclipse.microprofile.metrics.test.optional.MetricAppBeanOptional;method=postMultipleParam4_java.util.Set_java.util.SortedSet;tier=integration'", Matchers.not((Object)0), new Object[0])).body("'REST.request'.'count;class=org.eclipse.microprofile.metrics.test.optional.MetricAppBeanOptional;method=getAsync_javax.ws.rs.container.AsyncResponse;tier=integration'", CoreMatchers.equalTo((Object)1), new Object[0])).body("'REST.request'.'elapsedTime;class=org.eclipse.microprofile.metrics.test.optional.MetricAppBeanOptional;method=getAsync_javax.ws.rs.container.AsyncResponse;tier=integration'", Matchers.not((Object)0), new Object[0]);
    }
}

