/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.metrics;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.stream.Collectors;
import org.eclipse.microprofile.metrics.ConcurrentGauge;
import org.eclipse.microprofile.metrics.Counter;
import org.eclipse.microprofile.metrics.Gauge;
import org.eclipse.microprofile.metrics.Histogram;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.Meter;
import org.eclipse.microprofile.metrics.Metric;
import org.eclipse.microprofile.metrics.MetricFilter;
import org.eclipse.microprofile.metrics.MetricID;
import org.eclipse.microprofile.metrics.SimpleTimer;
import org.eclipse.microprofile.metrics.Tag;
import org.eclipse.microprofile.metrics.Timer;

public interface MetricRegistry {
    public static String name(String name, String ... names) {
        ArrayList<String> ns = new ArrayList<String>();
        ns.add(name);
        ns.addAll(Arrays.asList(names));
        return ns.stream().filter(part -> part != null && !part.isEmpty()).collect(Collectors.joining("."));
    }

    public static String name(Class<?> klass, String ... names) {
        return MetricRegistry.name(klass.getCanonicalName(), names);
    }

    public <T extends Metric> T register(String var1, T var2) throws IllegalArgumentException;

    public <T extends Metric> T register(Metadata var1, T var2) throws IllegalArgumentException;

    public <T extends Metric> T register(Metadata var1, T var2, Tag ... var3) throws IllegalArgumentException;

    default public Counter counter(String name) {
        return this.counter(new MetricID(name));
    }

    default public Counter counter(String name, Tag ... tags) {
        return this.counter(new MetricID(name, tags));
    }

    public Counter counter(MetricID var1);

    public Counter counter(Metadata var1);

    public Counter counter(Metadata var1, Tag ... var2);

    default public ConcurrentGauge concurrentGauge(String name) {
        return this.concurrentGauge(new MetricID(name));
    }

    default public ConcurrentGauge concurrentGauge(String name, Tag ... tags) {
        return this.concurrentGauge(new MetricID(name, tags));
    }

    public ConcurrentGauge concurrentGauge(MetricID var1);

    public ConcurrentGauge concurrentGauge(Metadata var1);

    public ConcurrentGauge concurrentGauge(Metadata var1, Tag ... var2);

    default public Gauge<?> gauge(String name, Gauge<?> gauge) {
        return this.gauge(new MetricID(name), gauge);
    }

    default public Gauge<?> gauge(String name, Gauge<?> gauge, Tag ... tags) {
        return this.gauge(new MetricID(name, tags), gauge);
    }

    public Gauge<?> gauge(MetricID var1, Gauge<?> var2);

    default public Histogram histogram(String name) {
        return this.histogram(new MetricID(name));
    }

    default public Histogram histogram(String name, Tag ... tags) {
        return this.histogram(new MetricID(name, tags));
    }

    public Histogram histogram(MetricID var1);

    public Histogram histogram(Metadata var1);

    public Histogram histogram(Metadata var1, Tag ... var2);

    default public Meter meter(String name) {
        return this.meter(new MetricID(name));
    }

    default public Meter meter(String name, Tag ... tags) {
        return this.meter(new MetricID(name, tags));
    }

    public Meter meter(MetricID var1);

    public Meter meter(Metadata var1);

    public Meter meter(Metadata var1, Tag ... var2);

    default public Timer timer(String name) {
        return this.timer(new MetricID(name));
    }

    default public Timer timer(String name, Tag ... tags) {
        return this.timer(new MetricID(name, tags));
    }

    public Timer timer(MetricID var1);

    public Timer timer(Metadata var1);

    public Timer timer(Metadata var1, Tag ... var2);

    default public SimpleTimer simpleTimer(String name) {
        return this.simpleTimer(new MetricID(name));
    }

    default public SimpleTimer simpleTimer(String name, Tag ... tags) {
        return this.simpleTimer(new MetricID(name, tags));
    }

    public SimpleTimer simpleTimer(MetricID var1);

    public SimpleTimer simpleTimer(Metadata var1);

    public SimpleTimer simpleTimer(Metadata var1, Tag ... var2);

    public Metric getMetric(MetricID var1);

    default public <T extends Metric> T getMetric(MetricID metricID, Class<T> asType) {
        try {
            return (T)((Metric)asType.cast(this.getMetric(metricID)));
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException(metricID + " was not of expected type " + asType, e);
        }
    }

    default public Counter getCounter(MetricID metricID) {
        return this.getMetric(metricID, Counter.class);
    }

    default public ConcurrentGauge getConcurrentGauge(MetricID metricID) {
        return this.getMetric(metricID, ConcurrentGauge.class);
    }

    default public Gauge<?> getGauge(MetricID metricID) {
        return this.getMetric(metricID, Gauge.class);
    }

    default public Histogram getHistogram(MetricID metricID) {
        return this.getMetric(metricID, Histogram.class);
    }

    default public Meter getMeter(MetricID metricID) {
        return this.getMetric(metricID, Meter.class);
    }

    default public Timer getTimer(MetricID metricID) {
        return this.getMetric(metricID, Timer.class);
    }

    default public SimpleTimer getSimpleTimer(MetricID metricID) {
        return this.getMetric(metricID, SimpleTimer.class);
    }

    public Metadata getMetadata(String var1);

    public boolean remove(String var1);

    public boolean remove(MetricID var1);

    public void removeMatching(MetricFilter var1);

    public SortedSet<String> getNames();

    public SortedSet<MetricID> getMetricIDs();

    public SortedMap<MetricID, Gauge> getGauges();

    default public SortedMap<MetricID, Gauge> getGauges(MetricFilter filter) {
        return this.getMetrics(Gauge.class, filter);
    }

    public SortedMap<MetricID, Counter> getCounters();

    default public SortedMap<MetricID, Counter> getCounters(MetricFilter filter) {
        return this.getMetrics(Counter.class, filter);
    }

    public SortedMap<MetricID, ConcurrentGauge> getConcurrentGauges();

    default public SortedMap<MetricID, ConcurrentGauge> getConcurrentGauges(MetricFilter filter) {
        return this.getMetrics(ConcurrentGauge.class, filter);
    }

    public SortedMap<MetricID, Histogram> getHistograms();

    default public SortedMap<MetricID, Histogram> getHistograms(MetricFilter filter) {
        return this.getMetrics(Histogram.class, filter);
    }

    public SortedMap<MetricID, Meter> getMeters();

    default public SortedMap<MetricID, Meter> getMeters(MetricFilter filter) {
        return this.getMetrics(Meter.class, filter);
    }

    public SortedMap<MetricID, Timer> getTimers();

    default public SortedMap<MetricID, Timer> getTimers(MetricFilter filter) {
        return this.getMetrics(Timer.class, filter);
    }

    public SortedMap<MetricID, SimpleTimer> getSimpleTimers();

    default public SortedMap<MetricID, SimpleTimer> getSimpleTimers(MetricFilter filter) {
        return this.getMetrics(SimpleTimer.class, filter);
    }

    public SortedMap<MetricID, Metric> getMetrics(MetricFilter var1);

    default public <T extends Metric> SortedMap<MetricID, T> getMetrics(Class<T> ofType, MetricFilter filter) {
        return this.getMetrics((metricID, metric) -> filter.matches(metricID, metric) && ofType.isAssignableFrom(metric.getClass()));
    }

    @Deprecated
    public Map<MetricID, Metric> getMetrics();

    @Deprecated
    public Map<String, Metadata> getMetadata();

    public Type getType();

    public static enum Type {
        APPLICATION("application"),
        BASE("base"),
        VENDOR("vendor");

        private final String name;

        private Type(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

