/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.metrics;

import java.util.EnumSet;
import org.eclipse.microprofile.metrics.ConcurrentGauge;
import org.eclipse.microprofile.metrics.Counter;
import org.eclipse.microprofile.metrics.Gauge;
import org.eclipse.microprofile.metrics.Histogram;
import org.eclipse.microprofile.metrics.Meter;
import org.eclipse.microprofile.metrics.Timer;

public enum MetricType {
    CONCURRENT_GAUGE("concurrent gauge", ConcurrentGauge.class),
    COUNTER("counter", Counter.class),
    GAUGE("gauge", Gauge.class),
    METERED("meter", Meter.class),
    HISTOGRAM("histogram", Histogram.class),
    TIMER("timer", Timer.class),
    INVALID("invalid", null);

    private String type;
    private Class<?> classtype;
    private static final EnumSet<MetricType> METRIC_TYPES;

    private MetricType(String type, Class<?> classtype) {
        this.type = type;
        this.classtype = classtype;
    }

    public String toString() {
        return this.type;
    }

    public static MetricType from(String in) {
        for (MetricType u : METRIC_TYPES) {
            if (!u.type.equals(in)) continue;
            return u;
        }
        throw new IllegalArgumentException(in + " is not a valid MetricType");
    }

    public static MetricType from(Class<?> in) {
        for (MetricType u : METRIC_TYPES) {
            if (u.classtype == null || !u.classtype.isAssignableFrom(in)) continue;
            return u;
        }
        throw new IllegalArgumentException(in + " is not a valid metric type");
    }

    public static MetricType fromClassName(String className) {
        for (MetricType u : METRIC_TYPES) {
            if (u.classtype == null || !u.classtype.getName().equals(className)) continue;
            return u;
        }
        throw new IllegalArgumentException(className + " is not a valid metric class");
    }

    static {
        METRIC_TYPES = EnumSet.allOf(MetricType.class);
    }
}

