/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.metrics;

import java.util.Objects;
import java.util.Optional;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.MetricType;

public class DefaultMetadata
implements Metadata {
    private final String name;
    private final String displayName;
    private final String description;
    private final MetricType type;
    private final String unit;
    private final boolean reusable;

    protected DefaultMetadata(String name, String displayName, String description, MetricType type, String unit, boolean reusable) {
        this.name = name;
        this.displayName = displayName;
        this.description = description;
        this.type = type;
        this.unit = unit;
        this.reusable = reusable;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDisplayName() {
        return Optional.ofNullable(this.displayName).orElse(this.name);
    }

    @Override
    public Optional<String> getDescription() {
        return Optional.ofNullable(this.description);
    }

    @Override
    public String getType() {
        return Optional.ofNullable(this.type).orElse(MetricType.INVALID).toString();
    }

    @Override
    public MetricType getTypeRaw() {
        return Optional.ofNullable(this.type).orElse(MetricType.INVALID);
    }

    @Override
    public Optional<String> getUnit() {
        return Optional.ofNullable(this.unit);
    }

    @Override
    public boolean isReusable() {
        return this.reusable;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Metadata)) {
            return false;
        }
        Metadata that = (Metadata)o;
        String thatDescription = that.getDescription().isPresent() ? that.getDescription().get() : null;
        String thatUnit = that.getUnit().isPresent() ? that.getUnit().get() : "none";
        return Objects.equals(this.name, that.getName()) && Objects.equals(this.getDisplayName(), that.getDisplayName()) && Objects.equals(this.description, thatDescription) && Objects.equals(this.unit, thatUnit) && Objects.equals((Object)this.getTypeRaw(), (Object)that.getTypeRaw()) && Objects.equals(this.reusable, that.isReusable());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.displayName, this.description, this.unit, this.type, this.reusable});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("DefaultMetadata{");
        sb.append("name='").append(this.name).append('\'');
        sb.append(", type=").append((Object)this.type);
        sb.append(", unit='").append(this.unit).append('\'');
        sb.append(", reusable=").append(this.reusable);
        sb.append('}');
        return sb.toString();
    }
}

