/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.metrics.tck.cdi;

import jakarta.inject.Inject;
import org.eclipse.microprofile.metrics.Gauge;
import org.eclipse.microprofile.metrics.annotation.Metric;
import org.eclipse.microprofile.metrics.tck.cdi.GaugeInjectionBean;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.junit.InSequence;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
public class GaugeInjectionBeanTest {
    @Inject
    private GaugeInjectionBean bean;
    @Inject
    @Metric(absolute=true, name="org.eclipse.microprofile.metrics.tck.cdi.GaugeInjectionBean.gaugeInjection")
    private Gauge<Long> gauge;

    @Deployment
    static Archive<?> createTestArchive() {
        return ((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class)).addClass(GaugeInjectionBean.class)).addAsWebInfResource("META-INF/beans.xml", "beans.xml");
    }

    @Before
    public void instantiateApplicationScopedBean() {
        this.bean.getGauge();
    }

    @Test
    @InSequence(value=1)
    public void gaugeCalledWithDefaultValue() {
        Assert.assertThat((String)"Gauge value is incorrect", (Object)((Long)this.gauge.getValue()), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)0L)));
    }

    @Test
    @InSequence(value=2)
    public void callGaugeAfterSetterCall(@Metric(absolute=true, name="org.eclipse.microprofile.metrics.tck.cdi.GaugeInjectionBean.gaugeInjection") Gauge<Long> gauge) {
        long value = 1L + Math.round(Math.random() * 9.223372036854776E18);
        this.bean.setGauge(value);
        Assert.assertThat((String)"Gauge value is incorrect", (Object)((Long)gauge.getValue()), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)value)));
    }
}

