/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.metrics.tck.metrics;

import jakarta.inject.Inject;
import java.util.concurrent.atomic.AtomicLong;
import org.eclipse.microprofile.metrics.Meter;
import org.eclipse.microprofile.metrics.MetricID;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.tck.metrics.MeteredMethodBean1;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.junit.InSequence;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
public class MeteredMethodBeanTest {
    private static final String METER_NAME = MetricRegistry.name(MeteredMethodBean1.class, (String[])new String[]{"meteredMethod"});
    private static MetricID meterMID;
    private static final AtomicLong METER_COUNT;
    @Inject
    private MetricRegistry registry;
    @Inject
    private MeteredMethodBean1 bean;

    @Deployment
    static Archive<?> createTestArchive() {
        return ((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class)).addClass(MeteredMethodBean1.class)).addAsWebInfResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
    }

    @Before
    public void instantiateTest() {
        meterMID = new MetricID(METER_NAME);
    }

    @Test
    @InSequence(value=1)
    public void meteredMethodNotCalledYet() {
        Meter meter = this.registry.getMeter(meterMID);
        Assert.assertThat((String)"Meter is not registered correctly", (Object)meter, (Matcher)Matchers.notNullValue());
        Assert.assertThat((String)"Meter count is incorrect", (Object)meter.getCount(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)METER_COUNT.get())));
    }

    @Test
    @InSequence(value=2)
    public void callMeteredMethodOnce() {
        Meter meter = this.registry.getMeter(meterMID);
        Assert.assertThat((String)"Meter is not registered correctly", (Object)meter, (Matcher)Matchers.notNullValue());
        this.bean.meteredMethod();
        Assert.assertThat((String)"Timer count is incorrect", (Object)meter.getCount(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)METER_COUNT.incrementAndGet())));
    }

    @Test
    @InSequence(value=3)
    public void removeMeterFromRegistry() {
        Meter meter = this.registry.getMeter(meterMID);
        Assert.assertThat((String)"Meter is not registered correctly", (Object)meter, (Matcher)Matchers.notNullValue());
        this.registry.remove(meterMID);
        try {
            this.bean.meteredMethod();
        }
        catch (RuntimeException cause) {
            Assert.assertThat((Object)cause, (Matcher)Matchers.is((Matcher)Matchers.instanceOf(IllegalStateException.class)));
            Assert.assertThat((String)"Meter count is incorrect", (Object)meter.getCount(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)METER_COUNT.get())));
            return;
        }
        Assert.fail((String)"No exception has been re-thrown!");
    }

    static {
        METER_COUNT = new AtomicLong();
    }
}

