/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.metrics.tck.metrics;

import javax.inject.Inject;
import org.eclipse.microprofile.metrics.Counter;
import org.eclipse.microprofile.metrics.MetricID;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.tck.metrics.CounterFieldBean;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.junit.InSequence;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
public class CounterFieldBeanTest {
    private static final String COUNTER_NAME = MetricRegistry.name(CounterFieldBean.class, (String[])new String[]{"counterName"});
    private static MetricID counterMID;
    @Inject
    private MetricRegistry registry;
    @Inject
    private CounterFieldBean bean;

    @Deployment
    public static Archive<?> createTestArchive() {
        return ((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class)).addClass(CounterFieldBean.class)).addAsWebInfResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
    }

    @Before
    public void instantiateTest() {
        counterMID = new MetricID(COUNTER_NAME);
    }

    @Test
    @InSequence(value=1)
    public void counterFieldRegistered() {
        Assert.assertThat((String)"Counter is not registered correctly", (Object)this.registry.getCounter(counterMID), (Matcher)Matchers.notNullValue());
    }

    @Test
    @InSequence(value=2)
    public void incrementCounterField() {
        Counter counter = this.registry.getCounter(counterMID);
        Assert.assertThat((String)"Counter is not registered correctly", (Object)counter, (Matcher)Matchers.notNullValue());
        long value = Math.round(Math.random() * 9.223372036854776E18);
        this.bean.increment(value);
        Assert.assertThat((String)"Counter value is incorrect", (Object)counter.getCount(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)value)));
    }
}

