/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.metrics.tck.metrics;

import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.eclipse.microprofile.metrics.MetricID;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.SimpleTimer;
import org.eclipse.microprofile.metrics.tck.metrics.SimplyTimedConstructorBean;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.junit.InSequence;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
public class SimplyTimedConstructorBeanTest {
    private static final String SIMPLE_TIMER_NAME = MetricRegistry.name(SimplyTimedConstructorBean.class, (String[])new String[]{"simplyTimedConstructor"});
    private static MetricID simpleTimerMID;
    @Inject
    private MetricRegistry registry;
    @Inject
    private Instance<SimplyTimedConstructorBean> instance;

    @Deployment
    static Archive<?> createTestArchive() {
        return ((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class)).addClass(SimplyTimedConstructorBean.class)).addAsWebInfResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
    }

    @Before
    public void instantiateTest() {
        simpleTimerMID = new MetricID(SIMPLE_TIMER_NAME);
    }

    @Test
    @InSequence(value=1)
    public void simpleTimerConstructorCalled() {
        long count = 1L + Math.round(Math.random() * 10.0);
        int i = 0;
        while ((long)i < count) {
            this.instance.get();
            ++i;
        }
        SimpleTimer simpleTimer = this.registry.getSimpleTimer(simpleTimerMID);
        Assert.assertThat((String)"SimpleTimer is not registered correctly", (Object)simpleTimer, (Matcher)Matchers.notNullValue());
        Assert.assertThat((String)"SimpleTimer count is incorrect", (Object)simpleTimer.getCount(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)count)));
    }
}

