/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.metrics.tck.metrics;

import java.util.Arrays;
import java.util.Set;
import javax.inject.Inject;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.tck.metrics.OverloadedTimedMethodBean;
import org.eclipse.microprofile.metrics.tck.util.MetricsUtil;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.junit.InSequence;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
public class OverloadedTimedMethodBeanTest {
    private static final String[] TIMER_NAMES = new String[]{"overloadedTimedMethodWithNoArguments", "overloadedTimedMethodWithStringArgument", "overloadedTimedMethodWithListOfStringArgument", "overloadedTimedMethodWithObjectArgument"};
    @Inject
    private MetricRegistry registry;
    @Inject
    private OverloadedTimedMethodBean bean;

    private Set<String> absoluteMetricNames() {
        return MetricsUtil.absoluteMetricNames(OverloadedTimedMethodBean.class, TIMER_NAMES);
    }

    @Deployment
    static Archive<?> createTestArchive() {
        return ((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class)).addClasses(new Class[]{OverloadedTimedMethodBean.class, MetricsUtil.class})).addAsWebInfResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
    }

    @Test
    @InSequence(value=1)
    public void overloadedTimedMethodNotCalledYet() {
        Assert.assertTrue((String)"Metrics are not registered correctly", (boolean)this.registry.getMetricIDs().containsAll(MetricsUtil.createMetricIDs(this.absoluteMetricNames())));
        Assert.assertThat((String)"Timer counts are incorrect", this.registry.getTimers().values(), (Matcher)Matchers.hasItem((Matcher)Matchers.hasProperty((String)"count", (Matcher)Matchers.equalTo((Object)0L))));
    }

    @Test
    @InSequence(value=2)
    public void callOverloadedTimedMethodOnce() {
        Assert.assertTrue((String)"Metrics are not registered correctly", (boolean)this.registry.getMetricIDs().containsAll(MetricsUtil.createMetricIDs(this.absoluteMetricNames())));
        this.bean.overloadedTimedMethod();
        this.bean.overloadedTimedMethod("string");
        this.bean.overloadedTimedMethod(new Object());
        this.bean.overloadedTimedMethod(Arrays.asList("string1", "string2"));
        Assert.assertThat((String)"Timer counts are incorrect", this.registry.getTimers().values(), (Matcher)Matchers.hasItem((Matcher)Matchers.hasProperty((String)"count", (Matcher)Matchers.equalTo((Object)1L))));
    }
}

