/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.metrics.tck.tags;

import javax.inject.Inject;
import org.eclipse.microprofile.metrics.MetricID;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.Tag;
import org.eclipse.microprofile.metrics.tck.tags.TimedTagMethodBean;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.junit.InSequence;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
public class TimedTagMethodBeanTest {
    private static final String TIMER_NAME = MetricRegistry.name(TimedTagMethodBean.class, (String[])new String[]{"timedMethod"});
    private static final Tag NUMBER_ONE_TAG = new Tag("number", "one");
    private static final Tag NUMBER_TWO_TAG = new Tag("number", "two");
    private static MetricID timerOneMID;
    private static MetricID timerTwoMID;
    @Inject
    private MetricRegistry registry;
    @Inject
    private TimedTagMethodBean bean;

    @Deployment
    static Archive<?> createTestArchive() {
        return ((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class)).addClass(TimedTagMethodBean.class)).addAsWebInfResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
    }

    @Before
    public void instantiateTest() {
        timerOneMID = new MetricID(TIMER_NAME, new Tag[]{NUMBER_ONE_TAG});
        timerTwoMID = new MetricID(TIMER_NAME, new Tag[]{NUMBER_TWO_TAG});
    }

    @Test
    @InSequence(value=1)
    public void timedTagMethodRegistered() {
        Assert.assertThat((String)"Timer is not registered correctly", (Object)this.registry.getTimer(timerOneMID), (Matcher)Matchers.notNullValue());
        Assert.assertThat((String)"Timer is not registered correctly", (Object)this.registry.getTimer(timerTwoMID), (Matcher)Matchers.notNullValue());
    }
}

