/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.metrics.tck;

import javax.inject.Inject;
import org.eclipse.microprofile.metrics.Counter;
import org.eclipse.microprofile.metrics.MetricID;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.Tag;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.junit.InSequence;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
public class MetricIDTest {
    @Inject
    private MetricRegistry registry;

    @Deployment
    public static WebArchive createDeployment() {
        return (WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class)).addAsWebInfResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
    }

    @Test
    @InSequence(value=1)
    public void removalTest() {
        Tag tagEarth = new Tag("planet", "earth");
        Tag tagRed = new Tag("colour", "red");
        Tag tagBlue = new Tag("colour", "blue");
        String counterName = "org.eclipse.microprofile.metrics.tck.MetricIDTest.counterColour";
        Counter counterColour = this.registry.counter(counterName);
        Counter counterRed = this.registry.counter(counterName, new Tag[]{tagEarth, tagRed});
        Counter counterBlue = this.registry.counter(counterName, new Tag[]{tagEarth, tagBlue});
        MetricID counterColourMID = new MetricID(counterName);
        MetricID counterRedMID = new MetricID(counterName, new Tag[]{tagEarth, tagRed});
        MetricID counterBlueMID = new MetricID(counterName, new Tag[]{tagEarth, tagRed});
        Assert.assertThat((String)"Counter is not registered correctly", (Object)this.registry.getCounters(), (Matcher)Matchers.hasKey((Object)counterColourMID));
        Assert.assertThat((String)"Counter is not registered correctly", (Object)this.registry.getCounters(), (Matcher)Matchers.hasKey((Object)counterRedMID));
        Assert.assertThat((String)"Counter is not registered correctly", (Object)this.registry.getCounters(), (Matcher)Matchers.hasKey((Object)counterBlueMID));
        this.registry.remove(counterColourMID);
        Assert.assertThat((String)"Registry did not remove metric", (Object)this.registry.getCounters().size(), (Matcher)Matchers.equalTo((Object)2));
        Assert.assertThat((String)"Counter is not registered correctly", (Object)this.registry.getCounters(), (Matcher)Matchers.not((Matcher)Matchers.hasKey((Object)counterColourMID)));
        this.registry.remove(counterName);
        Assert.assertThat((String)"Counter is not registered correctly", (Object)this.registry.getCounters(), (Matcher)Matchers.not((Matcher)Matchers.hasKey((Object)counterRedMID)));
        Assert.assertThat((String)"Counter is not registered correctly", (Object)this.registry.getCounters(), (Matcher)Matchers.not((Matcher)Matchers.hasKey((Object)counterBlueMID)));
    }
}

