/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.metrics.tck.metrics;

import java.util.concurrent.TimeoutException;
import javax.inject.Inject;
import org.eclipse.microprofile.metrics.ConcurrentGauge;
import org.eclipse.microprofile.metrics.MetricID;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.tck.metrics.ConcurrentGaugeFunctionalBean;
import org.eclipse.microprofile.metrics.tck.util.BeanWithControlledInvocation;
import org.eclipse.microprofile.metrics.tck.util.ControlledInvocation;
import org.eclipse.microprofile.metrics.tck.util.TimeUtil;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.junit.InSequence;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
public class ConcurrentGaugeFunctionalTest {
    @Inject
    private MetricRegistry metricRegistry;
    @Inject
    private ConcurrentGaugeFunctionalBean bean;
    static final int NUMBER_OF_INVOCATIONS = 20;

    @Deployment
    static Archive<?> createTestArchive() {
        return ((WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class)).addClass(ConcurrentGaugeFunctionalTest.class)).addClass(ConcurrentGaugeFunctionalBean.class)).addClass(BeanWithControlledInvocation.class)).addClass(ControlledInvocation.class)).addClass(TimeUtil.class)).addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
    }

    @Test
    @InSequence(value=1)
    public void testMinMax() throws TimeoutException, InterruptedException {
        ControlledInvocation invocation1 = new ControlledInvocation(this.bean);
        ControlledInvocation invocation2 = new ControlledInvocation(this.bean);
        invocation1.start();
        try {
            TimeUtil.waitForNextMinute();
            invocation2 = new ControlledInvocation(this.bean);
            invocation2.start();
            invocation2.stop();
            TimeUtil.waitForNextMinute();
            invocation1.stop();
            Assert.assertEquals((String)"Minimum should be 1 ", (long)1L, (long)((ConcurrentGauge)this.metricRegistry.getConcurrentGauges().get(new MetricID("mygauge"))).getMin());
            Assert.assertEquals((String)"Maximum should be 2", (long)2L, (long)((ConcurrentGauge)this.metricRegistry.getConcurrentGauges().get(new MetricID("mygauge"))).getMax());
        }
        finally {
            invocation1.stop();
            invocation2.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @InSequence(value=2)
    public void testConcurrentInvocations() throws InterruptedException, TimeoutException {
        ControlledInvocation[] invocations = new ControlledInvocation[20];
        try {
            int i;
            for (i = 0; i < 20; ++i) {
                invocations[i] = new ControlledInvocation(this.bean);
                invocations[i].start();
                Assert.assertEquals((long)(i + 1), (long)((ConcurrentGauge)this.metricRegistry.getConcurrentGauges().get(new MetricID("mygauge"))).getCount());
            }
            for (i = 0; i < 20; ++i) {
                invocations[i].stop();
                Assert.assertEquals((long)(20 - i - 1), (long)((ConcurrentGauge)this.metricRegistry.getConcurrentGauges().get(new MetricID("mygauge"))).getCount());
            }
        }
        finally {
            try {
                for (ControlledInvocation invocation : invocations) {
                    invocation.stop();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

