/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.metrics.tck.cdi.stereotype;

import javax.inject.Inject;
import org.eclipse.microprofile.metrics.Counter;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.MetricID;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.tck.cdi.stereotype.StereotypeCountedClassBean;
import org.eclipse.microprofile.metrics.tck.cdi.stereotype.StereotypeCountedClassBeanWithSpecifiedMetadata;
import org.eclipse.microprofile.metrics.tck.cdi.stereotype.stereotypes.CountMe;
import org.eclipse.microprofile.metrics.tck.cdi.stereotype.stereotypes.CountMeWithSpecifiedMetadata;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
public class StereotypeCountedClassBeanTest {
    @Inject
    private MetricRegistry metricRegistry;
    @Inject
    private StereotypeCountedClassBean bean;
    @Inject
    private StereotypeCountedClassBeanWithSpecifiedMetadata beanWithSpecifiedMetadata;

    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class)).addAsWebInfResource((Asset)EmptyAsset.INSTANCE, "beans.xml")).addClasses(new Class[]{StereotypeCountedClassBean.class, StereotypeCountedClassBeanWithSpecifiedMetadata.class, CountMe.class, CountMeWithSpecifiedMetadata.class});
    }

    @Test
    public void testPlainAnnotation() {
        MetricID constructorMetricId = new MetricID(StereotypeCountedClassBean.class.getName() + ".StereotypeCountedClassBean");
        Assert.assertTrue((boolean)this.metricRegistry.getCounters().containsKey(constructorMetricId));
        MetricID methodMetricId = new MetricID(StereotypeCountedClassBean.class.getName() + ".foo");
        Assert.assertTrue((boolean)this.metricRegistry.getCounters().containsKey(methodMetricId));
        this.bean.foo();
        Assert.assertEquals((long)1L, (long)((Counter)this.metricRegistry.getCounters().get(methodMetricId)).getCount());
    }

    @Test
    public void testWithMetadata() {
        String constructorMetricName = "org.eclipse.microprofile.metrics.tck.cdi.stereotype.bloop.StereotypeCountedClassBeanWithSpecifiedMetadata";
        MetricID constructorMetricId = new MetricID(constructorMetricName);
        Assert.assertTrue((boolean)this.metricRegistry.getCounters().containsKey(constructorMetricId));
        Metadata constructorMetadata = (Metadata)this.metricRegistry.getMetadata().get(constructorMetricName);
        Assert.assertEquals((Object)"description", constructorMetadata.getDescription().orElse(null));
        Assert.assertEquals((Object)"displayName", (Object)constructorMetadata.getDisplayName());
        String methodMetricName = "org.eclipse.microprofile.metrics.tck.cdi.stereotype.bloop.foo";
        MetricID methodMetricId = new MetricID(methodMetricName);
        Assert.assertTrue((boolean)this.metricRegistry.getCounters().containsKey(methodMetricId));
        Metadata methodMetadata = (Metadata)this.metricRegistry.getMetadata().get(methodMetricName);
        Assert.assertEquals((Object)"description", methodMetadata.getDescription().orElse(null));
        Assert.assertEquals((Object)"displayName", (Object)methodMetadata.getDisplayName());
        this.beanWithSpecifiedMetadata.foo();
        Assert.assertEquals((long)1L, (long)((Counter)this.metricRegistry.getCounters().get(methodMetricId)).getCount());
    }
}

