/*
 * Decompiled with CFR 0.152.
 */
package io.astefanutti.metrics.cdi.se;

import io.astefanutti.metrics.cdi.se.MultipleMetricsConstructorBean;
import io.astefanutti.metrics.cdi.se.util.MetricsUtil;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.eclipse.microprofile.metrics.Counter;
import org.eclipse.microprofile.metrics.Meter;
import org.eclipse.microprofile.metrics.MetricID;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.Timer;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.junit.InSequence;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
public class MultipleMetricsConstructorBeanTest {
    @Inject
    private MetricRegistry registry;
    @Inject
    private Instance<MultipleMetricsConstructorBean> instance;

    private String absoluteMetricName(String name) {
        return MetricsUtil.absoluteMetricName(MultipleMetricsConstructorBean.class, name);
    }

    @Deployment
    static Archive<?> createTestArchive() {
        return ((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class)).addClasses(new Class[]{MultipleMetricsConstructorBean.class, MetricsUtil.class})).addAsWebInfResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
    }

    @Test
    @InSequence(value=1)
    public void metricsConstructorCalled() {
        long count = 1L + Math.round(Math.random() * 10.0);
        int i = 0;
        while ((long)i < count) {
            this.instance.get();
            ++i;
        }
        Assert.assertThat((String)"Counter count is incorrect", (Object)((Counter)this.registry.getCounters().get(new MetricID(this.absoluteMetricName("counter")))).getCount(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)count)));
        Assert.assertThat((String)"Meter count is incorrect", (Object)((Meter)this.registry.getMeters().get(new MetricID(this.absoluteMetricName("meter")))).getCount(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)count)));
        Assert.assertThat((String)"Timer count is incorrect", (Object)((Timer)this.registry.getTimers().get(new MetricID(this.absoluteMetricName("timer")))).getCount(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)count)));
    }
}

