/*
 * Decompiled with CFR 0.152.
 */
package io.astefanutti.metrics.cdi.se;

import io.astefanutti.metrics.cdi.se.HistogramFieldBean;
import javax.inject.Inject;
import org.eclipse.microprofile.metrics.Histogram;
import org.eclipse.microprofile.metrics.MetricID;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.junit.InSequence;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
public class HistogramFieldBeanTest {
    private static final String HISTOGRAM_NAME = MetricRegistry.name(HistogramFieldBean.class, (String[])new String[]{"histogramName"});
    private static MetricID histogramMID;
    @Inject
    private MetricRegistry registry;
    @Inject
    private HistogramFieldBean bean;

    @Deployment
    static Archive<?> createTestArchive() {
        return ((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class)).addClass(HistogramFieldBean.class)).addAsWebInfResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
    }

    @Before
    public void instantiateTest() {
        histogramMID = new MetricID(HISTOGRAM_NAME);
    }

    @Test
    @InSequence(value=1)
    public void histogramFieldRegistered() {
        Assert.assertThat((String)"Histogram is not registered correctly", (Object)this.registry.getHistograms(), (Matcher)Matchers.hasKey((Object)histogramMID));
    }

    @Test
    @InSequence(value=2)
    public void updateHistogramField() {
        Assert.assertThat((String)"Histogram is not registered correctly", (Object)this.registry.getHistograms(), (Matcher)Matchers.hasKey((Object)histogramMID));
        Histogram histogram = (Histogram)this.registry.getHistograms().get(histogramMID);
        long value = Math.round(Math.random() * 9.223372036854776E18);
        this.bean.update(value);
        Assert.assertThat((String)"Histogram count is incorrect", (Object)histogram.getCount(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)1L)));
        Assert.assertThat((String)"Histogram size is incorrect", (Object)histogram.getSnapshot().size(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)1)));
        Assert.assertThat((String)"Histogram min value is incorrect", (Object)histogram.getSnapshot().getMin(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)value)));
        Assert.assertThat((String)"Histogram max value is incorrect", (Object)histogram.getSnapshot().getMax(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)value)));
    }
}

