/*
 * Decompiled with CFR 0.152.
 */
package io.astefanutti.metrics.cdi.se;

import io.astefanutti.metrics.cdi.se.MonotonicCountedClassBean;
import io.astefanutti.metrics.cdi.se.util.MetricsUtil;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import javax.inject.Inject;
import org.eclipse.microprofile.metrics.Counter;
import org.eclipse.microprofile.metrics.Metric;
import org.eclipse.microprofile.metrics.MetricFilter;
import org.eclipse.microprofile.metrics.MetricID;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.junit.InSequence;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
public class MonotonicCountedClassBeanTest {
    private static final String CONSTRUCTOR_NAME = "MonotonicCountedClassBean";
    private static final String CONSTRUCTOR_COUNTER_NAME = MetricsUtil.absoluteMetricName(MonotonicCountedClassBean.class, "monotonicCountedClass", "MonotonicCountedClassBean");
    private static final MetricID CONSTRUCTOR_METRICID = new MetricID(CONSTRUCTOR_COUNTER_NAME);
    private static final String[] METHOD_NAMES = new String[]{"countedMethodOne", "countedMethodTwo", "countedMethodProtected", "countedMethodPackagedPrivate"};
    private static final Set<String> METHOD_COUNTER_NAMES = MetricsUtil.absoluteMetricNames(MonotonicCountedClassBean.class, "monotonicCountedClass", METHOD_NAMES);
    private static final Set<String> COUNTER_NAMES = MetricsUtil.absoluteMetricNames(MonotonicCountedClassBean.class, "monotonicCountedClass", METHOD_NAMES, new String[]{"MonotonicCountedClassBean"});
    private static final Set<MetricID> COUNTER_METRICIDS = MetricsUtil.createMetricIDs(COUNTER_NAMES);
    private static final MetricFilter METHOD_COUNTERS = new MetricFilter(){

        public boolean matches(MetricID metricID, Metric metric) {
            return METHOD_COUNTER_NAMES.contains(metricID.getName());
        }
    };
    private static final AtomicLong CONSTRUCTOR_COUNT = new AtomicLong();
    @Inject
    private MetricRegistry registry;
    @Inject
    private MonotonicCountedClassBean bean;

    @Deployment
    static Archive<?> createTestArchive() {
        return ((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class)).addClasses(new Class[]{MonotonicCountedClassBean.class, MetricsUtil.class})).addAsWebInfResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
    }

    @Test
    @InSequence(value=1)
    public void countedMethodsNotCalledYet() {
        Assert.assertThat((String)"Counters are not registered correctly", this.registry.getCounters().keySet(), (Matcher)Matchers.is((Matcher)Matchers.equalTo(COUNTER_METRICIDS)));
        Assert.assertThat((String)"Constructor timer count is incorrect", (Object)((Counter)this.registry.getCounters().get(CONSTRUCTOR_METRICID)).getCount(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)CONSTRUCTOR_COUNT.incrementAndGet())));
        Assert.assertThat((String)"Method counter counts are incorrect", this.registry.getCounters(METHOD_COUNTERS).values(), (Matcher)Matchers.everyItem((Matcher)Matchers.hasProperty((String)"count", (Matcher)Matchers.equalTo((Object)0L))));
    }

    @Test
    @InSequence(value=2)
    public void callCountedMethodsOnce() {
        Assert.assertThat((String)"Counters are not registered correctly", this.registry.getCounters().keySet(), (Matcher)Matchers.is((Matcher)Matchers.equalTo(COUNTER_METRICIDS)));
        Assert.assertThat((String)"Constructor timer count is incorrect", (Object)((Counter)this.registry.getCounters().get(CONSTRUCTOR_METRICID)).getCount(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)CONSTRUCTOR_COUNT.incrementAndGet())));
        this.bean.countedMethodOne();
        this.bean.countedMethodTwo();
        this.bean.countedMethodProtected();
        this.bean.countedMethodPackagedPrivate();
        Assert.assertThat((String)"Method counter counts are incorrect", this.registry.getCounters(METHOD_COUNTERS).values(), (Matcher)Matchers.everyItem((Matcher)Matchers.hasProperty((String)"count", (Matcher)Matchers.equalTo((Object)1L))));
    }
}

