/*
 * Decompiled with CFR 0.152.
 */
package io.astefanutti.metrics.cdi.se;

import io.astefanutti.metrics.cdi.se.GaugeMethodBean;
import io.astefanutti.metrics.cdi.se.InheritedChildGaugeMethodBean;
import io.astefanutti.metrics.cdi.se.InheritedParentGaugeMethodBean;
import java.util.Arrays;
import javax.inject.Inject;
import org.eclipse.microprofile.metrics.Gauge;
import org.eclipse.microprofile.metrics.MetricID;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.junit.InSequence;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
public class InheritedGaugeMethodBeanTest {
    private static final String PARENT_GAUGE_NAME = MetricRegistry.name(InheritedParentGaugeMethodBean.class, (String[])new String[]{"inheritedParentGaugeMethod"});
    private static final String CHILD_GAUGE_NAME = MetricRegistry.name(InheritedChildGaugeMethodBean.class, (String[])new String[]{"inheritedChildGaugeMethod"});
    private static final MetricID PARENT_METRICID = new MetricID(PARENT_GAUGE_NAME);
    private static final MetricID CHILD_METRICID = new MetricID(CHILD_GAUGE_NAME);
    @Inject
    private MetricRegistry registry;
    @Inject
    private InheritedChildGaugeMethodBean bean;
    @Inject
    private InheritedParentGaugeMethodBean pBean;

    @Deployment
    public static Archive<?> createTestArchive() {
        return ((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class)).addClasses(new Class[]{GaugeMethodBean.class, InheritedParentGaugeMethodBean.class, InheritedChildGaugeMethodBean.class})).addAsWebInfResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
    }

    @Before
    public void instantiateApplicationScopedBean() {
        this.pBean.getGauge();
        this.bean.getChildGauge();
    }

    @Test
    @InSequence(value=1)
    public void gaugesCalledWithDefaultValues() {
        Assert.assertThat((String)"Gauges are not registered correctly", (Object)this.registry.getGauges(), (Matcher)Matchers.allOf((Matcher)Matchers.hasKey((Object)PARENT_METRICID), (Matcher)Matchers.hasKey((Object)CHILD_METRICID)));
        Gauge parentGauge = (Gauge)this.registry.getGauges().get(PARENT_METRICID);
        Gauge childGauge = (Gauge)this.registry.getGauges().get(CHILD_METRICID);
        Assert.assertThat((String)"Gauge values are incorrect", Arrays.asList((Long)parentGauge.getValue(), (Long)childGauge.getValue()), (Matcher)Matchers.contains((Object[])new Long[]{0L, 0L}));
    }

    @Test
    @InSequence(value=2)
    public void callGaugesAfterSetterCalls() {
        Assert.assertThat((String)"Gauges are not registered correctly", (Object)this.registry.getGauges(), (Matcher)Matchers.allOf((Matcher)Matchers.hasKey((Object)PARENT_METRICID), (Matcher)Matchers.hasKey((Object)CHILD_METRICID)));
        Gauge parentGauge = (Gauge)this.registry.getGauges().get(PARENT_METRICID);
        Gauge childGauge = (Gauge)this.registry.getGauges().get(CHILD_METRICID);
        long parentValue = Math.round(Math.random() * 9.223372036854776E18);
        this.pBean.setGauge(parentValue);
        long childValue = Math.round(Math.random() * 9.223372036854776E18);
        this.bean.setChildGauge(childValue);
        Assert.assertThat((String)"Gauge values are incorrect", Arrays.asList((Long)parentGauge.getValue(), (Long)childGauge.getValue()), (Matcher)Matchers.contains((Object[])new Long[]{parentValue, childValue}));
    }
}

