/*
 * Decompiled with CFR 0.152.
 */
package io.astefanutti.metrics.cdi.se;

import io.astefanutti.metrics.cdi.se.CounterFieldBean;
import javax.inject.Inject;
import org.eclipse.microprofile.metrics.Counter;
import org.eclipse.microprofile.metrics.MetricID;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.junit.InSequence;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
public class CounterFieldBeanTest {
    private static final String COUNTER_NAME = MetricRegistry.name(CounterFieldBean.class, (String[])new String[]{"counterName"});
    private static final MetricID COUNTER_METRICID = new MetricID(COUNTER_NAME);
    @Inject
    private MetricRegistry registry;
    @Inject
    private CounterFieldBean bean;

    @Deployment
    public static Archive<?> createTestArchive() {
        return ((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class)).addClass(CounterFieldBean.class)).addAsWebInfResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
    }

    @Test
    @InSequence(value=1)
    public void counterFieldRegistered() {
        Assert.assertThat((String)"Counter is not registered correctly", (Object)this.registry.getCounters(), (Matcher)Matchers.hasKey((Object)COUNTER_METRICID));
    }

    @Test
    @InSequence(value=2)
    public void incrementCounterField() {
        Assert.assertThat((String)"Counter is not registered correctly", (Object)this.registry.getCounters(), (Matcher)Matchers.hasKey((Object)COUNTER_METRICID));
        Counter counter = (Counter)this.registry.getCounters().get(COUNTER_METRICID);
        long value = Math.round(Math.random() * 9.223372036854776E18);
        this.bean.increment(value);
        Assert.assertThat((String)"Counter value is incorrect", (Object)counter.getCount(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)value)));
    }
}

