/*
 * Decompiled with CFR 0.152.
 */
package io.astefanutti.metrics.cdi.se;

import io.astefanutti.metrics.cdi.se.CountedMethodTagBean;
import javax.inject.Inject;
import org.eclipse.microprofile.metrics.Counter;
import org.eclipse.microprofile.metrics.MetricID;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.Tag;
import org.eclipse.microprofile.metrics.annotation.Metric;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.junit.InSequence;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
public class CountedMethodTagBeanTest {
    private static final String COUNTER_NAME = "countedMethod";
    private static final Tag NUMBER_ONE_TAG = new Tag("number", "one");
    private static final Tag NUMBER_TWO_TAG = new Tag("number", "two");
    private static final MetricID COUNTER_ONE_MID = new MetricID("countedMethod", new Tag[]{NUMBER_ONE_TAG});
    private static final MetricID COUNTER_TWO_MID = new MetricID("countedMethod", new Tag[]{NUMBER_TWO_TAG});
    @Inject
    private MetricRegistry registry;
    @Inject
    private CountedMethodTagBean bean;

    @Deployment
    static Archive<?> createTestArchive() {
        return ((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class)).addClass(CountedMethodTagBean.class)).addAsWebInfResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
    }

    @Test
    @InSequence(value=1)
    public void counterTagMethodsRegistered() {
        Assert.assertThat((String)"Counter is not registered correctly", (Object)this.registry.getCounters(), (Matcher)Matchers.hasKey((Object)COUNTER_ONE_MID));
        Assert.assertThat((String)"Counter is not registered correctly", (Object)this.registry.getCounters(), (Matcher)Matchers.hasKey((Object)COUNTER_TWO_MID));
    }

    @Test
    @InSequence(value=2)
    public void countedTagMethodNotCalledYet(@Metric(name="countedMethod", absolute=true, tags={"number=one"}) Counter instanceOne, @Metric(name="countedMethod", absolute=true, tags={"number=two"}) Counter instanceTwo) {
        Assert.assertThat((String)"Counter is not registered correctly", (Object)this.registry.getCounters(), (Matcher)Matchers.hasKey((Object)COUNTER_ONE_MID));
        Assert.assertThat((String)"Counter is not registered correctly", (Object)this.registry.getCounters(), (Matcher)Matchers.hasKey((Object)COUNTER_TWO_MID));
        Counter counterOne = (Counter)this.registry.getCounters().get(COUNTER_ONE_MID);
        Counter counterTwo = (Counter)this.registry.getCounters().get(COUNTER_TWO_MID);
        Assert.assertThat((String)"Counter and bean instance are not equal", (Object)instanceOne, (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)counterOne)));
        Assert.assertThat((String)"Counter and bean instance are not equal", (Object)instanceTwo, (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)counterTwo)));
    }
}

