/*
 * Decompiled with CFR 0.152.
 */
package io.astefanutti.metrics.cdi.se;

import io.astefanutti.metrics.cdi.se.ConcurrentGaugedMethodBean;
import java.util.concurrent.Callable;
import java.util.concurrent.Exchanger;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.inject.Inject;
import org.eclipse.microprofile.metrics.ConcurrentGauge;
import org.eclipse.microprofile.metrics.MetricID;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.annotation.Metric;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.junit.InSequence;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
public class ConcurrentGaugedMethodBeanTest {
    private static final String C_GAUGE_NAME = "cGaugedMethod";
    private static final MetricID C_GAUGE_METRICID = new MetricID("cGaugedMethod");
    private static final AtomicLong COUNTER_COUNT = new AtomicLong();
    @Inject
    private MetricRegistry registry;
    @Inject
    private ConcurrentGaugedMethodBean<Long> bean;

    @Deployment
    static Archive<?> createTestArchive() {
        return ((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class)).addClass(ConcurrentGaugedMethodBean.class)).addAsWebInfResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
    }

    @Test
    @InSequence(value=1)
    public void countedMethodNotCalledYet() {
        Assert.assertThat((String)"Concurrent Gauges is not registered correctly", (Object)this.registry.getConcurrentGauges(), (Matcher)Matchers.hasKey((Object)C_GAUGE_METRICID));
        ConcurrentGauge counter = (ConcurrentGauge)this.registry.getConcurrentGauges().get(C_GAUGE_METRICID);
        Assert.assertThat((String)"Concurrent Gauges count is incorrect", (Object)counter.getCount(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)COUNTER_COUNT.get())));
    }

    @Test
    @InSequence(value=2)
    public void countedMethodNotCalledYet(@Metric(name="cGaugedMethod", absolute=true) ConcurrentGauge instance) {
        Assert.assertThat((String)"Concurrent Gauges is not registered correctly", (Object)this.registry.getConcurrentGauges(), (Matcher)Matchers.hasKey((Object)C_GAUGE_METRICID));
        ConcurrentGauge cGauge = (ConcurrentGauge)this.registry.getConcurrentGauges().get(C_GAUGE_METRICID);
        Assert.assertThat((String)"Concurrent Gauges and bean instance are not equal", (Object)instance, (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)cGauge)));
    }

    @Test
    @InSequence(value=3)
    public void callCountedMethodOnce() throws InterruptedException, TimeoutException {
        Assert.assertThat((String)"Concurrent Gauges is not registered correctly", (Object)this.registry.getConcurrentGauges(), (Matcher)Matchers.hasKey((Object)C_GAUGE_METRICID));
        ConcurrentGauge counter = (ConcurrentGauge)this.registry.getConcurrentGauges().get(C_GAUGE_METRICID);
        final Exchanger<Long> exchanger = new Exchanger<Long>();
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    exchanger.exchange(ConcurrentGaugedMethodBeanTest.this.bean.countedMethod(new Callable<Long>(){

                        @Override
                        public Long call() throws Exception {
                            exchanger.exchange(0L);
                            return exchanger.exchange(0L);
                        }
                    }));
                }
                catch (InterruptedException cause) {
                    throw new RuntimeException(cause);
                }
            }
        });
        final AtomicInteger uncaught = new AtomicInteger();
        thread.setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                uncaught.incrementAndGet();
            }
        });
        thread.start();
        exchanger.exchange(0L, 5L, TimeUnit.SECONDS);
        Assert.assertThat((String)"Concurrent Gauges count is incorrect", (Object)counter.getCount(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)COUNTER_COUNT.incrementAndGet())));
        Long random = 1L + Math.round(Math.random() * 9.223372036854776E18);
        exchanger.exchange(random, 5L, TimeUnit.SECONDS);
        Assert.assertThat((String)"Concurrent Gauges method return value is incorrect", (Object)exchanger.exchange(0L), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)random)));
        Assert.assertThat((String)"Concurrent Gauges count is incorrect", (Object)counter.getCount(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)COUNTER_COUNT.decrementAndGet())));
        Assert.assertThat((String)"Concurrent Gauges max is incorrect", (Object)counter.getMax(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)1)));
        thread.join();
        Assert.assertThat((String)"Exception thrown in method call thread", (Object)uncaught.get(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)0)));
    }

    @Test
    @InSequence(value=4)
    public void removeCounterFromRegistry() {
        Assert.assertThat((String)"Concurrent Gauges is not registered correctly", (Object)this.registry.getConcurrentGauges(), (Matcher)Matchers.hasKey((Object)C_GAUGE_METRICID));
        ConcurrentGauge counter = (ConcurrentGauge)this.registry.getConcurrentGauges().get(C_GAUGE_METRICID);
        this.registry.remove(C_GAUGE_METRICID);
        try {
            this.bean.countedMethod(new Callable<Long>(){

                @Override
                public Long call() throws Exception {
                    return null;
                }
            });
        }
        catch (Exception cause) {
            Assert.assertThat((Object)cause, (Matcher)Matchers.is((Matcher)Matchers.instanceOf(IllegalStateException.class)));
            Assert.assertThat((Object)cause.getMessage(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)("No concurrent gauge with name [cGaugedMethod] found in registry [" + this.registry + "]"))));
            Assert.assertThat((String)"Concurrent Gauges count is incorrect", (Object)counter.getCount(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)COUNTER_COUNT.get())));
            return;
        }
        Assert.fail((String)"No exception has been re-thrown!");
    }
}

