/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.metrics.tck;

import javax.inject.Inject;
import org.eclipse.microprofile.metrics.Counter;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.junit.InSequence;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
public class CounterTest {
    @Inject
    private Counter count;

    @Deployment
    public static JavaArchive createDeployment() {
        return (JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class)).addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
    }

    @Test
    @InSequence(value=1)
    public void getCountTest() {
        Assert.assertEquals((long)0L, (long)this.count.getCount());
    }

    @Test
    @InSequence(value=2)
    public void incrementTest() {
        this.count.inc();
        Assert.assertEquals((long)1L, (long)this.count.getCount());
    }

    @Test
    @InSequence(value=3)
    public void incrementLongTest() {
        this.count.inc(4L);
        Assert.assertEquals((long)5L, (long)this.count.getCount());
    }

    @Test
    @InSequence(value=4)
    public void decrementTest() {
        this.count.dec();
        Assert.assertEquals((long)4L, (long)this.count.getCount());
    }

    @Test
    @InSequence(value=5)
    public void decrementLongTest() {
        this.count.dec(4L);
        Assert.assertEquals((long)0L, (long)this.count.getCount());
    }
}

