/*
 * Decompiled with CFR 0.152.
 */
package io.astefanutti.metrics.cdi.se;

import io.astefanutti.metrics.cdi.se.VisibilityTimedMethodBean;
import io.astefanutti.metrics.cdi.se.util.MetricsUtil;
import java.util.Set;
import javax.inject.Inject;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.junit.InSequence;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
public class VisibilityTimedMethodBeanTest {
    private static final String[] TIMER_NAMES = new String[]{"publicTimedMethod", "packagePrivateTimedMethod", "protectedTimedMethod"};
    @Inject
    private MetricRegistry registry;
    @Inject
    private VisibilityTimedMethodBean bean;

    private Set<String> absoluteMetricNames() {
        return MetricsUtil.absoluteMetricNames(VisibilityTimedMethodBean.class, TIMER_NAMES);
    }

    @Deployment
    static Archive<?> createTestArchive() {
        return ((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class)).addClasses(new Class[]{VisibilityTimedMethodBean.class, MetricsUtil.class})).addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
    }

    @Test
    @InSequence(value=1)
    public void timedMethodsNotCalledYet() {
        Assert.assertThat((String)"Timers are not registered correctly", this.registry.getTimers().keySet(), (Matcher)Matchers.is((Matcher)Matchers.equalTo(this.absoluteMetricNames())));
        Assert.assertThat((String)"Timer counts are incorrect", this.registry.getTimers().values(), (Matcher)Matchers.everyItem((Matcher)Matchers.hasProperty((String)"count", (Matcher)Matchers.equalTo((Object)0L))));
    }

    @Test
    @InSequence(value=2)
    public void callTimedMethodsOnce() {
        Assert.assertThat((String)"Timers are not registered correctly", this.registry.getTimers().keySet(), (Matcher)Matchers.is((Matcher)Matchers.equalTo(this.absoluteMetricNames())));
        this.bean.publicTimedMethod();
        this.bean.protectedTimedMethod();
        this.bean.packagePrivateTimedMethod();
        Assert.assertThat((String)"Timer counts are incorrect", this.registry.getTimers().values(), (Matcher)Matchers.everyItem((Matcher)Matchers.hasProperty((String)"count", (Matcher)Matchers.equalTo((Object)1L))));
    }
}

