/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.metrics.tck;

import javax.inject.Inject;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.MetricFilter;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.MetricType;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
public class GlobalTagsTest {
    @Inject
    private MetricRegistry registry;

    @Deployment
    public static WebArchive createDeployment() {
        return (WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class)).addAsWebInfResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
    }

    @After
    public void cleanupApplicationMetrics() {
        this.registry.removeMatching(MetricFilter.ALL);
    }

    @Test
    public void fromEnvVariable() {
        Metadata metadata = new Metadata("mycounter", MetricType.COUNTER);
        metadata.addTags("key1=value1");
        this.registry.counter(metadata);
        Metadata actualMetadata = (Metadata)this.registry.getMetadata().get("mycounter");
        Assert.assertEquals((Object)"value1", actualMetadata.getTags().get("key1"));
        Assert.assertEquals((Object)"integration", actualMetadata.getTags().get("tier"));
    }
}

