/*
 * Decompiled with CFR 0.152.
 */
package io.astefanutti.metrics.cdi.se;

import io.astefanutti.metrics.cdi.se.MetricProducerFieldBean;
import javax.inject.Inject;
import org.eclipse.microprofile.metrics.Counter;
import org.eclipse.microprofile.metrics.Gauge;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.annotation.Metric;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.junit.InSequence;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
public class MetricProducerFieldBeanTest {
    @Inject
    private MetricRegistry registry;

    @Deployment
    static Archive<?> createTestArchive() {
        return ((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class)).addClass(MetricProducerFieldBean.class)).addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
    }

    @Test
    @InSequence(value=1)
    public void countersNotIncrementedYet() {
        Assert.assertThat((String)"Counters are not registered correctly", (Object)this.registry.getCounters(), (Matcher)Matchers.allOf((Matcher)Matchers.hasKey((Object)"counter1"), (Matcher)Matchers.hasKey((Object)"counter2"), (Matcher)Matchers.not((Matcher)Matchers.hasKey((Object)"not_registered_counter"))));
        Counter counter1 = (Counter)this.registry.getCounters().get("counter1");
        Counter counter2 = (Counter)this.registry.getCounters().get("counter2");
        Assert.assertThat((String)"Gauge is not registered correctly", (Object)this.registry.getGauges(), (Matcher)Matchers.hasKey((Object)"ratioGauge"));
        Gauge gauge = (Gauge)this.registry.getGauges().get("ratioGauge");
        Assert.assertThat((String)"Gauge value is incorrect", (Object)gauge.getValue(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)((double)counter1.getCount() / (double)counter2.getCount()))));
    }

    @Test
    @InSequence(value=2)
    public void incrementCountersFromRegistry() {
        Assert.assertThat((String)"Counters are not registered correctly", (Object)this.registry.getCounters(), (Matcher)Matchers.allOf((Matcher)Matchers.hasKey((Object)"counter1"), (Matcher)Matchers.hasKey((Object)"counter2"), (Matcher)Matchers.not((Matcher)Matchers.hasKey((Object)"not_registered_counter"))));
        Counter counter1 = (Counter)this.registry.getCounters().get("counter1");
        Counter counter2 = (Counter)this.registry.getCounters().get("counter2");
        Assert.assertThat((String)"Gauge is not registered correctly", (Object)this.registry.getGauges(), (Matcher)Matchers.hasKey((Object)"ratioGauge"));
        Gauge gauge = (Gauge)this.registry.getGauges().get("ratioGauge");
        counter1.inc(Math.round(Math.random() * 2.147483647E9));
        counter2.inc(Math.round(Math.random() * 2.147483647E9));
        Assert.assertThat((String)"Gauge value is incorrect", (Object)gauge.getValue(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)((double)counter1.getCount() / (double)counter2.getCount()))));
    }

    @Test
    @InSequence(value=3)
    public void incrementCountersFromInjection(@Metric(name="ratioGauge", absolute=true) Gauge<Double> gauge, @Metric(name="counter1", absolute=true) Counter counter1, @Metric(name="counter2", absolute=true) Counter counter2) {
        counter1.inc(Math.round(Math.random() * 2.147483647E9));
        counter2.inc(Math.round(Math.random() * 2.147483647E9));
        Assert.assertThat((String)"Gauge value is incorrect", (Object)gauge.getValue(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)((double)counter1.getCount() / (double)counter2.getCount()))));
        Assert.assertThat((String)"Gauge is not registered correctly", (Object)this.registry.getGauges(), (Matcher)Matchers.hasKey((Object)"ratioGauge"));
        Gauge gaugeFromRegistry = (Gauge)this.registry.getGauges().get("ratioGauge");
        Assert.assertThat((String)"Gauge values from registry and injection do not match", (Object)gauge.getValue(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)gaugeFromRegistry.getValue())));
    }
}

